/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.jei.gas.GasStackRenderer;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class BaseRecipeCategory
implements IRecipeCategory<IRecipeWrapper>,
IGuiWrapper {
    private static final GuiDummy gui = new GuiDummy();
    protected IGuiHelper guiHelper;
    protected String guiTexture;
    protected ResourceLocation guiLocation;
    @Nullable
    protected GuiProgress.ProgressBar progressBar;
    protected ITickTimer timer;
    protected int xOffset = 28;
    protected int yOffset = 16;
    protected IDrawable fluidOverlayLarge;
    protected IDrawable fluidOverlaySmall;
    protected Set<GuiElement> guiElements = new HashSet<GuiElement>();
    private String recipeName;
    private String unlocalizedName;

    public BaseRecipeCategory(IGuiHelper helper, String gui, String name, String unlocalized, @Nullable GuiProgress.ProgressBar progress) {
        this.guiHelper = helper;
        this.guiTexture = gui;
        this.guiLocation = new ResourceLocation(this.guiTexture);
        this.progressBar = progress;
        this.recipeName = name;
        this.unlocalizedName = unlocalized;
        this.timer = helper.createTickTimer(20, 20, false);
        this.fluidOverlayLarge = this.guiHelper.createDrawable(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, GuiGauge.Type.STANDARD.textureLocation), 19, 1, 16, 59);
        this.fluidOverlaySmall = this.guiHelper.createDrawable(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, GuiGauge.Type.STANDARD.textureLocation), 19, 1, 16, 29);
        this.addGuiElements();
    }

    public String getUid() {
        return this.recipeName;
    }

    public String getTitle() {
        return LangUtils.localize(this.unlocalizedName);
    }

    public String getModName() {
        return "Mekanism";
    }

    public void drawExtras(Minecraft minecraft) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.changeTexture(this.guiLocation);
        for (GuiElement e : this.guiElements) {
            e.renderBackground(0, 0, -this.xOffset, -this.yOffset);
        }
    }

    @Override
    public void drawTexturedRect(int x, int y, int u, int v, int w, int h) {
        gui.func_73729_b(x, y, u, v, w, h);
    }

    @Override
    public void drawTexturedRectFromIcon(int x, int y, TextureAtlasSprite icon, int w, int h) {
        gui.func_175175_a(x, y, icon, w, h);
    }

    @Override
    public void displayTooltip(String s, int xAxis, int yAxis) {
    }

    @Override
    public void displayTooltips(List<String> list, int xAxis, int yAxis) {
    }

    @Override
    public FontRenderer getFont() {
        return null;
    }

    public String stripTexture() {
        return this.guiTexture.replace("mekanism:gui/", "");
    }

    public void changeTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public void addGuiElements() {
    }

    public IDrawable getIcon() {
        return null;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    protected void initGas(IGuiIngredientGroup<GasStack> group, int slot, boolean input, int x, int y, int width, int height, @Nullable GasStack stack, boolean overlay) {
        if (stack == null) {
            return;
        }
        IDrawable fluidOverlay = height > 50 ? this.fluidOverlayLarge : this.fluidOverlaySmall;
        GasStackRenderer renderer = new GasStackRenderer(stack.amount, false, width, height, (IDrawable)(overlay ? fluidOverlay : null));
        group.init(slot, input, (IIngredientRenderer)renderer, x, y, width, height, 0, 0);
        group.set(slot, (Object)stack);
    }

    protected void initGasPerTick(IGuiIngredientGroup<GasStack> group, int slot, boolean input, int x, int y, int width, int height, @Nullable GasStack stack, boolean overlay) {
        if (stack == null) {
            return;
        }
        IDrawable fluidOverlay = height > 50 ? this.fluidOverlayLarge : this.fluidOverlaySmall;
        GasStackRenderer renderer = new GasStackRenderer(stack.amount, GasStackRenderer.TooltipMode.AMOUNT_PER_TICK, width, height, (IDrawable)(overlay ? fluidOverlay : null));
        group.init(slot, input, (IIngredientRenderer)renderer, x, y, width, height, 0, 0);
        group.set(slot, (Object)stack);
    }

    public static class GuiDummy
    extends Gui {
    }
}

