/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config;

import java.util.EnumMap;
import mekanism.common.Tier;
import mekanism.common.config.BaseConfig;
import mekanism.common.config.DoubleOption;
import mekanism.common.config.IntOption;

public class TierConfig {
    public final DoubleOption EnergyCubeMaxEnergy;
    public final DoubleOption EnergyCubeOutput;
    public final DoubleOption InductionCellMaxEnergy;
    public final DoubleOption InductionProviderOutput;
    public final IntOption CableCapacity;
    public final IntOption PipeCapacity;
    public final IntOption PipePullAmount;
    public final IntOption TubeCapacity;
    public final IntOption TubePullAmount;
    public final IntOption TransporterPullAmount;
    public final IntOption TransporterSpeed;
    public final DoubleOption ConductorInverseConduction;
    public final DoubleOption ConductorHeatCapacity;
    public final DoubleOption ConductorConductionInsulation;
    public final IntOption FluidTankStorage;
    public final IntOption FluidTankOutput;
    public final IntOption GasTankStorage;
    public final IntOption GasTankOutput;
    public final IntOption BinStorage;

    private TierConfig(BaseConfig baseConfig, Tier.BaseTier tier) {
        this.EnergyCubeMaxEnergy = new DoubleOption(baseConfig, "tier", tier.getSimpleName() + "EnergyCubeMaxEnergy", Tier.EnergyCubeTier.values()[tier.ordinal()].baseMaxEnergy);
        this.EnergyCubeOutput = new DoubleOption(baseConfig, "tier", tier.getSimpleName() + "EnergyCubeOutput", Tier.EnergyCubeTier.values()[tier.ordinal()].baseOutput);
        this.FluidTankStorage = new IntOption(baseConfig, "tier", tier.getSimpleName() + "FluidTankStorage", Tier.FluidTankTier.values()[tier.ordinal()].baseStorage);
        this.FluidTankOutput = new IntOption(baseConfig, "tier", tier.getSimpleName() + "FluidTankOutput", Tier.FluidTankTier.values()[tier.ordinal()].baseOutput);
        this.GasTankStorage = new IntOption(baseConfig, "tier", tier.getSimpleName() + "GasTankStorage", Tier.GasTankTier.values()[tier.ordinal()].baseStorage);
        this.GasTankOutput = new IntOption(baseConfig, "tier", tier.getSimpleName() + "GasTankOutput", Tier.GasTankTier.values()[tier.ordinal()].baseOutput);
        this.BinStorage = new IntOption(baseConfig, "tier", tier.getSimpleName() + "BinStorage", Tier.BinTier.values()[tier.ordinal()].baseStorage);
        if (tier != Tier.BaseTier.CREATIVE) {
            this.InductionCellMaxEnergy = new DoubleOption(baseConfig, "tier", tier.getSimpleName() + "InductionCellMaxEnergy", Tier.InductionCellTier.values()[tier.ordinal()].baseMaxEnergy);
            this.InductionProviderOutput = new DoubleOption(baseConfig, "tier", tier.getSimpleName() + "InductionProviderOutput", Tier.InductionProviderTier.values()[tier.ordinal()].baseOutput);
            this.CableCapacity = new IntOption(baseConfig, "tier", tier.getSimpleName() + "CableCapacity", Tier.CableTier.values()[tier.ordinal()].baseCapacity);
            this.PipeCapacity = new IntOption(baseConfig, "tier", tier.getSimpleName() + "PipeCapacity", Tier.PipeTier.values()[tier.ordinal()].baseCapacity);
            this.PipePullAmount = new IntOption(baseConfig, "tier", tier.getSimpleName() + "PipePullAmount", Tier.PipeTier.values()[tier.ordinal()].basePull);
            this.TubeCapacity = new IntOption(baseConfig, "tier", tier.getSimpleName() + "TubeCapacity", Tier.TubeTier.values()[tier.ordinal()].baseCapacity);
            this.TubePullAmount = new IntOption(baseConfig, "tier", tier.getSimpleName() + "TubePullAmount", Tier.TubeTier.values()[tier.ordinal()].basePull);
            this.TransporterPullAmount = new IntOption(baseConfig, "tier", tier.getSimpleName() + "TransporterPullAmount", Tier.TransporterTier.values()[tier.ordinal()].basePull);
            this.TransporterSpeed = new IntOption(baseConfig, "tier", tier.getSimpleName() + "TransporterSpeed", Tier.TransporterTier.values()[tier.ordinal()].baseSpeed);
            this.ConductorInverseConduction = new DoubleOption(baseConfig, "tier", tier.getSimpleName() + "ConductorInverseConduction", Tier.ConductorTier.values()[tier.ordinal()].baseConduction);
            this.ConductorHeatCapacity = new DoubleOption(baseConfig, "tier", tier.getSimpleName() + "ConductorHeatCapacity", Tier.ConductorTier.values()[tier.ordinal()].baseHeatCapacity);
            this.ConductorConductionInsulation = new DoubleOption(baseConfig, "tier", tier.getSimpleName() + "ConductorConductionInsulation", Tier.ConductorTier.values()[tier.ordinal()].baseConductionInsulation);
        } else {
            this.InductionCellMaxEnergy = null;
            this.InductionProviderOutput = null;
            this.CableCapacity = null;
            this.PipeCapacity = null;
            this.PipePullAmount = null;
            this.TubeCapacity = null;
            this.TubePullAmount = null;
            this.TransporterPullAmount = null;
            this.TransporterSpeed = null;
            this.ConductorInverseConduction = null;
            this.ConductorHeatCapacity = null;
            this.ConductorConductionInsulation = null;
        }
    }

    public static EnumMap<Tier.BaseTier, TierConfig> create(BaseConfig baseConfig) {
        EnumMap<Tier.BaseTier, TierConfig> map = new EnumMap<Tier.BaseTier, TierConfig>(Tier.BaseTier.class);
        for (Tier.BaseTier baseTier : Tier.BaseTier.values()) {
            map.put(baseTier, new TierConfig(baseConfig, baseTier));
        }
        return map;
    }
}

