/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.generation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.gas.IGasItem;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.security.ISecurityItem;
import mekanism.common.util.FluidContainerUtils;
import mekanism.generators.common.block.states.BlockStateGenerator;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RecipeGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File RECIPE_DIR;

    public RecipeGenerator(String modid) {
        boolean success;
        this.RECIPE_DIR = new File("recipeoutput" + File.separator + modid);
        if (!this.RECIPE_DIR.exists() && !(success = this.RECIPE_DIR.mkdirs())) {
            throw new IllegalStateException("Cannot create recipe output dir!");
        }
    }

    public static Map<String, Object> serializeItem(Object thing) {
        if (thing instanceof Item) {
            return RecipeGenerator.serializeItem(new ItemStack((Item)thing));
        }
        if (thing instanceof Block) {
            return RecipeGenerator.serializeItem(new ItemStack((Block)thing));
        }
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                HashMap<String, Integer> tag = new HashMap<String, Integer>();
                NBTTagCompound compound = stack.func_77978_p();
                Set keySet = compound.func_150296_c();
                for (String key : keySet) {
                    if (key.equals("tier") || key.equals("recipeType")) {
                        tag.put(key, compound.func_74762_e(key));
                        continue;
                    }
                    if (key.equals("mekData")) continue;
                    throw new IllegalArgumentException("Missing NBT mapping for Key: " + key);
                }
                ret.put("type", "mekanism:item_nbt");
                ret.put("nbt", tag);
            }
            return ret;
        }
        if (thing instanceof String) {
            String oredict = (String)thing;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            if (oredict != null && (oredict.equals("circuitBasic") || oredict.equals("circuitAdvanced") || oredict.equals("circuitElite") || oredict.equals("circuitUltimate"))) {
                ret.put("item", "#" + oredict.toUpperCase());
            } else {
                ret.put("type", "forge:ore_dict");
                ret.put("ore", oredict);
            }
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name");
    }

    public void addShapedRecipe(ItemStack result, Object ... components) {
        BlockStateGenerator.GeneratorType generatorType;
        int i;
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<String> pattern = new ArrayList<String>();
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add((String)components[i]);
        }
        json.put("pattern", pattern);
        boolean isOreDict = false;
        HashMap<String, Map<String, Object>> key = new HashMap<String, Map<String, Object>>();
        Character curKey = null;
        while (i < components.length) {
            Object o = components[i];
            if (o instanceof Character) {
                if (curKey != null) {
                    Mekanism.logger.fatal("Failed to convert recipe. Provided two chars keys in a row", (Throwable)new IllegalArgumentException());
                    return;
                }
                curKey = (Character)o;
            } else {
                if (curKey == null) {
                    Mekanism.logger.fatal("Failed to convert recipe. Providing object without a char key", (Throwable)new IllegalArgumentException());
                    return;
                }
                if (o instanceof String) {
                    isOreDict = true;
                }
                try {
                    key.put(Character.toString(curKey.charValue()), RecipeGenerator.serializeItem(o));
                }
                catch (IllegalArgumentException e) {
                    Mekanism.logger.fatal("Failed to convert recipe", (Throwable)e);
                    return;
                }
                curKey = null;
            }
            ++i;
        }
        json.put("key", key);
        json.put("type", this.getRecipeType(result, isOreDict, true));
        try {
            json.put("result", RecipeGenerator.serializeItem(result));
        }
        catch (IllegalArgumentException e) {
            Mekanism.logger.fatal("Failed to convert recipe", (Throwable)e);
            return;
        }
        BlockStateMachine.MachineType machineType = BlockStateMachine.MachineType.get(result);
        if (machineType != null) {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("type", "mekanism:recipe_enabled");
            condition.put("machineType", machineType.blockName);
            json.put("conditions", new Object[]{condition});
        }
        if ((generatorType = BlockStateGenerator.GeneratorType.get((ItemStack)result)) != null && result.func_77952_i() <= BlockStateGenerator.GeneratorType.WIND_GENERATOR.meta) {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("type", "mekanism:recipe_enabled");
            condition.put("generatorType", generatorType.blockName);
            json.put("conditions", new Object[]{condition});
        }
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        File f = new File(this.RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(this.RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            Mekanism.logger.fatal("Failed to write JSON", (Throwable)e);
        }
    }

    public void addShapelessRecipe(ItemStack result, Object ... components) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        for (Object o : components) {
            if (o instanceof String) {
                isOreDict = true;
            }
            try {
                ingredients.add(RecipeGenerator.serializeItem(o));
            }
            catch (IllegalArgumentException e) {
                Mekanism.logger.fatal("Failed to convert recipe", (Throwable)e);
                return;
            }
        }
        json.put("ingredients", ingredients);
        json.put("type", this.getRecipeType(result, isOreDict, false));
        try {
            json.put("result", RecipeGenerator.serializeItem(result));
        }
        catch (IllegalArgumentException e) {
            Mekanism.logger.fatal("Failed to convert recipe", (Throwable)e);
            return;
        }
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        File f = new File(this.RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(this.RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            Mekanism.logger.fatal("Failed to write JSON", (Throwable)e);
        }
    }

    private String getRecipeType(ItemStack result, boolean isOreDict, boolean shaped) {
        String type;
        String string = type = shaped ? "minecraft:crafting_shaped" : "minecraft:crafting_shapeless";
        if (isOreDict) {
            Item resultItem = result.func_77973_b();
            type = resultItem instanceof IEnergizedItem || resultItem instanceof IGasItem || resultItem instanceof ISecurityItem || FluidContainerUtils.isFluidContainer(result) || BlockStateBasic.BasicBlockType.get(result) == BlockStateBasic.BasicBlockType.BIN || BlockStateMachine.MachineType.get(result) != null && BlockStateMachine.MachineType.get((ItemStack)result).supportsUpgrades ? (shaped ? "mekanism:ore_shaped" : "mekanism:ore_shapeless") : (shaped ? "forge:ore_shaped" : "forge:ore_shapeless");
        }
        return type;
    }
}

