/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.core.registers.items.GSItems;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockAssembler;
import galaxyspace.systems.SolarSystem.planets.overworld.recipes.AssemblyRecipes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.recipe.ShapedRecipesGC;
import micdoodle8.mods.galacticraft.api.recipe.ShapelessOreRecipeGC;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.inventory.PersistantInventoryCrafting;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityAssembler
extends TileBaseElectricBlock
implements IInventoryDefaults,
ISidedInventory,
IPacketReceiver {
    public static final int PROCESS_TIME_REQUIRED_BASE = 200;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = 200;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack producingStack = ItemStack.field_190927_a;
    private static Random randnum = new Random();
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    public PersistantInventoryCrafting testCraftMatrix = new PersistantInventoryCrafting();
    private int boost_speed;
    private int energy_boost;

    public TileEntityAssembler() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 75.0f);
        this.setTierGC(1);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            boolean updateInv = false;
            if (this.hasEnoughEnergyToRun) {
                if (this.canCompress()) {
                    this.boost_speed = 0;
                    this.energy_boost = 0;
                    for (int i = 0; i <= 3; ++i) {
                        if (((ItemStack)this.stacks.get(2 + i)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 2))) {
                            ++this.boost_speed;
                        }
                        if (!((ItemStack)this.stacks.get(2 + i)).func_77969_a(new ItemStack(GSItems.UPGRADES, 1, 3))) continue;
                        ++this.energy_boost;
                    }
                    this.processTicks += 1 + this.boost_speed;
                    this.storage.setMaxExtract(ConfigManagerCore.hardMode ? (float)(90 + 40 * this.boost_speed - 20 * this.energy_boost) : (float)(75 + 35 * this.boost_speed - 15 * this.energy_boost));
                    this.processTimeRequired = 400 / (1 + this.poweredByTierGC);
                    if (this.processTicks >= this.processTimeRequired) {
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.3f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
                        this.processTicks = 0;
                        this.compressIntoSlot(1);
                        updateInv = true;
                    }
                } else {
                    this.processTicks = 0;
                }
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
    }

    private boolean canCompress() {
        ItemStack itemstack = this.producingStack;
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.stacks.get(1)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.stacks.get(1)).func_190926_b() && !((ItemStack)this.stacks.get(1)).func_77969_a(itemstack)) {
            return false;
        }
        int contents1 = ((ItemStack)this.stacks.get(1)).func_190916_E();
        int result = itemstack.func_190916_E();
        return (result += contents1) <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public void updateInput() {
        this.producingStack = AssemblyRecipes.findMatchingRecipe((InventoryCrafting)this.testCraftMatrix, this.field_145850_b);
    }

    private void compressIntoSlot(int slot) {
        if (this.canCompress()) {
            ItemStack resultItemStack = this.producingStack;
            if (((ItemStack)this.stacks.get(slot)).func_190926_b()) {
                this.stacks.set(slot, (Object)resultItemStack);
            } else if (((ItemStack)this.stacks.get(slot)).func_77969_a(resultItemStack)) {
                if (((ItemStack)this.stacks.get(slot)).func_190916_E() + resultItemStack.func_190916_E() > resultItemStack.func_77976_d()) {
                    resultItemStack.func_190917_f(((ItemStack)this.stacks.get(slot)).func_190916_E() - resultItemStack.func_77976_d());
                    GCCoreUtil.spawnItem((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (ItemStack)resultItemStack);
                    ((ItemStack)this.stacks.get(slot)).func_190920_e(resultItemStack.func_77976_d());
                } else {
                    ((ItemStack)this.stacks.get(slot)).func_190917_f(resultItemStack.func_190916_E());
                }
            }
            for (int i = 0; i < this.testCraftMatrix.func_70302_i_(); ++i) {
                if (!this.testCraftMatrix.func_70301_a(i).func_190926_b() && this.testCraftMatrix.func_70301_a(i).func_77973_b() == Items.field_151131_as) {
                    this.testCraftMatrix.setInventorySlotContentsNoUpdate(i, new ItemStack(Items.field_151133_ar));
                    continue;
                }
                this.testCraftMatrix.func_70298_a(i, 1);
            }
            this.updateInput();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.stacks = NonNullList.func_191197_a((int)(this.func_70302_i_() - this.testCraftMatrix.func_70302_i_()), (Object)ItemStack.field_190927_a);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j >= 0 && j < this.stacks.size()) {
                this.stacks.set(j, (Object)new ItemStack(nbttagcompound));
                continue;
            }
            if (j >= this.stacks.size() + this.testCraftMatrix.func_70302_i_()) continue;
            this.testCraftMatrix.func_70299_a(j - this.stacks.size(), new ItemStack(nbttagcompound));
        }
        this.updateInput();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound var4;
        int var3;
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        NBTTagList var2 = new NBTTagList();
        for (var3 = 0; var3 < this.stacks.size(); ++var3) {
            if (((ItemStack)this.stacks.get(var3)).func_190926_b()) continue;
            var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            ((ItemStack)this.stacks.get(var3)).func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        for (var3 = 0; var3 < this.testCraftMatrix.func_70302_i_(); ++var3) {
            if (this.testCraftMatrix.func_70301_a(var3) == null) continue;
            var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)(var3 + this.stacks.size()));
            this.testCraftMatrix.func_70301_a(var3).func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
        return nbt;
    }

    public int func_70302_i_() {
        return this.stacks.size() + this.testCraftMatrix.func_70302_i_();
    }

    public ItemStack func_70301_a(int par1) {
        if (par1 >= this.stacks.size()) {
            return this.testCraftMatrix.func_70301_a(par1 - this.stacks.size());
        }
        return (ItemStack)this.stacks.get(par1);
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (par1 >= this.stacks.size()) {
            ItemStack result = this.testCraftMatrix.func_70298_a(par1 - this.stacks.size(), par2);
            if (result != null) {
                this.updateInput();
            }
            return result;
        }
        if (!((ItemStack)this.stacks.get(par1)).func_190926_b()) {
            if (((ItemStack)this.stacks.get(par1)).func_190916_E() <= par2) {
                ItemStack var3 = (ItemStack)this.stacks.get(par1);
                this.stacks.set(par1, (Object)ItemStack.field_190927_a);
                return var3;
            }
            ItemStack var3 = ((ItemStack)this.stacks.get(par1)).func_77979_a(par2);
            if (((ItemStack)this.stacks.get(par1)).func_190926_b()) {
                this.stacks.set(par1, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return var3;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int par1) {
        if (par1 >= this.stacks.size()) {
            return this.testCraftMatrix.func_70304_b(par1 - this.stacks.size());
        }
        if (!((ItemStack)this.stacks.get(par1)).func_190926_b()) {
            ItemStack var2 = (ItemStack)this.stacks.get(par1);
            this.stacks.set(par1, (Object)ItemStack.field_190927_a);
            this.func_70296_d();
            return var2;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int par1, ItemStack stack) {
        if (par1 >= this.stacks.size()) {
            this.testCraftMatrix.func_70299_a(par1 - this.stacks.size(), stack);
            this.updateInput();
        } else {
            this.stacks.set(par1, (Object)stack);
            if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"tile.assembly_machine.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && entityplayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return itemStack != null && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
        }
        if (slotID >= 2) {
            if (this.producingStack != null) {
                ItemStack stackInSlot = this.func_70301_a(slotID);
                return stackInSlot != null && stackInSlot.func_77969_a(itemStack);
            }
            return this.isItemCompressorInput(itemStack, slotID - 2);
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        int[] slots = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        ArrayList<Integer> removeSlots = new ArrayList<Integer>();
        block0: for (int i = 2; i < 11; ++i) {
            ItemStack stack1;
            if (removeSlots.contains(i) || (stack1 = this.func_70301_a(i)).func_190926_b()) continue;
            for (int j = i + 1; j < 11; ++j) {
                ItemStack stack2;
                if (removeSlots.contains(j) || (stack2 = this.func_70301_a(j)).func_190926_b() || !stack1.func_77969_a(stack2)) continue;
                if (stack2.func_190916_E() >= stack1.func_190916_E()) {
                    removeSlots.add(j);
                    continue block0;
                }
                removeSlots.add(i);
                continue block0;
            }
        }
        if (removeSlots.size() > 0) {
            int[] returnSlots = new int[slots.length - removeSlots.size()];
            int j = 0;
            for (int i = 0; i < slots.length; ++i) {
                if (i > 0 && removeSlots.contains(slots[i])) continue;
                returnSlots[j] = slots[i];
                ++j;
            }
            return returnSlots;
        }
        return slots;
    }

    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID == 1;
    }

    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public boolean isItemCompressorInput(ItemStack stack, int id) {
        for (IRecipe recipe : AssemblyRecipes.getRecipeList()) {
            if (recipe instanceof ShapedRecipesGC) {
                if (id >= ((ShapedRecipesGC)recipe).recipeItems.length) continue;
                ItemStack itemstack1 = ((ShapedRecipesGC)recipe).recipeItems[id];
                if (stack.func_77973_b() != itemstack1.func_77973_b() || itemstack1.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != itemstack1.func_77952_i()) continue;
                for (int i = 0; i < ((ShapedRecipesGC)recipe).recipeItems.length; ++i) {
                    if (i == id) continue;
                    ItemStack itemstack2 = ((ShapedRecipesGC)recipe).recipeItems[i];
                    if (stack.func_77973_b() != itemstack2.func_77973_b() || itemstack2.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != itemstack2.func_77952_i()) continue;
                    ItemStack is3 = this.func_70301_a(id + 3);
                    ItemStack is4 = this.func_70301_a(i + 3);
                    return is3.func_190926_b() || !is4.func_190926_b() && is3.func_190916_E() < is4.func_190916_E();
                }
                return true;
            }
            if (!(recipe instanceof ShapelessOreRecipeGC)) continue;
            ArrayList required = new ArrayList(((ShapelessOreRecipeGC)recipe).getInput());
            Iterator req = required.iterator();
            int match = 0;
            block2: while (req.hasNext()) {
                Object next = req.next();
                if (next instanceof ItemStack) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)stack, (boolean)false)) continue;
                    ++match;
                    continue;
                }
                if (!(next instanceof ArrayList)) continue;
                Iterator itr = ((ArrayList)next).iterator();
                while (itr.hasNext()) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)stack, (boolean)false)) continue;
                    ++match;
                    continue block2;
                }
            }
            if (match == 0) continue;
            if (match == 1) {
                return true;
            }
            int slotsFilled = 0;
            for (int i = 3; i < 12; ++i) {
                ItemStack inMatrix = this.func_70301_a(i);
                if (inMatrix.func_190926_b() || !inMatrix.func_77969_a(stack)) continue;
                ++slotsFilled;
            }
            if (slotsFilled < match) {
                return this.func_70301_a(id + 3).func_190926_b();
            }
            return randnum.nextInt(match) == 0;
        }
        return false;
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockAssembler) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockAssembler.FACING);
        }
        return EnumFacing.NORTH;
    }
}

