/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.core.configs.GSConfigEnergy;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.systems.SolarSystem.moons.io.blocks.IoBlocks;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockFuelGenerator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityFuelGenerator
extends TileBaseUniversalElectricalSource
implements IFluidHandlerWrapper,
IInventoryDefaults,
ISidedInventory,
IConnector {
    public static final float MAX_GENERATE_GJ_PER_TICK = 81.0f * GSConfigEnergy.coefficientFuelGenerator;
    public static final float MIN_GENERATE_GJ_PER_TICK = 1.0f;
    private static final float BASE_ACCELERATION = 0.3f;
    private final int tankCapacity = 4000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    public float prevGenerateWatts = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float heatGJperTick = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int itemCookTime = 0;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private float mod = 1.0f;
    private static List<Fuel> fuel = new ArrayList<Fuel>();

    public static void registerNewFuel(Fluid fluid, int burn_time, float mod_energy) {
        fuel.add(new Fuel(fluid, burn_time, mod_energy));
    }

    public TileEntityFuelGenerator() {
        this.storage.setMaxExtract(MAX_GENERATE_GJ_PER_TICK - 1.0f);
    }

    public int getScaledFuelLevel(int i) {
        return this.fuelTank.getFluidAmount() * i / this.fuelTank.getCapacity();
    }

    public void func_73660_a() {
        if (this.heatGJperTick - 1.0f > 0.0f) {
            this.receiveEnergyGC(null, this.heatGJperTick - 1.0f, false);
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            FluidStack liquid = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.stacks.get(0)));
            for (Fuel fuel : TileEntityFuelGenerator.fuel) {
                if (!FluidUtil.isFluidStrict((FluidStack)liquid, (String)fuel.getFluid().getName()) || this.fuelTank.getFluid() != null && (this.fuelTank.getFluid() == null || !this.fuelTank.getFluid().getFluid().equals(liquid.getFluid()))) continue;
                FluidUtil.loadFromContainer((FluidTank)this.fuelTank, (Fluid)fuel.getFluid(), this.stacks, (int)0, (int)liquid.amount);
            }
            if (this.field_145850_b.field_73012_v.nextInt(2) == 0 && this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()) == GSBlocks.IO_BLOCKS.func_176223_P().func_177226_a(IoBlocks.BASIC_TYPE, (Comparable)((Object)IoBlocks.EnumIoBlocks.IO_LAVA_GEYSER)) && this.field_145850_b.func_180495_p(this.func_174877_v().func_177979_c(2)) == Blocks.field_150353_l.func_176223_P()) {
                this.fuelTank.fill(new FluidStack(FluidRegistry.LAVA, 1), true);
            }
            this.produce();
            this.smeltItem();
        }
    }

    public void smeltItem() {
        if (this.canProcess()) {
            int lavaAmount = this.fuelTank.getFluidAmount();
            int fuelSpace = this.fuelTank.getCapacity() - this.fuelTank.getFluidAmount();
            int amountToDrain = Math.min(Math.min(lavaAmount, fuelSpace), 1);
            for (Fuel fluid : fuel) {
                if (this.fuelTank.getFluid().getFluid() != fluid.getFluid()) continue;
                if (this.ticks % fluid.getDuration() != 0) break;
                this.fuelTank.drain(1, true);
                this.mod = fluid.getModificator();
                break;
            }
            this.heatGJperTick = Math.min(this.heatGJperTick + Math.max(this.heatGJperTick * 0.005f, 0.3f), MAX_GENERATE_GJ_PER_TICK * this.mod);
        }
    }

    public boolean canProcess() {
        if (this.fuelTank.getFluidAmount() <= 0) {
            this.heatGJperTick = 0.0f;
            return false;
        }
        return !(this.storage.getEnergyStoredGC() >= this.storage.getCapacityGC());
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.itemCookTime = par1NBTTagCompound.func_74762_e("itemCookTime");
        this.heatGJperTick = par1NBTTagCompound.func_74762_e("generateRateInt");
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)par1NBTTagCompound, this.stacks);
        if (par1NBTTagCompound.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(par1NBTTagCompound.func_74775_l("fuelTank"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("itemCookTime", this.itemCookTime);
        par1NBTTagCompound.func_74776_a("generateRate", this.heatGJperTick);
        if (this.fuelTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)par1NBTTagCompound, this.stacks);
        return par1NBTTagCompound;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public ItemStack func_70301_a(int par1) {
        return (ItemStack)this.stacks.get(par1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack oldstack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"tile.fuel_generator.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return itemstack.func_77973_b() == GCItems.bucketFuel || itemstack.func_77973_b() == GCItems.fuelCanister || itemstack.func_77973_b() == Items.field_151129_at;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing direction) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing direction) {
        return slotID == 0;
    }

    public float receiveElectricity(EnumFacing from, float energy, int tier, boolean doReceive) {
        return 0.0f;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(this.getElectricOutputDirection());
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockFuelGenerator) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockFuelGenerator.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getElectricOutputDirection() {
        return this.getFront().func_176735_f();
    }

    private EnumFacing getPipe() {
        return this.getFront().func_176746_e();
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricOutputDirection();
        }
        if (type == NetworkType.FLUID) {
            return direction == this.getPipe();
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (this.getPipe().equals((Object)from) && resource != null && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && (liquidName.startsWith("fuel") || liquidName.startsWith("biofuel") || liquidName.startsWith("lava"))) {
            used = this.fuelTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == this.getPipe()) {
            return this.fuelTank.getFluid() == null || this.fuelTank.getFluidAmount() < this.fuelTank.getCapacity();
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    private static class Fuel {
        private Fluid fuel;
        private int duration;
        private float modificator;

        Fuel(Fluid fluid, int duration, float modificator) {
            this.fuel = fluid;
            this.duration = duration;
            this.modificator = modificator;
        }

        public Fluid getFluid() {
            return this.fuel;
        }

        public int getDuration() {
            return this.duration;
        }

        public float getModificator() {
            return this.modificator;
        }
    }
}

