/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.utils.helper;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class ToolHelpers {
    public static boolean isToolEffective(IBlockAccess world, BlockPos pos, @Nonnull ItemStack emulatedTool) {
        IBlockState state = world.func_180495_p(pos);
        if ((state = state.func_177230_c().func_176221_a(state, world, pos)).func_177230_c().func_176195_g(state, (World)world, pos) == -1.0f) {
            return false;
        }
        if (emulatedTool.func_77973_b().func_150897_b(state)) {
            return true;
        }
        String harvestTool = state.func_177230_c().getHarvestTool(state);
        if (harvestTool != null) {
            for (String type : emulatedTool.func_77973_b().getToolClasses(emulatedTool)) {
                if (!state.func_177230_c().isToolEffective(type, state) && (!Objects.equals(harvestTool, type) || emulatedTool.func_77973_b().getHarvestLevel(emulatedTool, harvestTool, null, null) < state.func_177230_c().getHarvestLevel(state))) continue;
                return true;
            }
        } else {
            Item.ToolMaterial material = emulatedTool.func_77973_b() instanceof ItemTool ? Item.ToolMaterial.valueOf((String)((ItemTool)emulatedTool.func_77973_b()).func_77861_e()) : Item.ToolMaterial.IRON;
            if (emulatedTool.func_150997_a(state) >= material.func_77998_b()) {
                return true;
            }
        }
        return false;
    }

    public static boolean blockCheckAndHarvest(EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == null || block == Blocks.field_150350_a || block == Blocks.field_150357_h) {
            return false;
        }
        if ((block instanceof IShearable || block instanceof BlockFlower || block instanceof BlockBush || block instanceof BlockLeaves) && block.canHarvestBlock((IBlockAccess)world, pos, player) || block == Blocks.field_150433_aE || block == Blocks.field_150431_aC) {
            block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), new ItemStack(Items.field_151037_a));
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }
}

