/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.tileentity;

import gcewing.sg.SGCraft;
import gcewing.sg.tileentity.PowerTE;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class SGPowerTE
extends PowerTE
implements IEnergyStorage {
    private int maxInput = 10000;
    private int maxOutput = 10000;
    private EnergyStorage storage = new EnergyStorage(SGCraft.FPMaxEnergyBuffer, this.maxInput, this.maxOutput);

    public SGPowerTE() {
        super(SGCraft.FPMaxEnergyBuffer, SGCraft.FPPerSGEnergyUnit);
    }

    @Override
    public String getScreenTitle() {
        return "SGPU";
    }

    @Override
    public String getUnitName() {
        return "SG";
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nbttagcompound) {
        super.readContentsFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("capacity")) {
            int capacity = nbttagcompound.func_74762_e("capacity");
            int energy = nbttagcompound.func_74762_e("energy");
            this.storage = new EnergyStorage(capacity, this.maxInput, this.maxOutput, energy);
        }
        if (SGCraft.forceFPCfgUpdate) {
            this.energyMax = SGCraft.FPMaxEnergyBuffer;
            this.energyPerSGEnergyUnit = SGCraft.FPPerSGEnergyUnit;
            this.storage = new EnergyStorage((int)this.energyMax, this.maxInput, this.maxOutput);
        }
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nbttagcompound) {
        super.writeContentsToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("capacity", this.storage.getMaxEnergyStored());
        nbttagcompound.func_74768_a("energy", this.storage.getEnergyStored());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return null;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int result = this.storage.receiveEnergy(maxReceive, simulate);
        this.energyBuffer = this.storage.getEnergyStored();
        this.markChanged();
        return result;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int result = this.storage.extractEnergy(maxExtract, simulate);
        this.energyBuffer = this.storage.getEnergyStored();
        this.markChanged();
        return result;
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.storage.canExtract();
    }

    public boolean canReceive() {
        return this.storage.canReceive();
    }

    @Override
    public double totalAvailableEnergy() {
        return this.energyBuffer;
    }
}

