/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import com.google.common.base.Function;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DoubleKeyMap<K, V>
implements Iterable<DoubleKeyEntry<K, V>> {
    private List<DoubleKeyEntry<K, V>> data = new ArrayList<DoubleKeyEntry<K, V>>();
    private BiMap<K, Integer> keys = HashBiMap.create();

    public int put(K key, V value) {
        if (this.keys.get(key) != null) {
            throw new IllegalArgumentException("Key already in map : " + key);
        }
        int i = this.data.size();
        this.keys.put(key, (Object)i);
        this.data.add(new DoubleKeyEntry<K, V>(i, key, value));
        return i;
    }

    public DoubleKeyEntry<K, V> getEntry(int index) {
        return this.data.get(index);
    }

    public DoubleKeyEntry<K, V> getEntry(K key) {
        if (this.keys.get(key) == null) {
            return null;
        }
        return this.data.get((Integer)this.keys.get(key));
    }

    public K getKey(int index) {
        DoubleKeyEntry<int, V> entry = this.getEntry((K)index);
        return entry != null ? entry.getKey() : null;
    }

    public int getIndex(K key) {
        return (Integer)this.keys.get(key);
    }

    public V get(int index) {
        DoubleKeyEntry<int, V> entry = this.getEntry((K)index);
        return entry != null ? (V)entry.getValue() : null;
    }

    public V get(K key) {
        DoubleKeyEntry<K, V> entry = this.getEntry(key);
        return entry != null ? (V)entry.getValue() : null;
    }

    @Override
    public Iterator<DoubleKeyEntry<K, V>> iterator() {
        return this.data.iterator();
    }

    public Collection<V> values() {
        return Collections2.transform(this.data, (Function)new Function<DoubleKeyEntry<K, V>, V>(){

            public V apply(DoubleKeyEntry<K, V> entry) {
                return entry.getValue();
            }
        });
    }

    public static class DoubleKeyEntry<K, V> {
        private int index;
        private K key;
        private V value;

        public DoubleKeyEntry(int index, K key, V value) {
            this.index = index;
            this.key = key;
            this.value = value;
        }

        public int getIndex() {
            return this.index;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

