/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.integration.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.common.carving.Carving;
import team.chisel.common.init.ChiselItems;
import team.chisel.common.integration.jei.ChiselRecipeCategory;
import team.chisel.common.integration.jei.ChiselRecipeWrapper;

@ParametersAreNonnullByDefault
@JEIPlugin
public class ChiselJEIPlugin
implements IModPlugin {
    private ChiselRecipeCategory category;

    public void register(IModRegistry registry) {
        registry.handleRecipes(ICarvingGroup.class, ChiselRecipeWrapper::new, "chisel.chiseling");
        registry.addRecipes((Collection)Carving.chisel.getSortedGroupNames().stream().map(s -> Carving.chisel.getGroup((String)s)).collect(Collectors.toList()), this.category.getUid());
        Arrays.stream(new Item[]{ChiselItems.chisel_iron, ChiselItems.chisel_diamond, ChiselItems.chisel_hitech}).map(ItemStack::new).forEach(stack -> {
            registry.addRecipeCatalyst(stack, new String[]{this.category.getUid()});
            registry.addIngredientInfo(stack, ItemStack.class, new String[]{"jei.chisel.desc.chisel_generic", "\n", "jei.chisel.desc." + stack.func_77973_b().getRegistryName().func_110623_a()});
        });
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 16; ++i) {
            itemStacks.add(new ItemStack(Blocks.field_192444_dS, 1, i));
            itemStacks.add(new ItemStack(Blocks.field_192443_dR, 1, i));
        }
        registry.addIngredientInfo(itemStacks, ItemStack.class, new String[]{"jei.chisel.desc.concrete_making"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.category = new ChiselRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.category});
    }
}

