/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Maps;
import cubex2.cs4.CustomStuff4;
import cubex2.cs4.api.Color;
import cubex2.cs4.api.Content;
import cubex2.cs4.api.ContentHelper;
import cubex2.cs4.api.InitPhase;
import cubex2.cs4.api.ItemModuleSupplier;
import cubex2.cs4.plugins.vanilla.Attribute;
import cubex2.cs4.plugins.vanilla.ColorImpl;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;

public abstract class ContentItemBase<T extends Item>
implements Content {
    String id;
    int maxDamage = 0;
    Attribute<Color> tint = null;
    public Attribute<Integer> burnTime = Attribute.constant(-1);
    public Attribute<ResourceLocation> gui = Attribute.constant(null);
    public Map<String, ItemModuleSupplier> modules = Maps.newLinkedHashMap();
    protected transient T item;

    @Override
    public final void init(InitPhase phase, ContentHelper helper) {
        if (phase == InitPhase.PRE_INIT) {
            this.item = this.createItem();
            this.item.func_77655_b(helper.getModId() + "." + this.id);
            this.item.setRegistryName(this.id);
            this.item.func_77656_e(this.maxDamage);
            this.initItem();
        } else if (phase == InitPhase.REGISTER_ITEMS) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(GameData.ITEMS);
            registry.register(this.item);
        } else if (phase == InitPhase.REGISTER_MODELS) {
            this.registerModels();
        } else if (phase == InitPhase.INIT && this.tint != null) {
            if (this.item.func_77614_k()) {
                CustomStuff4.proxy.setItemTint((Item)this.item, meta -> this.tint.get(meta).orElse(new ColorImpl(-1)).getRGB());
            } else {
                CustomStuff4.proxy.setItemTint((Item)this.item, meta -> this.tint.get(0).orElse(new ColorImpl(-1)).getRGB());
            }
        }
    }

    protected void registerModels() {
    }

    protected abstract void initItem();

    protected abstract T createItem();
}

