/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSideConfigurationTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiTransporterConfigTab;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.common.inventory.container.ContainerChanceMachine;
import mekanism.common.tile.TileEntityChanceMachine;
import mekanism.common.util.LangUtils;
import mekanism.common.util.ListUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiChanceMachine
extends GuiMekanism {
    public TileEntityChanceMachine tileEntity;

    public GuiChanceMachine(InventoryPlayer inventory, TileEntityChanceMachine tentity) {
        super(tentity, new ContainerChanceMachine(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiUpgradeTab(this, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiSideConfigurationTab(this, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiTransporterConfigTab(this, 34, this.tileEntity, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, this.tileEntity, this.tileEntity.guiLocation, 164, 15));
        this.guiElements.add(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(this.tileEntity.energyPerTick);
            return ListUtils.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(this.tileEntity.getMaxEnergy() - this.tileEntity.getEnergy()));
        }, (IGuiWrapper)this, this.tileEntity.guiLocation));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, this.tileEntity.guiLocation, 55, 16));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, this.tileEntity.guiLocation, 55, 52).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT_WIDE, this, this.tileEntity.guiLocation, 111, 30));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return GuiChanceMachine.this.tileEntity.getScaledProgress();
            }
        }, this.getProgressType(), this, this.tileEntity.guiLocation, 77, 37));
    }

    public GuiProgress.ProgressBar getProgressType() {
        return GuiProgress.ProgressBar.BLUE;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.tileEntity.func_70005_c_(), 45, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.tileEntity.guiLocation);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(partialTick, mouseX, mouseY);
    }
}

