/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.MekanismFluids;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemMekanism;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlamethrower
extends ItemMekanism
implements IGasItem {
    public int TRANSFER_RATE = 16;

    public ItemFlamethrower() {
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        GasStack gasStack = this.getGas(itemstack);
        if (gasStack == null) {
            list.add(LangUtils.localize("tooltip.noGas") + ".");
        } else {
            list.add(LangUtils.localize("tooltip.stored") + " " + gasStack.getGas().getLocalizedName() + ": " + gasStack.amount);
        }
        list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.mode") + ": " + (Object)((Object)EnumColor.GREY) + this.getMode(itemstack).getName());
    }

    public void useGas(ItemStack stack) {
        if (this.getGas(stack) != null) {
            this.setGas(stack, new GasStack(this.getGas(stack).getGas(), this.getGas((ItemStack)stack).amount - 1));
        }
    }

    @Override
    public int getMaxGas(ItemStack itemstack) {
        return MekanismConfig.current().general.maxFlamethrowerGas.val();
    }

    @Override
    public int getRate(ItemStack itemstack) {
        return this.TRANSFER_RATE;
    }

    @Override
    public int addGas(ItemStack itemstack, GasStack stack) {
        if (this.getGas(itemstack) != null && this.getGas(itemstack).getGas() != stack.getGas()) {
            return 0;
        }
        if (stack.getGas() != MekanismFluids.Hydrogen) {
            return 0;
        }
        int toUse = Math.min(this.getMaxGas(itemstack) - this.getStored(itemstack), Math.min(this.getRate(itemstack), stack.amount));
        this.setGas(itemstack, new GasStack(stack.getGas(), this.getStored(itemstack) + toUse));
        return toUse;
    }

    @Override
    public GasStack removeGas(ItemStack itemstack, int amount) {
        return null;
    }

    public int getStored(ItemStack itemstack) {
        return this.getGas(itemstack) != null ? this.getGas((ItemStack)itemstack).amount : 0;
    }

    @Override
    public boolean canReceiveGas(ItemStack itemstack, Gas type) {
        return type == MekanismFluids.Hydrogen;
    }

    @Override
    public boolean canProvideGas(ItemStack itemstack, Gas type) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (this.getGas(stack) != null ? (double)this.getGas((ItemStack)stack).amount : 0.0) / (double)this.getMaxGas(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public GasStack getGas(ItemStack itemstack) {
        return GasStack.readFromNBT(ItemDataUtils.getCompound(itemstack, "stored"));
    }

    @Override
    public void setGas(ItemStack itemstack, GasStack stack) {
        if (stack == null || stack.amount == 0) {
            ItemDataUtils.removeData(itemstack, "stored");
        } else {
            int amount = Math.max(0, Math.min(stack.amount, this.getMaxGas(itemstack)));
            GasStack gasStack = new GasStack(stack.getGas(), amount);
            ItemDataUtils.setCompound(itemstack, "stored", gasStack.write(new NBTTagCompound()));
        }
    }

    public ItemStack getEmptyItem() {
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        return empty;
    }

    public void func_150895_a(CreativeTabs tabs, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tabs)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this);
        this.setGas(empty, null);
        list.add((Object)empty);
        ItemStack filled = new ItemStack((Item)this);
        this.setGas(filled, new GasStack(MekanismFluids.Hydrogen, ((IGasItem)filled.func_77973_b()).getMaxGas(filled)));
        list.add((Object)filled);
    }

    public void incrementMode(ItemStack stack) {
        this.setMode(stack, this.getMode(stack).increment());
    }

    public FlamethrowerMode getMode(ItemStack stack) {
        return FlamethrowerMode.values()[ItemDataUtils.getInt(stack, "mode")];
    }

    public void setMode(ItemStack stack, FlamethrowerMode mode) {
        ItemDataUtils.setInt(stack, "mode", mode.ordinal());
    }

    public static enum FlamethrowerMode {
        COMBAT("tooltip.flamethrower.combat", EnumColor.YELLOW),
        HEAT("tooltip.flamethrower.heat", EnumColor.ORANGE),
        INFERNO("tooltip.flamethrower.inferno", EnumColor.DARK_RED);

        private String unlocalized;
        private EnumColor color;

        private FlamethrowerMode(String s, EnumColor c) {
            this.unlocalized = s;
            this.color = c;
        }

        public FlamethrowerMode increment() {
            return this.ordinal() < FlamethrowerMode.values().length - 1 ? FlamethrowerMode.values()[this.ordinal() + 1] : FlamethrowerMode.values()[0];
        }

        public String getName() {
            return (Object)((Object)this.color) + LangUtils.localize(this.unlocalized);
        }
    }
}

