/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashSet;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.PacketHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.transmitters.grid.EnergyNetwork;
import mekanism.common.transmitters.grid.FluidNetwork;
import mekanism.common.transmitters.grid.GasNetwork;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTransmitterUpdate
implements IMessageHandler<TransmitterUpdateMessage, IMessage> {
    public IMessage onMessage(TransmitterUpdateMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (player == null) {
            return null;
        }
        PacketHandler.handlePacket(() -> {
            DynamicNetwork net;
            IGridTransmitter transmitter;
            TileEntity tileEntity;
            if (message.packetType == PacketType.UPDATE && CapabilityUtils.hasCapability((ICapabilityProvider)(tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p)), Capabilities.GRID_TRANSMITTER_CAPABILITY, null)) {
                transmitter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, null);
                Object network = transmitter.hasTransmitterNetwork() && !message.newNetwork ? transmitter.getTransmitterNetwork() : transmitter.createEmptyNetwork();
                ((DynamicNetwork)network).register();
                transmitter.setTransmitterNetwork(network);
                for (Coord4D coord : message.transmitterCoords) {
                    TileEntity tile = coord.getTileEntity((IBlockAccess)player.field_70170_p);
                    if (!CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, null)) continue;
                    CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, null).setTransmitterNetwork(network);
                }
                ((DynamicNetwork)network).updateCapacity();
            }
            if (MekanismConfig.current().client.opaqueTransmitters.val() || message.coord4D == null || player == null) {
                return;
            }
            if (message.packetType == PacketType.ENERGY) {
                tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
                if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, null) && (transmitter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, null)).hasTransmitterNetwork() && transmitter.getTransmissionType() == TransmissionType.ENERGY) {
                    ((EnergyNetwork)transmitter.getTransmitterNetwork()).clientEnergyScale = message.power;
                }
            } else if (message.packetType == PacketType.GAS) {
                tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
                if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, null) && (transmitter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, null)).hasTransmitterNetwork() && transmitter.getTransmissionType() == TransmissionType.GAS) {
                    net = (GasNetwork)transmitter.getTransmitterNetwork();
                    if (message.gasType != null) {
                        net.refGas = message.gasType;
                    }
                    net.buffer = message.gasStack;
                    net.didTransfer = message.didGasTransfer;
                }
            } else if (message.packetType == PacketType.FLUID && CapabilityUtils.hasCapability((ICapabilityProvider)(tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p)), Capabilities.GRID_TRANSMITTER_CAPABILITY, null) && (transmitter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, null)).hasTransmitterNetwork() && transmitter.getTransmissionType() == TransmissionType.FLUID) {
                net = (FluidNetwork)transmitter.getTransmitterNetwork();
                if (message.fluidType != null) {
                    ((FluidNetwork)net).refFluid = message.fluidType;
                }
                ((FluidNetwork)net).buffer = message.fluidStack;
                ((FluidNetwork)net).didTransfer = message.didFluidTransfer;
            }
        }, player);
        return null;
    }

    public static class TransmitterUpdateMessage
    implements IMessage {
        public PacketType packetType;
        public Coord4D coord4D;
        public double power;
        public GasStack gasStack;
        public Gas gasType;
        public boolean didGasTransfer;
        public FluidStack fluidStack;
        public Fluid fluidType;
        public float fluidScale;
        public boolean didFluidTransfer;
        public int amount;
        public boolean newNetwork;
        public Collection<IGridTransmitter> transmittersAdded;
        public Collection<Coord4D> transmitterCoords;

        public TransmitterUpdateMessage() {
        }

        public TransmitterUpdateMessage(PacketType type, Coord4D coord, Object ... data) {
            this.packetType = type;
            this.coord4D = coord;
            switch (this.packetType) {
                case UPDATE: {
                    this.newNetwork = (Boolean)data[0];
                    this.transmittersAdded = (Collection)data[1];
                    break;
                }
                case ENERGY: {
                    this.power = (Double)data[0];
                    break;
                }
                case GAS: {
                    this.gasStack = (GasStack)data[0];
                    this.didGasTransfer = (Boolean)data[1];
                    break;
                }
                case FLUID: {
                    this.fluidStack = (FluidStack)data[0];
                    this.didFluidTransfer = (Boolean)data[1];
                    break;
                }
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            this.coord4D.write(dataStream);
            PacketHandler.log("Sending '" + (Object)((Object)this.packetType) + "' update message from coordinate " + this.coord4D);
            switch (this.packetType) {
                case UPDATE: {
                    dataStream.writeBoolean(this.newNetwork);
                    dataStream.writeInt(this.transmittersAdded.size());
                    for (IGridTransmitter transmitter : this.transmittersAdded) {
                        transmitter.coord().write(dataStream);
                    }
                    break;
                }
                case ENERGY: {
                    dataStream.writeDouble(this.power);
                    break;
                }
                case GAS: {
                    dataStream.writeInt(this.gasStack != null ? this.gasStack.getGas().getID() : -1);
                    dataStream.writeInt(this.gasStack != null ? this.gasStack.amount : 0);
                    dataStream.writeBoolean(this.didGasTransfer);
                    break;
                }
                case FLUID: {
                    if (this.fluidStack != null) {
                        dataStream.writeBoolean(true);
                        PacketHandler.writeNBT(dataStream, this.fluidStack.writeToNBT(new NBTTagCompound()));
                    } else {
                        dataStream.writeBoolean(false);
                    }
                    dataStream.writeBoolean(this.didFluidTransfer);
                    break;
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = PacketType.values()[dataStream.readInt()];
            this.coord4D = Coord4D.read(dataStream);
            if (this.packetType == PacketType.UPDATE) {
                this.newNetwork = dataStream.readBoolean();
                this.transmitterCoords = new HashSet<Coord4D>();
                int numTransmitters = dataStream.readInt();
                for (int i = 0; i < numTransmitters; ++i) {
                    this.transmitterCoords.add(Coord4D.read(dataStream));
                }
            } else if (this.packetType == PacketType.ENERGY) {
                this.power = dataStream.readDouble();
            } else if (this.packetType == PacketType.GAS) {
                this.gasType = GasRegistry.getGas(dataStream.readInt());
                this.amount = dataStream.readInt();
                this.didGasTransfer = dataStream.readBoolean();
                if (this.gasType != null) {
                    this.gasStack = new GasStack(this.gasType, this.amount);
                }
            } else if (this.packetType == PacketType.FLUID) {
                if (dataStream.readBoolean()) {
                    this.fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)PacketHandler.readNBT(dataStream));
                    this.fluidType = this.fluidStack != null ? this.fluidStack.getFluid() : null;
                } else {
                    this.fluidType = null;
                    this.amount = 0;
                    this.fluidStack = null;
                }
                this.didFluidTransfer = dataStream.readBoolean();
            }
        }
    }

    public static enum PacketType {
        UPDATE,
        ENERGY,
        GAS,
        FLUID;

    }
}

