/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismFluids;
import mekanism.common.SideData;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class TileEntityChemicalInjectionChamber
extends TileEntityAdvancedElectricMachine<InjectionRecipe> {
    public TileEntityChemicalInjectionChamber() {
        super("injection", "ChemicalInjectionChamber", BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER.baseEnergy, MekanismConfig.current().usage.chemicalInjectionChamberUsage.val(), 200, 1);
        this.configComponent.addSupported(TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("Gas", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.fillConfig(TransmissionType.GAS, 1);
        this.configComponent.setCanEject(TransmissionType.GAS, false);
    }

    @Override
    public Map<AdvancedMachineInput, InjectionRecipe> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get();
    }

    @Override
    public GasStack getItemGas(ItemStack itemstack) {
        if (MekanismUtils.getOreDictName(itemstack).contains("dustSulfur")) {
            return new GasStack(MekanismFluids.SulfuricAcid, 2);
        }
        if (MekanismUtils.getOreDictName(itemstack).contains("dustSalt")) {
            return new GasStack(MekanismFluids.HydrogenChloride, 2);
        }
        if (Block.func_149634_a((Item)itemstack.func_77973_b()) == MekanismBlocks.GasTank && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && this.isValidGas(((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas())) {
            return new GasStack(MekanismFluids.SulfuricAcid, 1);
        }
        return null;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0)) {
            return this.isValidGas(type);
        }
        return false;
    }

    @Override
    public void handleSecondaryFuel() {
        if (!((ItemStack)this.inventory.get(1)).func_190926_b() && this.gasTank.getNeeded() > 0 && ((ItemStack)this.inventory.get(1)).func_77973_b() instanceof IGasItem) {
            GasStack gas = ((IGasItem)((ItemStack)this.inventory.get(1)).func_77973_b()).getGas((ItemStack)this.inventory.get(1));
            if (gas != null && this.isValidGas(gas.getGas())) {
                GasStack removed = GasUtils.removeGas((ItemStack)this.inventory.get(1), this.gasTank.getGasType(), this.gasTank.getNeeded());
                this.gasTank.receive(removed, true);
            }
            return;
        }
        super.handleSecondaryFuel();
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return this.configComponent.getOutput(TransmissionType.GAS, side, this.facing).hasSlot(0);
    }

    @Override
    public boolean isValidGas(Gas gas) {
        return gas == MekanismFluids.SulfuricAcid || gas == MekanismFluids.Water || gas == MekanismFluids.HydrogenChloride;
    }

    @Override
    public boolean upgradeableSecondaryEfficiency() {
        return true;
    }

    @Override
    public boolean useStatisticalMechanics() {
        return true;
    }
}

