/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.Range4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.integration.forgeenergy.ForgeEnergyIntegration;
import mekanism.common.integration.tesla.TeslaIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2"), @Optional.Interface(iface="ic2.api.tile.IEnergyStorage", modid="ic2")})
public class TileEntityInductionPort
extends TileEntityInductionCasing
implements IEnergyWrapper,
IConfigurable,
IActiveState {
    public boolean ic2Registered = false;
    public boolean mode;
    private CapabilityWrapperManager<IEnergyWrapper, TeslaIntegration> teslaManager = new CapabilityWrapperManager<IEnergyWrapper, TeslaIntegration>(IEnergyWrapper.class, TeslaIntegration.class);
    private CapabilityWrapperManager<IEnergyWrapper, ForgeEnergyIntegration> forgeEnergyManager = new CapabilityWrapperManager<IEnergyWrapper, ForgeEnergyIntegration>(IEnergyWrapper.class, ForgeEnergyIntegration.class);

    public TileEntityInductionPort() {
        super("InductionPort");
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.ic2Registered && MekanismUtils.useIC2()) {
            this.register();
        }
        if (!this.field_145850_b.field_72995_K && this.structure != null && this.mode) {
            double prev = this.getEnergy();
            CableUtils.emit(this);
            ((SynchronizedMatrixData)this.structure).remainingOutput -= prev - this.getEnergy();
        }
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        if (this.structure != null && this.mode) {
            return !((SynchronizedMatrixData)this.structure).locations.contains(Coord4D.get(this).offset(side));
        }
        return false;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return this.structure != null && !this.mode;
    }

    @Optional.Method(modid="ic2")
    public void register() {
        IEnergyTile registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTile(this.field_145850_b, this.func_174877_v())) != this) {
            if (registered instanceof IEnergyTile) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(registered));
            } else if (registered == null) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
                this.ic2Registered = true;
            }
        }
    }

    @Optional.Method(modid="ic2")
    public void deregister() {
        IEnergyTile registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTile(this.field_145850_b, this.func_174877_v())) instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(registered));
        }
    }

    @Override
    public double getMaxOutput() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).remainingOutput : 0.0;
    }

    private double getMaxInput() {
        return this.structure != null ? ((SynchronizedMatrixData)this.structure).remainingInput : 0.0;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            boolean prevMode = this.mode;
            this.mode = dataStream.readBoolean();
            if (prevMode != this.mode) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.mode);
        return data;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (MekanismUtils.useIC2()) {
            this.register();
        }
    }

    public void onChunkUnload() {
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.mode = nbtTags.func_74767_n("mode");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("mode", this.mode);
        return nbtTags;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.sideIsConsumer(from)) {
            double toAdd = (int)Math.min(Math.min(this.getMaxInput(), this.getMaxEnergy() - this.getEnergy()), (double)maxReceive * MekanismConfig.current().general.FROM_RF.val());
            if (!simulate) {
                this.setEnergy(this.getEnergy() + toAdd);
                ((SynchronizedMatrixData)this.structure).remainingInput -= toAdd;
            }
            return (int)Math.round(Math.min(2.147483647E9, toAdd * MekanismConfig.current().general.TO_RF.val()));
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (this.sideIsOutput(from)) {
            double toSend = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), (double)maxExtract * MekanismConfig.current().general.FROM_RF.val()));
            if (!simulate) {
                this.setEnergy(this.getEnergy() - toSend);
                ((SynchronizedMatrixData)this.structure).remainingOutput -= toSend;
            }
            return (int)Math.round(Math.min(2.147483647E9, toSend * MekanismConfig.current().general.TO_RF.val()));
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public boolean canConnectEnergy(EnumFacing from) {
        return this.structure != null;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(EnumFacing from) {
        return (int)Math.round(Math.min(2.147483647E9, this.getEnergy() * MekanismConfig.current().general.TO_RF.val()));
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(EnumFacing from) {
        return (int)Math.round(Math.min(2.147483647E9, this.getMaxEnergy() * MekanismConfig.current().general.TO_RF.val()));
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public int addEnergy(int amount) {
        double toUse = Math.min(Math.min(this.getMaxInput(), this.getMaxEnergy() - this.getEnergy()), (double)amount * MekanismConfig.current().general.FROM_IC2.val());
        this.setEnergy(this.getEnergy() + toUse);
        ((SynchronizedMatrixData)this.structure).remainingInput -= toUse;
        return (int)Math.round(Math.min(2.147483647E9, this.getEnergy() * MekanismConfig.current().general.TO_IC2.val()));
    }

    @Optional.Method(modid="ic2")
    public boolean isTeleporterCompatible(EnumFacing side) {
        return this.canOutputEnergy(side);
    }

    @Override
    public boolean canOutputEnergy(EnumFacing side) {
        return this.sideIsOutput(side);
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return this.sideIsConsumer(direction);
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return this.sideIsOutput(direction) && receiver instanceof IEnergyConductor;
    }

    @Optional.Method(modid="ic2")
    public int getStored() {
        return (int)Math.round(Math.min(2.147483647E9, this.getEnergy() * MekanismConfig.current().general.TO_IC2.val()));
    }

    @Optional.Method(modid="ic2")
    public void setStored(int energy) {
        this.setEnergy((double)energy * MekanismConfig.current().general.FROM_IC2.val());
    }

    @Optional.Method(modid="ic2")
    public int getCapacity() {
        return (int)Math.round(Math.min(2.147483647E9, this.getMaxEnergy() * MekanismConfig.current().general.TO_IC2.val()));
    }

    @Optional.Method(modid="ic2")
    public int getOutput() {
        return (int)Math.round(Math.min(2.147483647E9, this.getMaxOutput() * MekanismConfig.current().general.TO_IC2.val()));
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return (this.getMaxEnergy() - this.getEnergy()) * MekanismConfig.current().general.TO_IC2.val();
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return Math.min(this.getEnergy(), this.getMaxOutput()) * MekanismConfig.current().general.TO_IC2.val();
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return this.sideIsConsumer(side);
    }

    @Optional.Method(modid="ic2")
    public double getOutputEnergyUnitsPerTick() {
        return this.getMaxOutput() * MekanismConfig.current().general.TO_IC2.val();
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing direction, double amount, double voltage) {
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(direction));
        if (tile == null || CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, direction.func_176734_d())) {
            return amount;
        }
        return amount - this.acceptEnergy(direction, amount * MekanismConfig.current().general.FROM_IC2.val(), false) * MekanismConfig.current().general.TO_IC2.val();
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        if (this.structure != null) {
            double toDraw = Math.min(amount * MekanismConfig.current().general.FROM_IC2.val(), this.getMaxOutput());
            this.setEnergy(Math.max(this.getEnergy() - toDraw, 0.0));
            ((SynchronizedMatrixData)this.structure).remainingOutput -= toDraw;
        }
    }

    @Override
    public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
        double toUse = Math.min(Math.min(this.getMaxInput(), this.getMaxEnergy() - this.getEnergy()), amount);
        if (toUse < 1.0E-4 || side != null && !this.sideIsConsumer(side)) {
            return 0.0;
        }
        if (!simulate) {
            this.setEnergy(this.getEnergy() + toUse);
            ((SynchronizedMatrixData)this.structure).remainingInput -= toUse;
        }
        return toUse;
    }

    @Override
    public double pullEnergy(EnumFacing side, double amount, boolean simulate) {
        double toGive = Math.min(this.getEnergy(), amount);
        if (toGive < 1.0E-4 || side != null && !this.sideIsOutput(side)) {
            return 0.0;
        }
        if (!simulate) {
            this.setEnergy(this.getEnergy() - toGive);
        }
        return toGive;
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K) {
            this.mode = !this.mode;
            String modeText = " " + (Object)((Object)(this.mode ? EnumColor.DARK_RED : EnumColor.DARK_GREEN)) + LangUtils.transOutputInput(this.mode) + ".";
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurator.inductionPortMode") + modeText));
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(this)));
            this.func_70296_d();
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        return EnumActionResult.PASS;
    }

    @Override
    public boolean getActive() {
        return this.mode;
    }

    @Override
    public void setActive(boolean active) {
        this.mode = active;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY || capability == Capabilities.ENERGY_OUTPUTTER_CAPABILITY || capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == Capabilities.TESLA_CONSUMER_CAPABILITY && this.sideIsConsumer(facing) || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.sideIsOutput(facing) || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY || capability == Capabilities.ENERGY_OUTPUTTER_CAPABILITY || capability == Capabilities.CONFIGURABLE_CAPABILITY) {
            return (T)this;
        }
        if (capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.TESLA_CONSUMER_CAPABILITY && this.sideIsConsumer(facing) || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.sideIsOutput(facing)) {
            return (T)this.teslaManager.getWrapper(this, facing);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.forgeEnergyManager.getWrapper(this, facing);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }
}

