/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.compatibility.hwyla;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import omtteam.omlib.util.GeneralUtil;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.util.TurretHeadUtil;

public class WailaTurretHandler
implements IWailaDataProvider {
    static void callbackRegister(IWailaRegistrar register) {
        WailaTurretHandler instance = new WailaTurretHandler();
        register.registerNBTProvider((IWailaDataProvider)instance, TurretHead.class);
        register.registerBodyProvider((IWailaDataProvider)instance, TurretHead.class);
    }

    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getStack();
    }

    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te;
        if (accessor.getWorld().field_72995_K && (te = accessor.getTileEntity()) instanceof TurretHead && currenttip.size() == 0) {
            TurretHead turret = (TurretHead)te;
            boolean active = turret.getBase().isActive();
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:active") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)active));
            String ownerName = turret.getBase().getOwnerName();
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:owner") + ": \u00a7F" + ownerName);
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:ammo") + ": \u00a7F" + TurretHeadUtil.getAmmoLevel(turret, turret.getBase()));
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:damage_amp") + ": \u00a7F" + String.format("%.2f", turret.getTurretDamageAmpBonus() * 100.0 * (double)TurretHeadUtil.getAmpLevel(turret.getBase())) + "%");
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:accuracy") + ": \u00a7F" + String.format("%.2f", Math.min(100.0, (100.0 - turret.getTurretAccuracy() * 10.0) * (1.0 + (double)TurretHeadUtil.getAccuraccyUpgrades(turret.getBase())))) + "%");
            currenttip.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:rof") + ": \u00a7F" + String.format("%.2f", Float.valueOf(20.0f / ((float)turret.getTurretFireRate() * (1.0f - TurretHeadUtil.getFireRateUpgrades(turret.getBase()))))) + "s/sec");
        }
        return currenttip;
    }

    @Nonnull
    @Optional.Method(modid="waila")
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null) {
            te.func_189515_b(tag);
        }
        return tag;
    }
}

