/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import icbm.classic.client.ICBMSounds;
import icbm.classic.content.explosive.blast.BlastBeam;
import icbm.classic.content.potion.CustomPotionEffect;
import icbm.classic.content.potion.PoisonFrostBite;
import icbm.classic.lib.transform.vector.Location;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlastEndothermic
extends BlastBeam {
    public BlastEndothermic(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
        this.red = 0.0f;
        this.green = 0.3f;
        this.blue = 0.7f;
    }

    @Override
    public void doExplode() {
        super.doExplode();
        ICBMSounds.REDMATTER.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, 0.8f, true);
    }

    @Override
    public void doPostExplode() {
        super.doPostExplode();
        if (!this.world().field_72995_K) {
            if (this.canFocusBeam(this.world(), this.location) && this.isThreadCompleted()) {
                List livingEntities = this.world().func_72872_a(EntityLiving.class, new AxisAlignedBB(this.location.x() - (double)this.getBlastRadius(), this.location.y() - (double)this.getBlastRadius(), this.location.z() - (double)this.getBlastRadius(), this.location.x() + (double)this.getBlastRadius(), this.location.y() + (double)this.getBlastRadius(), this.location.z() + (double)this.getBlastRadius()));
                if (livingEntities != null && !livingEntities.isEmpty()) {
                    for (EntityLiving entity : livingEntities) {
                        if (entity == null || !entity.func_70089_S()) continue;
                        entity.func_70690_d((PotionEffect)new CustomPotionEffect(PoisonFrostBite.INSTANCE, 1200, 1, null));
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 2));
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 2400, 2));
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 2400, 4));
                    }
                }
                ConcurrentLinkedQueue list = this.getThreadResults();
                for (BlockPos targetPosition : list) {
                    double chance;
                    double distanceFromCenter = this.location.distance((Vec3i)targetPosition);
                    if (distanceFromCenter > (double)this.getBlastRadius() || !((chance = (double)this.getBlastRadius() - Math.random() * distanceFromCenter) > distanceFromCenter * 0.55)) continue;
                    IBlockState blockState = this.field_77287_j.func_180495_p(targetPosition);
                    Block block = blockState.func_177230_c();
                    if (blockState.func_185904_a() == Material.field_151586_h) {
                        this.world().func_180501_a(targetPosition, Blocks.field_150432_aD.func_176223_P(), 3);
                        continue;
                    }
                    if (block == Blocks.field_150480_ab || block == Blocks.field_150356_k || block == Blocks.field_150353_l) {
                        this.world().func_180501_a(targetPosition, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(8)), 3);
                        continue;
                    }
                    BlockPos bellowPos = targetPosition.func_177977_b();
                    IBlockState blockState1 = this.field_77287_j.func_180495_p(bellowPos);
                    if (!block.func_176200_f((IBlockAccess)this.world(), targetPosition) || !blockState1.isSideSolid((IBlockAccess)this.field_77287_j, bellowPos, EnumFacing.UP)) continue;
                    if (this.world().field_73012_v.nextBoolean()) {
                        this.world().func_180501_a(targetPosition, Blocks.field_150432_aD.func_176223_P(), 3);
                        continue;
                    }
                    this.world().func_180501_a(targetPosition, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(1 + this.field_77287_j.field_73012_v.nextInt(7))), 3);
                }
                ICBMSounds.REDMATTER.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 6.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 1.0f, true);
            }
            if (!this.world().func_82736_K().func_82766_b("doDaylightCycle")) {
                this.world().func_72877_b(1200L);
            }
        }
    }

    @Override
    public boolean canFocusBeam(World worldObj, Location position) {
        return true;
    }
}

