/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore;

import asmodeuscore.api.IBodies;
import asmodeuscore.api.IBodiesHandler;
import asmodeuscore.api.galaxies.SpacePort;
import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.event.AsmodeusEvent;
import asmodeuscore.core.handler.PlanetFogHandler;
import asmodeuscore.core.handler.capabilities.ACCapabilityStatsHandler;
import asmodeuscore.core.network.packet.AsmodeusChannelHandler;
import asmodeuscore.core.proxy.CommonProxy;
import asmodeuscore.core.registers.potions.ACPotions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="asmodeuscore", version="0.0.8", dependencies="required-after:forge@[14.23.1.2555,); required-after:galacticraftcore; required-after:galacticraftplanets;", acceptedMinecraftVersions="[1.12.2]", name="AsmodeusCore")
public class AsmodeusCore {
    public static final int major_version = 0;
    public static final int minor_version = 0;
    public static final int build_version = 8;
    public static final String NAME = "AsmodeusCore";
    public static final String MODID = "asmodeuscore";
    public static final String VERSION = "0.0.8";
    public static final String ASSET_PREFIX = "asmodeuscore";
    public static final String TEXTURE_PREFIX = "asmodeuscore:";
    public static AsmodeusChannelHandler packetPipeline;
    public static SpacePort testSP;
    @Mod.Instance(value="asmodeuscore")
    public static AsmodeusCore instance;
    @SidedProxy(clientSide="asmodeuscore.core.proxy.ClientProxy", serverSide="asmodeuscore.core.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static List<IBodiesHandler> bodies;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        for (ASMDataTable.ASMData data : event.getASMHarvestedData().getAll(IBodies.class.getName())) {
            try {
                IBodiesHandler body = (IBodiesHandler)Class.forName(data.getClassName()).newInstance();
                bodies.add(body);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new AsmodeusConfig(new File(event.getModConfigurationDirectory(), "AsmodeusCore/core.conf"));
        ACCapabilityStatsHandler.register();
        ACPotions.initialize();
        proxy.preload();
        proxy.register_event(new AsmodeusEvent());
        proxy.register_event(new PlanetFogHandler());
        for (IBodiesHandler handler : bodies) {
            handler.preInitialization(event);
            if (!handler.canRegister()) continue;
            handler.preInit(event);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.load();
        packetPipeline = AsmodeusChannelHandler.init();
        for (IBodiesHandler handler : bodies) {
            if (!handler.canRegister()) continue;
            handler.init(event);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postload();
        for (IBodiesHandler handler : bodies) {
            if (!handler.canRegister()) continue;
            handler.postInit(event);
        }
    }

    static {
        bodies = new ArrayList<IBodiesHandler>();
    }
}

