/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.gravisuite.renders;

import com.chocohead.gravisuite.GS_Items;
import com.chocohead.gravisuite.items.ItemAdvancedDrill;
import ic2.core.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class PrettyUtil
implements IResourceManagerReloadListener {
    public static final TextureAtlasSprite[] DESTROY_BLOCK_ICONS = new TextureAtlasSprite[10];
    public static final Minecraft mc = Minecraft.func_71410_x();
    private static final Field CUR_BLOCK_DAMAGE_MP = PrettyUtil.getCBDMP();

    private static Field getCBDMP() {
        Field field = ReflectionUtil.getField(PlayerControllerMP.class, (String[])new String[]{"e", "field_78770_f", "curBlockDamageMP"});
        if (field == null) {
            throw new RuntimeException("Cannot find curBlockDamageMP!");
        }
        return field;
    }

    public PrettyUtil() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IResourceManager resourceManager = mc.func_110442_L();
        if (!(resourceManager instanceof IReloadableResourceManager)) {
            throw new IllegalStateException("ResourceManager is not reloadable?!");
        }
        ((IReloadableResourceManager)resourceManager).func_110542_a((IResourceManagerReloadListener)this);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        TextureMap texturemap = mc.func_147117_R();
        for (int icon = 0; icon < DESTROY_BLOCK_ICONS.length; icon = (int)((byte)(icon + 1))) {
            PrettyUtil.DESTROY_BLOCK_ICONS[icon] = texturemap.func_110572_b("minecraft:blocks/destroy_stage_" + icon);
        }
    }

    @SubscribeEvent
    public void renderAdditionalBlockBounds(DrawBlockHighlightEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (event.getSubID() == 0 && event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK && (stack = (player = event.getPlayer()).func_184586_b(EnumHand.MAIN_HAND)) != null && stack.func_77973_b() == GS_Items.ADVANCED_DRILL.getInstance() && ItemAdvancedDrill.readDrillMode(stack) == ItemAdvancedDrill.DrillMode.BIG_HOLES) {
            PrettyUtil.drawAdditionalBlockbreak(event.getContext(), player, event.getPartialTicks(), ItemAdvancedDrill.getBrokenBlocks(player, event.getTarget()));
        }
    }

    public static void drawAdditionalBlockbreak(RenderGlobal context, EntityPlayer player, float partialTicks, Collection<BlockPos> blocks) {
        for (BlockPos pos : blocks) {
            context.func_72731_b(player, new RayTraceResult(new Vec3d(0.0, 0.0, 0.0), null, pos), 0, partialTicks);
        }
        if (PrettyUtil.mc.field_71442_b.func_181040_m()) {
            PrettyUtil.drawBlockDamageTexture((Entity)player, blocks, partialTicks);
        }
    }

    private static float get_curBlockDamageMP(PlayerControllerMP controller) {
        try {
            return CUR_BLOCK_DAMAGE_MP.getFloat(controller);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("curBlockDamageMP is not a float?! Turns out it was a " + CUR_BLOCK_DAMAGE_MP.getType(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("One job...", e);
        }
    }

    public static void drawBlockDamageTexture(Entity entity, Collection<BlockPos> blocks, float partialTicks) {
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        int progress = (int)(PrettyUtil.get_curBlockDamageMP(PrettyUtil.mc.field_71442_b) * 10.0f) - 1;
        if (progress < 0) {
            return;
        }
        TextureAtlasSprite sprite = DESTROY_BLOCK_ICONS[progress];
        PrettyUtil.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179120_a((int)774, (int)768, (int)1, (int)0);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        BufferBuilder worldRenderer = Tessellator.func_178181_a().func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        worldRenderer.func_178969_c(-x, -y, -z);
        World world = entity.field_70170_p;
        for (BlockPos pos : blocks) {
            boolean hasBreak;
            IBlockState state = world.func_180495_p(pos);
            if (state.func_185904_a() == Material.field_151579_a) continue;
            Block block = state.func_177230_c();
            boolean bl = hasBreak = block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull;
            if (!hasBreak) {
                TileEntity te = world.func_175625_s(pos);
                boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
            }
            if (hasBreak) continue;
            mc.func_175602_ab().func_175020_a(state, pos, sprite, (IBlockAccess)world);
        }
        Tessellator.func_178181_a().func_78381_a();
        worldRenderer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }
}

