/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.cuboidal;

import nc.multiblock.MultiblockBase;
import nc.multiblock.cuboidal.CuboidalMultiblockTileBase;
import nc.multiblock.network.MultiblockUpdatePacket;
import nc.multiblock.validation.IMultiblockValidator;
import nc.multiblock.validation.ValidationError;
import nc.util.NCMath;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class CuboidalMultiblockBase<PACKET extends MultiblockUpdatePacket>
extends MultiblockBase<PACKET> {
    protected CuboidalMultiblockBase(World world) {
        super(world);
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            validatorCallback.setLastError(ValidationError.VALIDATION_ERROR_TOO_FEW_PARTS);
            return false;
        }
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int minX = minimumCoord.func_177958_n();
        int minY = minimumCoord.func_177956_o();
        int minZ = minimumCoord.func_177952_p();
        int maxX = maximumCoord.func_177958_n();
        int maxY = maximumCoord.func_177956_o();
        int maxZ = maximumCoord.func_177952_p();
        int deltaX = maxX - minX + 1;
        int deltaY = maxY - minY + 1;
        int deltaZ = maxZ - minZ + 1;
        int maxXSize = this.getMaximumXSize();
        int maxYSize = this.getMaximumYSize();
        int maxZSize = this.getMaximumZSize();
        int minXSize = this.getMinimumXSize();
        int minYSize = this.getMinimumYSize();
        int minZSize = this.getMinimumZSize();
        if (maxXSize > 0 && deltaX > maxXSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_large", null, maxXSize, "X");
            return false;
        }
        if (maxYSize > 0 && deltaY > maxYSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_large", null, maxYSize, "Y");
            return false;
        }
        if (maxZSize > 0 && deltaZ > maxZSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_large", null, maxZSize, "Z");
            return false;
        }
        if (deltaX < minXSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_small", null, minXSize, "X");
            return false;
        }
        if (deltaY < minYSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_small", null, minYSize, "Y");
            return false;
        }
        if (deltaZ < minZSize) {
            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.machine_too_small", null, minZSize, "Z");
            return false;
        }
        Class<?> myClass = this.getClass();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    boolean isPartValid;
                    CuboidalMultiblockTileBase part;
                    TileEntity te = this.WORLD.func_175625_s(new BlockPos(x, y, z));
                    if (te instanceof CuboidalMultiblockTileBase) {
                        part = (CuboidalMultiblockTileBase)te;
                        if (!myClass.equals(part.getMultiblockType())) {
                            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.invalid_part", new BlockPos(x, y, z), x, y, z);
                            return false;
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minX) {
                        ++extremes;
                    }
                    if (y == minY) {
                        ++extremes;
                    }
                    if (z == minZ) {
                        ++extremes;
                    }
                    if (x == maxX) {
                        ++extremes;
                    }
                    if (y == maxY) {
                        ++extremes;
                    }
                    if (z == maxZ) {
                        ++extremes;
                    }
                    if (extremes >= 2) {
                        boolean bl = isPartValid = part != null ? part.isGoodForFrame(validatorCallback) : this.isBlockGoodForFrame(this.WORLD, x, y, z, validatorCallback);
                        if (isPartValid) continue;
                        if (null == validatorCallback.getLastError()) {
                            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.invalid_part_for_frame", new BlockPos(x, y, z), x, y, z);
                        }
                        return false;
                    }
                    if (extremes == 1) {
                        if (y == maxY) {
                            boolean bl = isPartValid = part != null ? part.isGoodForTop(validatorCallback) : this.isBlockGoodForTop(this.WORLD, x, y, z, validatorCallback);
                            if (isPartValid) continue;
                            if (null == validatorCallback.getLastError()) {
                                validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.invalid_part_for_top", new BlockPos(x, y, z), x, y, z);
                            }
                            return false;
                        }
                        if (y == minY) {
                            boolean bl = isPartValid = part != null ? part.isGoodForBottom(validatorCallback) : this.isBlockGoodForBottom(this.WORLD, x, y, z, validatorCallback);
                            if (isPartValid) continue;
                            if (null == validatorCallback.getLastError()) {
                                validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.invalid_part_for_bottom", new BlockPos(x, y, z), x, y, z);
                            }
                            return false;
                        }
                        boolean bl = isPartValid = part != null ? part.isGoodForSides(validatorCallback) : this.isBlockGoodForSides(this.WORLD, x, y, z, validatorCallback);
                        if (isPartValid) continue;
                        if (null == validatorCallback.getLastError()) {
                            validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.invalid_part_for_sides", new BlockPos(x, y, z), x, y, z);
                        }
                        return false;
                    }
                    boolean bl = isPartValid = part != null ? part.isGoodForInterior(validatorCallback) : this.isBlockGoodForInterior(this.WORLD, x, y, z, validatorCallback);
                    if (isPartValid) continue;
                    if (null == validatorCallback.getLastError()) {
                        validatorCallback.setLastError("zerocore.api.nc.multiblock.validation.reactor.invalid_part_for_interior", new BlockPos(x, y, z), x, y, z);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public int getExteriorLengthX() {
        return Math.abs(this.getMaximumCoord().func_177958_n() - this.getMinimumCoord().func_177958_n()) + 1;
    }

    public int getExteriorLengthY() {
        return Math.abs(this.getMaximumCoord().func_177956_o() - this.getMinimumCoord().func_177956_o()) + 1;
    }

    public int getExteriorLengthZ() {
        return Math.abs(this.getMaximumCoord().func_177952_p() - this.getMinimumCoord().func_177952_p()) + 1;
    }

    public int getInteriorLengthX() {
        return this.getExteriorLengthX() - 2;
    }

    public int getInteriorLengthY() {
        return this.getExteriorLengthY() - 2;
    }

    public int getInteriorLengthZ() {
        return this.getExteriorLengthZ() - 2;
    }

    protected abstract int getMinimumInteriorLength();

    protected abstract int getMaximumInteriorLength();

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return NCMath.hollowCube(this.getMinimumInteriorLength() + 2);
    }

    @Override
    protected int getMinimumXSize() {
        return this.getMinimumInteriorLength() + 2;
    }

    @Override
    protected int getMinimumYSize() {
        return this.getMinimumInteriorLength() + 2;
    }

    @Override
    protected int getMinimumZSize() {
        return this.getMinimumInteriorLength() + 2;
    }

    @Override
    protected int getMaximumXSize() {
        return this.getMaximumInteriorLength() + 2;
    }

    @Override
    protected int getMaximumYSize() {
        return this.getMaximumInteriorLength() + 2;
    }

    @Override
    protected int getMaximumZSize() {
        return this.getMaximumInteriorLength() + 2;
    }
}

