/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NCUtil {
    private static Logger logger;

    public static Logger getLogger() {
        if (logger == null) {
            logger = LogManager.getFormatterLogger((String)"nuclearcraft");
        }
        return logger;
    }

    public static boolean isSubclassOf(Class<?> clazz, Class<?> superClass) {
        if (superClass.equals(Object.class)) {
            return true;
        }
        if (clazz.equals(superClass)) {
            return true;
        }
        if ((clazz = clazz.getSuperclass()).equals(Object.class)) {
            return false;
        }
        return NCUtil.isSubclassOf(clazz, superClass);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<T> constructor = clazz.getConstructor(NCUtil.getClasses(args));
        return constructor.newInstance(args);
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = objects[i].getClass();
        }
        return classes;
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isInstance(Object object, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.isInstance(object);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

