/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

public class Units {

    public static enum DistanceUnit {
        M("m", 1.0, "%.0f %s"),
        KM("km", 0.001, "%.2f %s"),
        SILLY("miles", 6.21371E-4, "%.f %s");

        public final String name;
        public final double factor;
        public final String format;

        private DistanceUnit(String name, double factor, String format) {
            this.name = name;
            this.factor = factor;
            this.format = format;
        }

        public String format(double value) {
            return String.format(this.format, value * this.factor, this.name);
        }
    }

    public static enum SpeedUnit {
        M_PER_TICK("m/tick", 1.0, "%.2f %s"),
        M_PER_S("m/s", 20.0, "%.2f %s"),
        KM_PER_H("km/s", 72.0, "%.2f %s"),
        BROKEN("mph", 44.738800000000005, "%.2f %s");

        public final String name;
        public final double factor;
        public final String format;

        private SpeedUnit(String name, double factor, String format) {
            this.name = name;
            this.factor = factor;
            this.format = format;
        }

        public String format(double value) {
            return String.format(this.format, value * this.factor, this.name);
        }
    }
}

