/*
 * Decompiled with CFR 0.152.
 */
package com.possibletriangle.tinkersjei;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.traits.ITrait;

public class StatsWrapper
implements IRecipeWrapper {
    final Material material;
    private final IDrawable slot;
    private final IDrawable container;

    public StatsWrapper(Material material, IGuiHelper helper) {
        this.material = material;
        ResourceLocation slot_location = new ResourceLocation("tinkersjei", "textures/jei/slot.png");
        ResourceLocation container_location = new ResourceLocation("tconstruct", "textures/blocks/smeltery/seared_gauge_side.png");
        this.slot = helper.getSlotDrawable();
        this.container = helper.createDrawable(container_location, 0, 0, 16, 16, 16, 16);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.getRepresantives());
        ingredients.setOutputs(ItemStack.class, this.getRepresantives());
        if (this.material.hasFluid()) {
            ingredients.setInputs(FluidStack.class, Collections.singletonList(new FluidStack(this.material.getFluid(), 1)));
            ingredients.setOutputs(FluidStack.class, Collections.singletonList(new FluidStack(this.material.getFluid(), 1)));
        }
    }

    public List<ItemStack> getRepresantives() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.material.hasFluid()) {
            for (MeltingRecipe recipe : TinkerRegistry.getAllMeltingRecipies()) {
                if (!this.material.getFluid().equals(recipe.output.getFluid())) continue;
                list.addAll(recipe.input.getInputs());
            }
        }
        if (this.material.getRepresentativeItem() != null && !this.material.getRepresentativeItem().isEmpty()) {
            list.add(this.material.getRepresentativeItem());
        }
        list.addAll(this.getParts());
        return list;
    }

    public List<ItemStack> getParts() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (IToolPart part : TinkerRegistry.getToolParts()) {
            ItemStack stack;
            if (!part.canUseMaterial(this.material) || (stack = part.getItemstackWithMaterial(this.material)).equals(this.material.getShard())) continue;
            list.add(part.getItemstackWithMaterial(this.material));
        }
        return list;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        ItemStack item = this.material.getRepresentativeItem();
        if (item != null && !item.isEmpty()) {
            this.slot.draw(minecraft, recipeWidth - 18 - 6, 0);
        }
        this.slot.draw(minecraft, 6, 0);
        if (this.material.hasFluid()) {
            this.slot.draw(minecraft, 27, 0);
        }
        String s = this.material.getLocalizedName();
        int textWidth = minecraft.fontRenderer.getStringWidth(s);
        minecraft.fontRenderer.drawString(s, (float)(recipeWidth - textWidth) / 2.0f, 4.0f, this.material.materialTextColor, true);
        int h = minecraft.fontRenderer.FONT_HEIGHT;
        int offset = 22;
        if (!this.material.getAllTraits().isEmpty()) {
            ArrayList<String> traits = new ArrayList<String>();
            for (ITrait trait2 : this.material.getAllTraits()) {
                if (trait2 == null || trait2.getLocalizedName() == null) continue;
                traits.add(trait2.getLocalizedName());
            }
            HashMap<Integer, String> traitList = new HashMap<Integer, String>();
            int y = 0;
            for (String trait3 : traits) {
                if (trait3 == null) continue;
                if (traitList.size() == y) {
                    traitList.put(y, "");
                } else {
                    trait3 = ", " + trait3;
                }
                int w = minecraft.fontRenderer.getStringWidth((String)traitList.get(0) + trait3);
                if (w > recipeWidth) {
                    ++y;
                    trait3 = trait3.substring(2);
                }
                String s2 = traitList.get(y) == null ? "" : (String)traitList.get(y);
                traitList.put(y, s2 + trait3);
            }
            traitList.forEach((row, trait) -> {
                int w = minecraft.fontRenderer.getStringWidth(trait);
                minecraft.fontRenderer.drawString(trait, (float)(recipeWidth - w) / 2.0f, (float)(22 + h * row), this.material.materialTextColor, true);
            });
            offset += (h + 1) * traitList.size();
        }
        int maxLines = (recipeHeight - offset - 4) / h - 1;
        ArrayList<IMaterialStats> stats = new ArrayList<IMaterialStats>(this.material.getAllStats());
        stats.removeIf(stat -> stat.getLocalizedInfo().isEmpty());
        IMaterialStats stat2 = (IMaterialStats)stats.get((int)(System.currentTimeMillis() / 2000L % (long)stats.size()));
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(TextFormatting.BOLD.toString() + stat2.getLocalizedName() + ": ");
        lines.addAll(stat2.getLocalizedInfo());
        for (int y = 0; y < Math.min(maxLines, lines.size()); ++y) {
            String line = (String)lines.get(y);
            int textWidth2 = minecraft.fontRenderer.getStringWidth(line);
            minecraft.fontRenderer.drawString(line, (recipeWidth - textWidth2) / 2, y % maxLines * h + offset + 4, Color.GRAY.getRGB());
        }
    }

    public boolean hasFluid() {
        return this.material.hasFluid();
    }

    public FluidStack getFluid() {
        return new FluidStack(this.material.getFluid(), 1000);
    }
}

