/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.WeakHashMap;
import net.malisis.blocks.tileentity.VanishingTileEntity;
import net.malisis.core.MalisisCore;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.capabilities.Capability;

public class ProxyAccess {
    private static WeakHashMap<IBlockAccess, IBlockAccess> cache = new WeakHashMap();
    private static boolean worldInstanciationFailed = false;

    public static IBlockAccess get(IBlockAccess world) {
        if (world == null) {
            return null;
        }
        Object proxy = cache.get(world);
        if (proxy == null) {
            if (world instanceof World) {
                if (worldInstanciationFailed) {
                    return world;
                }
                try {
                    proxy = new ProxyWorld((World)world);
                }
                catch (Exception e) {
                    MalisisCore.log.error("[ProxyAccess] Proxy wold instanciation failed :", (Throwable)e);
                    worldInstanciationFailed = true;
                    return world;
                }
            } else {
                proxy = new ProxyBlockAccess(world);
            }
            cache.put(world, (IBlockAccess)proxy);
        }
        return proxy;
    }

    public static VanishingTileEntity getVanishingTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof VanishingTileEntity) {
            return (VanishingTileEntity)te;
        }
        return null;
    }

    public static IBlockState getBlockState(IBlockAccess world, BlockPos pos) {
        VanishingTileEntity te = ProxyAccess.getVanishingTileEntity(world, pos);
        if (te != null) {
            return te.getCopiedState() != null ? te.getCopiedState() : Blocks.field_150350_a.func_176223_P();
        }
        return world.func_180495_p(pos);
    }

    public static TileEntity getTileEntity(IBlockAccess world, BlockPos pos) {
        VanishingTileEntity te = ProxyAccess.getVanishingTileEntity(world, pos);
        if (te != null) {
            return te.getCopiedTileEntity();
        }
        return world.func_175625_s(pos);
    }

    private static class ProxyWorld
    extends World {
        public World original;

        public ProxyWorld(World world) {
            super(world.func_72860_G(), world.func_72912_H(), world.field_73011_w, (Profiler)null, world.field_72995_K);
            this.original = world;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return ProxyAccess.getBlockState((IBlockAccess)this.original, pos);
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return ProxyAccess.getTileEntity((IBlockAccess)this.original, pos);
        }

        public boolean func_180501_a(BlockPos pos, IBlockState state, int flag) {
            VanishingTileEntity te = ProxyAccess.getVanishingTileEntity((IBlockAccess)this.original, pos);
            if (te != null) {
                te.setBlockState(state);
                return true;
            }
            return this.original.func_180501_a(pos, state, flag);
        }

        protected IChunkProvider func_72970_h() {
            return null;
        }

        protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
            return true;
        }

        public World func_175643_b() {
            return this.original.func_175643_b();
        }

        public Biome func_180494_b(BlockPos p_getBiome_1_) {
            return this.original.func_180494_b(p_getBiome_1_);
        }

        public Biome getBiomeForCoordsBody(BlockPos p_getBiomeForCoordsBody_1_) {
            return this.original.getBiomeForCoordsBody(p_getBiomeForCoordsBody_1_);
        }

        public BiomeProvider func_72959_q() {
            return this.original.func_72959_q();
        }

        public void func_72963_a(WorldSettings p_initialize_1_) {
            this.original.func_72963_a(p_initialize_1_);
        }

        public MinecraftServer func_73046_m() {
            return this.original.func_73046_m();
        }

        public void func_72974_f() {
            this.original.func_72974_f();
        }

        public IBlockState func_184141_c(BlockPos p_getGroundAboveSeaLevel_1_) {
            return this.original.func_184141_c(p_getGroundAboveSeaLevel_1_);
        }

        public boolean func_175701_a(BlockPos p_isValid_1_) {
            return this.original.func_175701_a(p_isValid_1_);
        }

        public boolean func_189509_E(BlockPos p_isOutsideBuildHeight_1_) {
            return this.original.func_189509_E(p_isOutsideBuildHeight_1_);
        }

        public boolean func_175623_d(BlockPos p_isAirBlock_1_) {
            return this.original.func_175623_d(p_isAirBlock_1_);
        }

        public boolean func_175667_e(BlockPos p_isBlockLoaded_1_) {
            return this.original.func_175667_e(p_isBlockLoaded_1_);
        }

        public boolean func_175668_a(BlockPos p_isBlockLoaded_1_, boolean p_isBlockLoaded_2_) {
            return this.original.func_175668_a(p_isBlockLoaded_1_, p_isBlockLoaded_2_);
        }

        public boolean func_175697_a(BlockPos p_isAreaLoaded_1_, int p_isAreaLoaded_2_) {
            return this.original.func_175697_a(p_isAreaLoaded_1_, p_isAreaLoaded_2_);
        }

        public boolean func_175648_a(BlockPos p_isAreaLoaded_1_, int p_isAreaLoaded_2_, boolean p_isAreaLoaded_3_) {
            return this.original.func_175648_a(p_isAreaLoaded_1_, p_isAreaLoaded_2_, p_isAreaLoaded_3_);
        }

        public boolean func_175707_a(BlockPos p_isAreaLoaded_1_, BlockPos p_isAreaLoaded_2_) {
            return this.original.func_175707_a(p_isAreaLoaded_1_, p_isAreaLoaded_2_);
        }

        public boolean func_175706_a(BlockPos p_isAreaLoaded_1_, BlockPos p_isAreaLoaded_2_, boolean p_isAreaLoaded_3_) {
            return this.original.func_175706_a(p_isAreaLoaded_1_, p_isAreaLoaded_2_, p_isAreaLoaded_3_);
        }

        public boolean func_175711_a(StructureBoundingBox p_isAreaLoaded_1_) {
            return this.original.func_175711_a(p_isAreaLoaded_1_);
        }

        public boolean func_175639_b(StructureBoundingBox p_isAreaLoaded_1_, boolean p_isAreaLoaded_2_) {
            return this.original.func_175639_b(p_isAreaLoaded_1_, p_isAreaLoaded_2_);
        }

        public Chunk func_175726_f(BlockPos p_getChunkFromBlockCoords_1_) {
            return this.original.func_175726_f(p_getChunkFromBlockCoords_1_);
        }

        public Chunk func_72964_e(int p_getChunkFromChunkCoords_1_, int p_getChunkFromChunkCoords_2_) {
            return this.original.func_72964_e(p_getChunkFromChunkCoords_1_, p_getChunkFromChunkCoords_2_);
        }

        public boolean func_190526_b(int p_isChunkGeneratedAt_1_, int p_isChunkGeneratedAt_2_) {
            return this.original.func_190526_b(p_isChunkGeneratedAt_1_, p_isChunkGeneratedAt_2_);
        }

        public void markAndNotifyBlock(BlockPos arg0, Chunk arg1, IBlockState arg2, IBlockState arg3, int arg4) {
            this.original.markAndNotifyBlock(arg0, arg1, arg2, arg3, arg4);
        }

        public boolean func_175698_g(BlockPos p_setBlockToAir_1_) {
            return this.original.func_175698_g(p_setBlockToAir_1_);
        }

        public boolean func_175655_b(BlockPos p_destroyBlock_1_, boolean p_destroyBlock_2_) {
            return this.original.func_175655_b(p_destroyBlock_1_, p_destroyBlock_2_);
        }

        public boolean func_175656_a(BlockPos p_setBlockState_1_, IBlockState p_setBlockState_2_) {
            return this.original.func_175656_a(p_setBlockState_1_, p_setBlockState_2_);
        }

        public void func_184138_a(BlockPos p_notifyBlockUpdate_1_, IBlockState p_notifyBlockUpdate_2_, IBlockState p_notifyBlockUpdate_3_, int p_notifyBlockUpdate_4_) {
            this.original.func_184138_a(p_notifyBlockUpdate_1_, p_notifyBlockUpdate_2_, p_notifyBlockUpdate_3_, p_notifyBlockUpdate_4_);
        }

        public void func_175722_b(BlockPos p_notifyNeighborsRespectDebug_1_, Block p_notifyNeighborsRespectDebug_2_, boolean p_notifyNeighborsRespectDebug_3_) {
            this.original.func_175722_b(p_notifyNeighborsRespectDebug_1_, p_notifyNeighborsRespectDebug_2_, p_notifyNeighborsRespectDebug_3_);
        }

        public void func_72975_g(int p_markBlocksDirtyVertical_1_, int p_markBlocksDirtyVertical_2_, int p_markBlocksDirtyVertical_3_, int p_markBlocksDirtyVertical_4_) {
            this.original.func_72975_g(p_markBlocksDirtyVertical_1_, p_markBlocksDirtyVertical_2_, p_markBlocksDirtyVertical_3_, p_markBlocksDirtyVertical_4_);
        }

        public void func_175704_b(BlockPos p_markBlockRangeForRenderUpdate_1_, BlockPos p_markBlockRangeForRenderUpdate_2_) {
            this.original.func_175704_b(p_markBlockRangeForRenderUpdate_1_, p_markBlockRangeForRenderUpdate_2_);
        }

        public void func_147458_c(int p_markBlockRangeForRenderUpdate_1_, int p_markBlockRangeForRenderUpdate_2_, int p_markBlockRangeForRenderUpdate_3_, int p_markBlockRangeForRenderUpdate_4_, int p_markBlockRangeForRenderUpdate_5_, int p_markBlockRangeForRenderUpdate_6_) {
            this.original.func_147458_c(p_markBlockRangeForRenderUpdate_1_, p_markBlockRangeForRenderUpdate_2_, p_markBlockRangeForRenderUpdate_3_, p_markBlockRangeForRenderUpdate_4_, p_markBlockRangeForRenderUpdate_5_, p_markBlockRangeForRenderUpdate_6_);
        }

        public void func_190522_c(BlockPos p_updateObservingBlocksAt_1_, Block p_updateObservingBlocksAt_2_) {
            this.original.func_190522_c(p_updateObservingBlocksAt_1_, p_updateObservingBlocksAt_2_);
        }

        public void func_175685_c(BlockPos p_notifyNeighborsOfStateChange_1_, Block p_notifyNeighborsOfStateChange_2_, boolean p_notifyNeighborsOfStateChange_3_) {
            this.original.func_175685_c(p_notifyNeighborsOfStateChange_1_, p_notifyNeighborsOfStateChange_2_, p_notifyNeighborsOfStateChange_3_);
        }

        public void func_175695_a(BlockPos p_notifyNeighborsOfStateExcept_1_, Block p_notifyNeighborsOfStateExcept_2_, EnumFacing p_notifyNeighborsOfStateExcept_3_) {
            this.original.func_175695_a(p_notifyNeighborsOfStateExcept_1_, p_notifyNeighborsOfStateExcept_2_, p_notifyNeighborsOfStateExcept_3_);
        }

        public void func_190524_a(BlockPos p_neighborChanged_1_, Block p_neighborChanged_2_, BlockPos p_neighborChanged_3_) {
            this.original.func_190524_a(p_neighborChanged_1_, p_neighborChanged_2_, p_neighborChanged_3_);
        }

        public void func_190529_b(BlockPos p_observedNeighborChanged_1_, Block p_observedNeighborChanged_2_, BlockPos p_observedNeighborChanged_3_) {
            this.original.func_190529_b(p_observedNeighborChanged_1_, p_observedNeighborChanged_2_, p_observedNeighborChanged_3_);
        }

        public boolean func_175691_a(BlockPos p_isBlockTickPending_1_, Block p_isBlockTickPending_2_) {
            return this.original.func_175691_a(p_isBlockTickPending_1_, p_isBlockTickPending_2_);
        }

        public boolean func_175678_i(BlockPos p_canSeeSky_1_) {
            return this.original.func_175678_i(p_canSeeSky_1_);
        }

        public boolean func_175710_j(BlockPos p_canBlockSeeSky_1_) {
            return this.original.func_175710_j(p_canBlockSeeSky_1_);
        }

        public int func_175699_k(BlockPos p_getLight_1_) {
            return this.original.func_175699_k(p_getLight_1_);
        }

        public int func_175671_l(BlockPos p_getLightFromNeighbors_1_) {
            return this.original.func_175671_l(p_getLightFromNeighbors_1_);
        }

        public int func_175721_c(BlockPos p_getLight_1_, boolean p_getLight_2_) {
            return this.original.func_175721_c(p_getLight_1_, p_getLight_2_);
        }

        public BlockPos func_175645_m(BlockPos p_getHeight_1_) {
            return this.original.func_175645_m(p_getHeight_1_);
        }

        public int func_189649_b(int p_getHeight_1_, int p_getHeight_2_) {
            return this.original.func_189649_b(p_getHeight_1_, p_getHeight_2_);
        }

        @Deprecated
        public int func_82734_g(int p_getChunksLowestHorizon_1_, int p_getChunksLowestHorizon_2_) {
            return this.original.func_82734_g(p_getChunksLowestHorizon_1_, p_getChunksLowestHorizon_2_);
        }

        public int func_175705_a(EnumSkyBlock p_getLightFromNeighborsFor_1_, BlockPos p_getLightFromNeighborsFor_2_) {
            return this.original.func_175705_a(p_getLightFromNeighborsFor_1_, p_getLightFromNeighborsFor_2_);
        }

        public int func_175642_b(EnumSkyBlock p_getLightFor_1_, BlockPos p_getLightFor_2_) {
            return this.original.func_175642_b(p_getLightFor_1_, p_getLightFor_2_);
        }

        public void func_175653_a(EnumSkyBlock p_setLightFor_1_, BlockPos p_setLightFor_2_, int p_setLightFor_3_) {
            this.original.func_175653_a(p_setLightFor_1_, p_setLightFor_2_, p_setLightFor_3_);
        }

        public void func_175679_n(BlockPos p_notifyLightSet_1_) {
            this.original.func_175679_n(p_notifyLightSet_1_);
        }

        public int func_175626_b(BlockPos p_getCombinedLight_1_, int p_getCombinedLight_2_) {
            return this.original.func_175626_b(p_getCombinedLight_1_, p_getCombinedLight_2_);
        }

        public float func_175724_o(BlockPos p_getLightBrightness_1_) {
            return this.original.func_175724_o(p_getLightBrightness_1_);
        }

        public boolean func_72935_r() {
            return this.original.func_72935_r();
        }

        public RayTraceResult func_72933_a(Vec3d p_rayTraceBlocks_1_, Vec3d p_rayTraceBlocks_2_) {
            return this.original.func_72933_a(p_rayTraceBlocks_1_, p_rayTraceBlocks_2_);
        }

        public RayTraceResult func_72901_a(Vec3d p_rayTraceBlocks_1_, Vec3d p_rayTraceBlocks_2_, boolean p_rayTraceBlocks_3_) {
            return this.original.func_72901_a(p_rayTraceBlocks_1_, p_rayTraceBlocks_2_, p_rayTraceBlocks_3_);
        }

        public RayTraceResult func_147447_a(Vec3d p_rayTraceBlocks_1_, Vec3d p_rayTraceBlocks_2_, boolean p_rayTraceBlocks_3_, boolean p_rayTraceBlocks_4_, boolean p_rayTraceBlocks_5_) {
            return this.original.func_147447_a(p_rayTraceBlocks_1_, p_rayTraceBlocks_2_, p_rayTraceBlocks_3_, p_rayTraceBlocks_4_, p_rayTraceBlocks_5_);
        }

        public void func_184133_a(EntityPlayer arg0, BlockPos arg1, SoundEvent arg2, SoundCategory arg3, float arg4, float arg5) {
            this.original.func_184133_a(arg0, arg1, arg2, arg3, arg4, arg5);
        }

        public void func_184148_a(EntityPlayer arg0, double arg1, double arg2, double arg3, SoundEvent arg4, SoundCategory arg5, float arg6, float arg7) {
            this.original.func_184148_a(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }

        public void func_184134_a(double p_playSound_1_, double p_playSound_3_, double p_playSound_5_, SoundEvent p_playSound_7_, SoundCategory p_playSound_8_, float p_playSound_9_, float p_playSound_10_, boolean p_playSound_11_) {
            this.original.func_184134_a(p_playSound_1_, p_playSound_3_, p_playSound_5_, p_playSound_7_, p_playSound_8_, p_playSound_9_, p_playSound_10_, p_playSound_11_);
        }

        public void func_184149_a(BlockPos arg0, SoundEvent arg1) {
            this.original.func_184149_a(arg0, arg1);
        }

        public void func_175688_a(EnumParticleTypes p_spawnParticle_1_, double p_spawnParticle_2_, double p_spawnParticle_4_, double p_spawnParticle_6_, double p_spawnParticle_8_, double p_spawnParticle_10_, double p_spawnParticle_12_, int ... p_spawnParticle_14_) {
            this.original.func_175688_a(p_spawnParticle_1_, p_spawnParticle_2_, p_spawnParticle_4_, p_spawnParticle_6_, p_spawnParticle_8_, p_spawnParticle_10_, p_spawnParticle_12_, p_spawnParticle_14_);
        }

        public void func_190523_a(int p_spawnAlwaysVisibleParticle_1_, double p_spawnAlwaysVisibleParticle_2_, double p_spawnAlwaysVisibleParticle_4_, double p_spawnAlwaysVisibleParticle_6_, double p_spawnAlwaysVisibleParticle_8_, double p_spawnAlwaysVisibleParticle_10_, double p_spawnAlwaysVisibleParticle_12_, int ... p_spawnAlwaysVisibleParticle_14_) {
            this.original.func_190523_a(p_spawnAlwaysVisibleParticle_1_, p_spawnAlwaysVisibleParticle_2_, p_spawnAlwaysVisibleParticle_4_, p_spawnAlwaysVisibleParticle_6_, p_spawnAlwaysVisibleParticle_8_, p_spawnAlwaysVisibleParticle_10_, p_spawnAlwaysVisibleParticle_12_, p_spawnAlwaysVisibleParticle_14_);
        }

        public void func_175682_a(EnumParticleTypes p_spawnParticle_1_, boolean p_spawnParticle_2_, double p_spawnParticle_3_, double p_spawnParticle_5_, double p_spawnParticle_7_, double p_spawnParticle_9_, double p_spawnParticle_11_, double p_spawnParticle_13_, int ... p_spawnParticle_15_) {
            this.original.func_175682_a(p_spawnParticle_1_, p_spawnParticle_2_, p_spawnParticle_3_, p_spawnParticle_5_, p_spawnParticle_7_, p_spawnParticle_9_, p_spawnParticle_11_, p_spawnParticle_13_, p_spawnParticle_15_);
        }

        public boolean func_72942_c(Entity p_addWeatherEffect_1_) {
            return this.original.func_72942_c(p_addWeatherEffect_1_);
        }

        public boolean func_72838_d(Entity p_spawnEntity_1_) {
            return this.original.func_72838_d(p_spawnEntity_1_);
        }

        public void func_72923_a(Entity p_onEntityAdded_1_) {
            this.original.func_72923_a(p_onEntityAdded_1_);
        }

        public void func_72847_b(Entity p_onEntityRemoved_1_) {
            this.original.func_72847_b(p_onEntityRemoved_1_);
        }

        public void func_72900_e(Entity p_removeEntity_1_) {
            this.original.func_72900_e(p_removeEntity_1_);
        }

        public void func_72973_f(Entity p_removeEntityDangerously_1_) {
            this.original.func_72973_f(p_removeEntityDangerously_1_);
        }

        public void func_72954_a(IWorldEventListener p_addEventListener_1_) {
            this.original.func_72954_a(p_addEventListener_1_);
        }

        public List<AxisAlignedBB> func_184144_a(Entity arg0, AxisAlignedBB arg1) {
            return this.original.func_184144_a(arg0, arg1);
        }

        public void func_72848_b(IWorldEventListener p_removeEventListener_1_) {
            this.original.func_72848_b(p_removeEventListener_1_);
        }

        public boolean func_191503_g(Entity p_isInsideWorldBorder_1_) {
            return this.original.func_191503_g(p_isInsideWorldBorder_1_);
        }

        public boolean func_184143_b(AxisAlignedBB p_collidesWithAnyBlock_1_) {
            return this.original.func_184143_b(p_collidesWithAnyBlock_1_);
        }

        public int func_72967_a(float p_calculateSkylightSubtracted_1_) {
            return this.original.func_72967_a(p_calculateSkylightSubtracted_1_);
        }

        public float getSunBrightnessFactor(float p_getSunBrightnessFactor_1_) {
            return this.original.getSunBrightnessFactor(p_getSunBrightnessFactor_1_);
        }

        public float func_72971_b(float p_getSunBrightness_1_) {
            return this.original.func_72971_b(p_getSunBrightness_1_);
        }

        public float getSunBrightnessBody(float p_getSunBrightnessBody_1_) {
            return this.original.getSunBrightnessBody(p_getSunBrightnessBody_1_);
        }

        public Vec3d func_72833_a(Entity p_getSkyColor_1_, float p_getSkyColor_2_) {
            return this.original.func_72833_a(p_getSkyColor_1_, p_getSkyColor_2_);
        }

        public Vec3d getSkyColorBody(Entity p_getSkyColorBody_1_, float p_getSkyColorBody_2_) {
            return this.original.getSkyColorBody(p_getSkyColorBody_1_, p_getSkyColorBody_2_);
        }

        public float func_72826_c(float p_getCelestialAngle_1_) {
            return this.original.func_72826_c(p_getCelestialAngle_1_);
        }

        public int func_72853_d() {
            return this.original.func_72853_d();
        }

        public float func_130001_d() {
            return this.original.func_130001_d();
        }

        public float getCurrentMoonPhaseFactorBody() {
            return this.original.getCurrentMoonPhaseFactorBody();
        }

        public float func_72929_e(float p_getCelestialAngleRadians_1_) {
            return this.original.func_72929_e(p_getCelestialAngleRadians_1_);
        }

        public Vec3d func_72824_f(float p_getCloudColour_1_) {
            return this.original.func_72824_f(p_getCloudColour_1_);
        }

        public Vec3d getCloudColorBody(float p_getCloudColorBody_1_) {
            return this.original.getCloudColorBody(p_getCloudColorBody_1_);
        }

        public Vec3d func_72948_g(float p_getFogColor_1_) {
            return this.original.func_72948_g(p_getFogColor_1_);
        }

        public BlockPos func_175725_q(BlockPos p_getPrecipitationHeight_1_) {
            return this.original.func_175725_q(p_getPrecipitationHeight_1_);
        }

        public BlockPos func_175672_r(BlockPos p_getTopSolidOrLiquidBlock_1_) {
            return this.original.func_175672_r(p_getTopSolidOrLiquidBlock_1_);
        }

        public float func_72880_h(float p_getStarBrightness_1_) {
            return this.original.func_72880_h(p_getStarBrightness_1_);
        }

        public float getStarBrightnessBody(float p_getStarBrightnessBody_1_) {
            return this.original.getStarBrightnessBody(p_getStarBrightnessBody_1_);
        }

        public boolean func_184145_b(BlockPos p_isUpdateScheduled_1_, Block p_isUpdateScheduled_2_) {
            return this.original.func_184145_b(p_isUpdateScheduled_1_, p_isUpdateScheduled_2_);
        }

        public void func_175684_a(BlockPos p_scheduleUpdate_1_, Block p_scheduleUpdate_2_, int p_scheduleUpdate_3_) {
            this.original.func_175684_a(p_scheduleUpdate_1_, p_scheduleUpdate_2_, p_scheduleUpdate_3_);
        }

        public void func_175654_a(BlockPos p_updateBlockTick_1_, Block p_updateBlockTick_2_, int p_updateBlockTick_3_, int p_updateBlockTick_4_) {
            this.original.func_175654_a(p_updateBlockTick_1_, p_updateBlockTick_2_, p_updateBlockTick_3_, p_updateBlockTick_4_);
        }

        public void func_180497_b(BlockPos p_scheduleBlockUpdate_1_, Block p_scheduleBlockUpdate_2_, int p_scheduleBlockUpdate_3_, int p_scheduleBlockUpdate_4_) {
            this.original.func_180497_b(p_scheduleBlockUpdate_1_, p_scheduleBlockUpdate_2_, p_scheduleBlockUpdate_3_, p_scheduleBlockUpdate_4_);
        }

        public void func_72939_s() {
            this.original.func_72939_s();
        }

        public boolean func_175700_a(TileEntity p_addTileEntity_1_) {
            return this.original.func_175700_a(p_addTileEntity_1_);
        }

        public void func_147448_a(Collection<TileEntity> p_addTileEntities_1_) {
            this.original.func_147448_a(p_addTileEntities_1_);
        }

        public void func_72870_g(Entity p_updateEntity_1_) {
            this.original.func_72870_g(p_updateEntity_1_);
        }

        public void func_72866_a(Entity p_updateEntityWithOptionalForce_1_, boolean p_updateEntityWithOptionalForce_2_) {
            this.original.func_72866_a(p_updateEntityWithOptionalForce_1_, p_updateEntityWithOptionalForce_2_);
        }

        public boolean func_72855_b(AxisAlignedBB p_checkNoEntityCollision_1_) {
            return this.original.func_72855_b(p_checkNoEntityCollision_1_);
        }

        public boolean func_72917_a(AxisAlignedBB arg0, Entity arg1) {
            return this.original.func_72917_a(arg0, arg1);
        }

        public boolean func_72829_c(AxisAlignedBB p_checkBlockCollision_1_) {
            return this.original.func_72829_c(p_checkBlockCollision_1_);
        }

        public boolean func_72953_d(AxisAlignedBB p_containsAnyLiquid_1_) {
            return this.original.func_72953_d(p_containsAnyLiquid_1_);
        }

        public boolean func_147470_e(AxisAlignedBB p_isFlammableWithin_1_) {
            return this.original.func_147470_e(p_isFlammableWithin_1_);
        }

        public boolean func_72918_a(AxisAlignedBB p_handleMaterialAcceleration_1_, Material p_handleMaterialAcceleration_2_, Entity p_handleMaterialAcceleration_3_) {
            return this.original.func_72918_a(p_handleMaterialAcceleration_1_, p_handleMaterialAcceleration_2_, p_handleMaterialAcceleration_3_);
        }

        public boolean func_72875_a(AxisAlignedBB p_isMaterialInBB_1_, Material p_isMaterialInBB_2_) {
            return this.original.func_72875_a(p_isMaterialInBB_1_, p_isMaterialInBB_2_);
        }

        public Explosion func_72876_a(Entity arg0, double arg1, double arg2, double arg3, float arg4, boolean arg5) {
            return this.original.func_72876_a(arg0, arg1, arg2, arg3, arg4, arg5);
        }

        public Explosion func_72885_a(Entity arg0, double arg1, double arg2, double arg3, float arg4, boolean arg5, boolean arg6) {
            return this.original.func_72885_a(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        }

        public float func_72842_a(Vec3d p_getBlockDensity_1_, AxisAlignedBB p_getBlockDensity_2_) {
            return this.original.func_72842_a(p_getBlockDensity_1_, p_getBlockDensity_2_);
        }

        public boolean func_175719_a(EntityPlayer arg0, BlockPos arg1, EnumFacing arg2) {
            return this.original.func_175719_a(arg0, arg1, arg2);
        }

        public String func_72981_t() {
            return this.original.func_72981_t();
        }

        public String func_72827_u() {
            return this.original.func_72827_u();
        }

        public void func_175690_a(BlockPos arg0, TileEntity arg1) {
            this.original.func_175690_a(arg0, arg1);
        }

        public void func_175713_t(BlockPos p_removeTileEntity_1_) {
            this.original.func_175713_t(p_removeTileEntity_1_);
        }

        public void func_147457_a(TileEntity p_markTileEntityForRemoval_1_) {
            this.original.func_147457_a(p_markTileEntityForRemoval_1_);
        }

        public boolean func_175665_u(BlockPos p_isBlockFullCube_1_) {
            return this.original.func_175665_u(p_isBlockFullCube_1_);
        }

        public boolean func_175677_d(BlockPos p_isBlockNormalCube_1_, boolean p_isBlockNormalCube_2_) {
            return this.original.func_175677_d(p_isBlockNormalCube_1_, p_isBlockNormalCube_2_);
        }

        public void func_72966_v() {
            this.original.func_72966_v();
        }

        public void func_72891_a(boolean p_setAllowedSpawnTypes_1_, boolean p_setAllowedSpawnTypes_2_) {
            this.original.func_72891_a(p_setAllowedSpawnTypes_1_, p_setAllowedSpawnTypes_2_);
        }

        public void func_72835_b() {
            this.original.func_72835_b();
        }

        public void calculateInitialWeatherBody() {
            this.original.calculateInitialWeatherBody();
        }

        public void updateWeatherBody() {
            this.original.updateWeatherBody();
        }

        public void func_189507_a(BlockPos p_immediateBlockTick_1_, IBlockState p_immediateBlockTick_2_, Random p_immediateBlockTick_3_) {
            this.original.func_189507_a(p_immediateBlockTick_1_, p_immediateBlockTick_2_, p_immediateBlockTick_3_);
        }

        public boolean func_175675_v(BlockPos p_canBlockFreezeWater_1_) {
            return this.original.func_175675_v(p_canBlockFreezeWater_1_);
        }

        public boolean func_175662_w(BlockPos p_canBlockFreezeNoWater_1_) {
            return this.original.func_175662_w(p_canBlockFreezeNoWater_1_);
        }

        public boolean func_175670_e(BlockPos p_canBlockFreeze_1_, boolean p_canBlockFreeze_2_) {
            return this.original.func_175670_e(p_canBlockFreeze_1_, p_canBlockFreeze_2_);
        }

        public boolean canBlockFreezeBody(BlockPos p_canBlockFreezeBody_1_, boolean p_canBlockFreezeBody_2_) {
            return this.original.canBlockFreezeBody(p_canBlockFreezeBody_1_, p_canBlockFreezeBody_2_);
        }

        public boolean func_175708_f(BlockPos p_canSnowAt_1_, boolean p_canSnowAt_2_) {
            return this.original.func_175708_f(p_canSnowAt_1_, p_canSnowAt_2_);
        }

        public boolean canSnowAtBody(BlockPos p_canSnowAtBody_1_, boolean p_canSnowAtBody_2_) {
            return this.original.canSnowAtBody(p_canSnowAtBody_1_, p_canSnowAtBody_2_);
        }

        public boolean func_175664_x(BlockPos p_checkLight_1_) {
            return this.original.func_175664_x(p_checkLight_1_);
        }

        public boolean func_180500_c(EnumSkyBlock p_checkLightFor_1_, BlockPos p_checkLightFor_2_) {
            return this.original.func_180500_c(p_checkLightFor_1_, p_checkLightFor_2_);
        }

        public boolean func_72955_a(boolean p_tickUpdates_1_) {
            return this.original.func_72955_a(p_tickUpdates_1_);
        }

        public List<NextTickListEntry> func_72920_a(Chunk p_getPendingBlockUpdates_1_, boolean p_getPendingBlockUpdates_2_) {
            return this.original.func_72920_a(p_getPendingBlockUpdates_1_, p_getPendingBlockUpdates_2_);
        }

        public List<NextTickListEntry> func_175712_a(StructureBoundingBox p_getPendingBlockUpdates_1_, boolean p_getPendingBlockUpdates_2_) {
            return this.original.func_175712_a(p_getPendingBlockUpdates_1_, p_getPendingBlockUpdates_2_);
        }

        public List<Entity> func_72839_b(Entity arg0, AxisAlignedBB arg1) {
            return this.original.func_72839_b(arg0, arg1);
        }

        public List<Entity> func_175674_a(Entity arg0, AxisAlignedBB arg1, Predicate<? super Entity> arg2) {
            return this.original.func_175674_a(arg0, arg1, arg2);
        }

        public <T extends Entity> List<T> func_175644_a(Class<? extends T> p_getEntities_1_, Predicate<? super T> p_getEntities_2_) {
            return this.original.func_175644_a(p_getEntities_1_, p_getEntities_2_);
        }

        public <T extends Entity> List<T> func_175661_b(Class<? extends T> p_getPlayers_1_, Predicate<? super T> p_getPlayers_2_) {
            return this.original.func_175661_b(p_getPlayers_1_, p_getPlayers_2_);
        }

        public <T extends Entity> List<T> func_72872_a(Class<? extends T> p_getEntitiesWithinAABB_1_, AxisAlignedBB p_getEntitiesWithinAABB_2_) {
            return this.original.func_72872_a(p_getEntitiesWithinAABB_1_, p_getEntitiesWithinAABB_2_);
        }

        public <T extends Entity> List<T> func_175647_a(Class<? extends T> arg0, AxisAlignedBB arg1, Predicate<? super T> arg2) {
            return this.original.func_175647_a(arg0, arg1, arg2);
        }

        public <T extends Entity> T func_72857_a(Class<? extends T> p_findNearestEntityWithinAABB_1_, AxisAlignedBB p_findNearestEntityWithinAABB_2_, T p_findNearestEntityWithinAABB_3_) {
            return (T)this.original.func_72857_a(p_findNearestEntityWithinAABB_1_, p_findNearestEntityWithinAABB_2_, p_findNearestEntityWithinAABB_3_);
        }

        public Entity func_73045_a(int p_getEntityByID_1_) {
            return this.original.func_73045_a(p_getEntityByID_1_);
        }

        public List<Entity> func_72910_y() {
            return this.original.func_72910_y();
        }

        public void func_175646_b(BlockPos p_markChunkDirty_1_, TileEntity p_markChunkDirty_2_) {
            this.original.func_175646_b(p_markChunkDirty_1_, p_markChunkDirty_2_);
        }

        public int func_72907_a(Class<?> p_countEntities_1_) {
            return this.original.func_72907_a(p_countEntities_1_);
        }

        public void func_175650_b(Collection<Entity> p_loadEntities_1_) {
            this.original.func_175650_b(p_loadEntities_1_);
        }

        public void func_175681_c(Collection<Entity> p_unloadEntities_1_) {
            this.original.func_175681_c(p_unloadEntities_1_);
        }

        public boolean func_190527_a(Block arg0, BlockPos arg1, boolean arg2, EnumFacing arg3, Entity arg4) {
            return this.original.func_190527_a(arg0, arg1, arg2, arg3, arg4);
        }

        public int func_181545_F() {
            return this.original.func_181545_F();
        }

        public void func_181544_b(int p_setSeaLevel_1_) {
            this.original.func_181544_b(p_setSeaLevel_1_);
        }

        public int func_175627_a(BlockPos p_getStrongPower_1_, EnumFacing p_getStrongPower_2_) {
            return this.original.func_175627_a(p_getStrongPower_1_, p_getStrongPower_2_);
        }

        public WorldType func_175624_G() {
            return this.original.func_175624_G();
        }

        public int func_175676_y(BlockPos p_getStrongPower_1_) {
            return this.original.func_175676_y(p_getStrongPower_1_);
        }

        public boolean func_175709_b(BlockPos p_isSidePowered_1_, EnumFacing p_isSidePowered_2_) {
            return this.original.func_175709_b(p_isSidePowered_1_, p_isSidePowered_2_);
        }

        public int func_175651_c(BlockPos p_getRedstonePower_1_, EnumFacing p_getRedstonePower_2_) {
            return this.original.func_175651_c(p_getRedstonePower_1_, p_getRedstonePower_2_);
        }

        public boolean func_175640_z(BlockPos p_isBlockPowered_1_) {
            return this.original.func_175640_z(p_isBlockPowered_1_);
        }

        public int func_175687_A(BlockPos p_isBlockIndirectlyGettingPowered_1_) {
            return this.original.func_175687_A(p_isBlockIndirectlyGettingPowered_1_);
        }

        public EntityPlayer func_72890_a(Entity p_getClosestPlayerToEntity_1_, double p_getClosestPlayerToEntity_2_) {
            return this.original.func_72890_a(p_getClosestPlayerToEntity_1_, p_getClosestPlayerToEntity_2_);
        }

        public EntityPlayer func_184136_b(Entity p_getNearestPlayerNotCreative_1_, double p_getNearestPlayerNotCreative_2_) {
            return this.original.func_184136_b(p_getNearestPlayerNotCreative_1_, p_getNearestPlayerNotCreative_2_);
        }

        public EntityPlayer func_184137_a(double p_getClosestPlayer_1_, double p_getClosestPlayer_3_, double p_getClosestPlayer_5_, double p_getClosestPlayer_7_, boolean p_getClosestPlayer_9_) {
            return this.original.func_184137_a(p_getClosestPlayer_1_, p_getClosestPlayer_3_, p_getClosestPlayer_5_, p_getClosestPlayer_7_, p_getClosestPlayer_9_);
        }

        public EntityPlayer func_190525_a(double p_getClosestPlayer_1_, double p_getClosestPlayer_3_, double p_getClosestPlayer_5_, double p_getClosestPlayer_7_, Predicate<Entity> p_getClosestPlayer_9_) {
            return this.original.func_190525_a(p_getClosestPlayer_1_, p_getClosestPlayer_3_, p_getClosestPlayer_5_, p_getClosestPlayer_7_, p_getClosestPlayer_9_);
        }

        public boolean func_175636_b(double p_isAnyPlayerWithinRangeAt_1_, double p_isAnyPlayerWithinRangeAt_3_, double p_isAnyPlayerWithinRangeAt_5_, double p_isAnyPlayerWithinRangeAt_7_) {
            return this.original.func_175636_b(p_isAnyPlayerWithinRangeAt_1_, p_isAnyPlayerWithinRangeAt_3_, p_isAnyPlayerWithinRangeAt_5_, p_isAnyPlayerWithinRangeAt_7_);
        }

        public EntityPlayer func_184142_a(Entity p_getNearestAttackablePlayer_1_, double p_getNearestAttackablePlayer_2_, double p_getNearestAttackablePlayer_4_) {
            return this.original.func_184142_a(p_getNearestAttackablePlayer_1_, p_getNearestAttackablePlayer_2_, p_getNearestAttackablePlayer_4_);
        }

        public EntityPlayer func_184139_a(BlockPos p_getNearestAttackablePlayer_1_, double p_getNearestAttackablePlayer_2_, double p_getNearestAttackablePlayer_4_) {
            return this.original.func_184139_a(p_getNearestAttackablePlayer_1_, p_getNearestAttackablePlayer_2_, p_getNearestAttackablePlayer_4_);
        }

        public EntityPlayer func_184150_a(double arg0, double arg1, double arg2, double arg3, double arg4, Function<EntityPlayer, Double> arg5, Predicate<EntityPlayer> arg6) {
            return this.original.func_184150_a(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        }

        public EntityPlayer func_72924_a(String p_getPlayerEntityByName_1_) {
            return this.original.func_72924_a(p_getPlayerEntityByName_1_);
        }

        public EntityPlayer func_152378_a(UUID p_getPlayerEntityByUUID_1_) {
            return this.original.func_152378_a(p_getPlayerEntityByUUID_1_);
        }

        public void func_72882_A() {
            this.original.func_72882_A();
        }

        public void func_72906_B() throws MinecraftException {
            this.original.func_72906_B();
        }

        public void func_82738_a(long p_setTotalWorldTime_1_) {
            this.original.func_82738_a(p_setTotalWorldTime_1_);
        }

        public long func_72905_C() {
            return this.original.func_72905_C();
        }

        public long func_82737_E() {
            return this.original.func_82737_E();
        }

        public long func_72820_D() {
            return this.original.func_72820_D();
        }

        public void func_72877_b(long p_setWorldTime_1_) {
            this.original.func_72877_b(p_setWorldTime_1_);
        }

        public BlockPos func_175694_M() {
            return this.original.func_175694_M();
        }

        public void func_175652_B(BlockPos p_setSpawnPoint_1_) {
            this.original.func_175652_B(p_setSpawnPoint_1_);
        }

        public void func_72897_h(Entity p_joinEntityInSurroundings_1_) {
            this.original.func_72897_h(p_joinEntityInSurroundings_1_);
        }

        public boolean func_175660_a(EntityPlayer p_isBlockModifiable_1_, BlockPos p_isBlockModifiable_2_) {
            return this.original.func_175660_a(p_isBlockModifiable_1_, p_isBlockModifiable_2_);
        }

        public boolean canMineBlockBody(EntityPlayer p_canMineBlockBody_1_, BlockPos p_canMineBlockBody_2_) {
            return this.original.canMineBlockBody(p_canMineBlockBody_1_, p_canMineBlockBody_2_);
        }

        public void func_72960_a(Entity p_setEntityState_1_, byte p_setEntityState_2_) {
            this.original.func_72960_a(p_setEntityState_1_, p_setEntityState_2_);
        }

        public IChunkProvider func_72863_F() {
            return this.original.func_72863_F();
        }

        public void func_175641_c(BlockPos p_addBlockEvent_1_, Block p_addBlockEvent_2_, int p_addBlockEvent_3_, int p_addBlockEvent_4_) {
            this.original.func_175641_c(p_addBlockEvent_1_, p_addBlockEvent_2_, p_addBlockEvent_3_, p_addBlockEvent_4_);
        }

        public ISaveHandler func_72860_G() {
            return this.original.func_72860_G();
        }

        public WorldInfo func_72912_H() {
            return this.original.func_72912_H();
        }

        public GameRules func_82736_K() {
            return this.original.func_82736_K();
        }

        public void func_72854_c() {
            this.original.func_72854_c();
        }

        public float func_72819_i(float p_getThunderStrength_1_) {
            return this.original.func_72819_i(p_getThunderStrength_1_);
        }

        public void func_147442_i(float p_setThunderStrength_1_) {
            this.original.func_147442_i(p_setThunderStrength_1_);
        }

        public float func_72867_j(float p_getRainStrength_1_) {
            return this.original.func_72867_j(p_getRainStrength_1_);
        }

        public void func_72894_k(float p_setRainStrength_1_) {
            this.original.func_72894_k(p_setRainStrength_1_);
        }

        public boolean func_72911_I() {
            return this.original.func_72911_I();
        }

        public boolean func_72896_J() {
            return this.original.func_72896_J();
        }

        public boolean func_175727_C(BlockPos p_isRainingAt_1_) {
            return this.original.func_175727_C(p_isRainingAt_1_);
        }

        public boolean func_180502_D(BlockPos p_isBlockinHighHumidity_1_) {
            return this.original.func_180502_D(p_isBlockinHighHumidity_1_);
        }

        public MapStorage func_175693_T() {
            return this.original.func_175693_T();
        }

        public void func_72823_a(String p_setData_1_, WorldSavedData p_setData_2_) {
            this.original.func_72823_a(p_setData_1_, p_setData_2_);
        }

        public WorldSavedData func_72943_a(Class<? extends WorldSavedData> p_loadData_1_, String p_loadData_2_) {
            return this.original.func_72943_a(p_loadData_1_, p_loadData_2_);
        }

        public int func_72841_b(String p_getUniqueDataId_1_) {
            return this.original.func_72841_b(p_getUniqueDataId_1_);
        }

        public void func_175669_a(int p_playBroadcastSound_1_, BlockPos p_playBroadcastSound_2_, int p_playBroadcastSound_3_) {
            this.original.func_175669_a(p_playBroadcastSound_1_, p_playBroadcastSound_2_, p_playBroadcastSound_3_);
        }

        public void func_175718_b(int p_playEvent_1_, BlockPos p_playEvent_2_, int p_playEvent_3_) {
            this.original.func_175718_b(p_playEvent_1_, p_playEvent_2_, p_playEvent_3_);
        }

        public void func_180498_a(EntityPlayer arg0, int arg1, BlockPos arg2, int arg3) {
            this.original.func_180498_a(arg0, arg1, arg2, arg3);
        }

        public int func_72800_K() {
            return this.original.func_72800_K();
        }

        public int func_72940_L() {
            return this.original.func_72940_L();
        }

        public Random func_72843_D(int p_setRandomSeed_1_, int p_setRandomSeed_2_, int p_setRandomSeed_3_) {
            return this.original.func_72843_D(p_setRandomSeed_1_, p_setRandomSeed_2_, p_setRandomSeed_3_);
        }

        public CrashReportCategory func_72914_a(CrashReport p_addWorldInfoToCrashReport_1_) {
            return this.original.func_72914_a(p_addWorldInfoToCrashReport_1_);
        }

        public double func_72919_O() {
            return this.original.func_72919_O();
        }

        public void func_175715_c(int p_sendBlockBreakProgress_1_, BlockPos p_sendBlockBreakProgress_2_, int p_sendBlockBreakProgress_3_) {
            this.original.func_175715_c(p_sendBlockBreakProgress_1_, p_sendBlockBreakProgress_2_, p_sendBlockBreakProgress_3_);
        }

        public Calendar func_83015_S() {
            return this.original.func_83015_S();
        }

        public void func_92088_a(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5, NBTTagCompound arg6) {
            this.original.func_92088_a(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
        }

        public Scoreboard func_96441_U() {
            return this.original.func_96441_U();
        }

        public void func_175666_e(BlockPos p_updateComparatorOutputLevel_1_, Block p_updateComparatorOutputLevel_2_) {
            this.original.func_175666_e(p_updateComparatorOutputLevel_1_, p_updateComparatorOutputLevel_2_);
        }

        public DifficultyInstance func_175649_E(BlockPos p_getDifficultyForLocation_1_) {
            return this.original.func_175649_E(p_getDifficultyForLocation_1_);
        }

        public EnumDifficulty func_175659_aa() {
            return this.original.func_175659_aa();
        }

        public int func_175657_ab() {
            return this.original.func_175657_ab();
        }

        public void func_175692_b(int p_setSkylightSubtracted_1_) {
            this.original.func_175692_b(p_setSkylightSubtracted_1_);
        }

        public int func_175658_ac() {
            return this.original.func_175658_ac();
        }

        public void func_175702_c(int p_setLastLightningBolt_1_) {
            this.original.func_175702_c(p_setLastLightningBolt_1_);
        }

        public VillageCollection func_175714_ae() {
            return this.original.func_175714_ae();
        }

        public WorldBorder func_175723_af() {
            return this.original.func_175723_af();
        }

        public boolean func_72916_c(int p_isSpawnChunk_1_, int p_isSpawnChunk_2_) {
            return this.original.func_72916_c(p_isSpawnChunk_1_, p_isSpawnChunk_2_);
        }

        public boolean isSideSolid(BlockPos p_isSideSolid_1_, EnumFacing p_isSideSolid_2_) {
            return this.original.isSideSolid(p_isSideSolid_1_, p_isSideSolid_2_);
        }

        public boolean isSideSolid(BlockPos p_isSideSolid_1_, EnumFacing p_isSideSolid_2_, boolean p_isSideSolid_3_) {
            return this.original.isSideSolid(p_isSideSolid_1_, p_isSideSolid_2_, p_isSideSolid_3_);
        }

        public ImmutableSetMultimap<ChunkPos, ForgeChunkManager.Ticket> getPersistentChunks() {
            return this.original.getPersistentChunks();
        }

        public Iterator<Chunk> getPersistentChunkIterable(Iterator<Chunk> p_getPersistentChunkIterable_1_) {
            return this.original.getPersistentChunkIterable(p_getPersistentChunkIterable_1_);
        }

        public int getBlockLightOpacity(BlockPos p_getBlockLightOpacity_1_) {
            return this.original.getBlockLightOpacity(p_getBlockLightOpacity_1_);
        }

        public int countEntities(EnumCreatureType p_countEntities_1_, boolean p_countEntities_2_) {
            return this.original.countEntities(p_countEntities_1_, p_countEntities_2_);
        }

        @Deprecated
        public void markTileEntitiesInChunkForRemoval(Chunk p_markTileEntitiesInChunkForRemoval_1_) {
            this.original.markTileEntitiesInChunkForRemoval(p_markTileEntitiesInChunkForRemoval_1_);
        }

        public boolean hasCapability(Capability<?> arg0, EnumFacing arg1) {
            return this.original.hasCapability(arg0, arg1);
        }

        public <T> T getCapability(Capability<T> arg0, EnumFacing arg1) {
            return (T)this.original.getCapability(arg0, arg1);
        }

        public MapStorage getPerWorldStorage() {
            return this.original.getPerWorldStorage();
        }

        public void func_184135_a(Packet<?> p_sendPacketToServer_1_) {
            this.original.func_184135_a(p_sendPacketToServer_1_);
        }

        public LootTableManager func_184146_ak() {
            return this.original.func_184146_ak();
        }

        public BlockPos func_190528_a(String p_findNearestStructure_1_, BlockPos p_findNearestStructure_2_, boolean p_findNearestStructure_3_) {
            return this.original.func_190528_a(p_findNearestStructure_1_, p_findNearestStructure_2_, p_findNearestStructure_3_);
        }
    }

    private static class ProxyBlockAccess
    implements IBlockAccess {
        public IBlockAccess original;

        public ProxyBlockAccess(IBlockAccess world) {
            this.original = world;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return ProxyAccess.getBlockState(this.original, pos);
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return ProxyAccess.getTileEntity(this.original, pos);
        }

        public int func_175626_b(BlockPos arg0, int arg1) {
            return this.original.func_175626_b(arg0, arg1);
        }

        public boolean func_175623_d(BlockPos arg0) {
            return this.original.func_175623_d(arg0);
        }

        public Biome func_180494_b(BlockPos arg0) {
            return this.original.func_180494_b(arg0);
        }

        public int func_175627_a(BlockPos arg0, EnumFacing arg1) {
            return this.original.func_175627_a(arg0, arg1);
        }

        public WorldType func_175624_G() {
            return this.original.func_175624_G();
        }

        public boolean isSideSolid(BlockPos arg0, EnumFacing arg1, boolean arg2) {
            return this.original.isSideSolid(arg0, arg1, arg2);
        }
    }

    private static interface IProxyAccess {
        public IBlockState getBlockState(BlockPos var1);

        public TileEntity getTileEntity(BlockPos var1);

        public boolean setBlockState(BlockPos var1, IBlockState var2, int var3);
    }
}

