/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.model.loader;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.AlphaTransform;
import net.malisis.core.renderer.animation.transformation.BrightnessTransform;
import net.malisis.core.renderer.animation.transformation.ChainedTransformation;
import net.malisis.core.renderer.animation.transformation.ColorTransform;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Scale;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.model.IAnimationLoader;
import net.malisis.core.util.Silenced;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.ArrayUtils;

public class AnimationImporter
implements IAnimationLoader {
    private Map<String, Transform> transforms = Maps.newHashMap();
    private Multimap<String, Anim> anims = ArrayListMultimap.create();
    private Multimap<String, Animation<Shape>> animations = ArrayListMultimap.create();

    public AnimationImporter(ResourceLocation resourceLocation) {
        this.load(resourceLocation);
    }

    @Override
    public Multimap<String, Animation<Shape>> getAnimations(Map<String, Shape> shapes) {
        for (Map.Entry entry : this.anims.entries()) {
            Anim anim = (Anim)entry.getValue();
            Shape s = shapes.get(anim.group);
            Transformation<?, Shape> t = this.getTransform(anim.transform);
            if (s == null) {
                MalisisCore.log.error("Could not find shape {} in the model. Ignoring this animation.", (Object)anim.group);
            }
            if (t == null) {
                MalisisCore.log.error("Could not find a tranform with name {} in the JSON. Ignoring this animation.", (Object)anim.transform);
            }
            if (s == null || t == null) continue;
            t.reversed(anim.reversed);
            Animation<Shape> a = new Animation<Shape>(s, t);
            a.setRender(false, anim.persist);
            this.animations.put(entry.getKey(), a);
        }
        return this.animations;
    }

    public void load(ResourceLocation resourceLocation) {
        IResource res = Silenced.get(() -> Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation));
        if (res == null) {
            return;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(AnimationImporter.class, type -> this);
        gsonBuilder.registerTypeAdapter(Multimap.class, this::deserializeAnim);
        Gson gson = gsonBuilder.create();
        try (InputStreamReader reader = new InputStreamReader(res.func_110527_b(), "UTF-8");){
            JsonReader jsonReader = new JsonReader((Reader)reader);
            jsonReader.setLenient(true);
            gson.fromJson(jsonReader, AnimationImporter.class);
        }
        catch (Exception e) {
            MalisisCore.log.error("Failed to read {}", (Object)resourceLocation, (Object)e);
        }
    }

    public Transformation<?, Shape> getTransform(String name) {
        Transform t = this.transforms.get(name);
        if (t == null) {
            return null;
        }
        return t.getTransformation(name, this);
    }

    public Multimap<String, Anim> deserializeAnim(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ArrayListMultimap anims = ArrayListMultimap.create();
        JsonObject obj = json.getAsJsonObject();
        TypeToken<ArrayList<Anim>> token = new TypeToken<ArrayList<Anim>>(){};
        for (Map.Entry entry : obj.entrySet()) {
            anims.putAll(entry.getKey(), (Iterable)context.deserialize((JsonElement)entry.getValue(), token.getType()));
        }
        return anims;
    }

    private static class Anim {
        private String group;
        private String transform;
        private boolean persist = true;
        private boolean reversed = false;

        private Anim() {
        }
    }

    private static class Transform {
        private String name;
        private TransformType type;
        private Object from = null;
        private Object to = null;
        private float fromA = 0.0f;
        private float toA = 0.0f;
        private String axis = "Y";
        private double[] offset = new double[]{0.0, 0.0, 0.0};
        private double[] fromXYZ = new double[]{0.0, 0.0, 0.0};
        private double[] toXYZ = new double[]{0.0, 0.0, 0.0};
        private String[] transforms = new String[0];
        private int ticks = 0;
        private int delay = 0;
        private int loops = 1;

        private Transform() {
        }

        private Transformation<?, ?> build(AnimationImporter importer) {
            if (this.type == null) {
                MalisisCore.log.error("No type specified for {}. Ignoring transformation.", (Object)this.name);
                return null;
            }
            this.setFromTo();
            if (!this.checkValues()) {
                return null;
            }
            switch (this.type) {
                case TRANSLATION: {
                    return this.buildTranslation();
                }
                case ROTATION: {
                    return this.buildRotation();
                }
                case SCALE: {
                    return this.buildScale();
                }
                case CHAINED: {
                    return this.buildChained(importer);
                }
                case PARALLEL: {
                    return this.buildParallel(importer);
                }
                case COLOR: {
                    return this.buildColor();
                }
                case ALPHA: {
                    return this.buildAlpha();
                }
                case BRIGHTNESS: {
                    return this.buildBrightness();
                }
            }
            return null;
        }

        private void setFromTo() {
            if (this.from instanceof List) {
                List f = (List)this.from;
                this.fromXYZ = new double[]{(Double)f.get(0), (Double)f.get(1), (Double)f.get(2)};
            }
            if (this.to instanceof List) {
                List t = (List)this.to;
                this.toXYZ = new double[]{(Double)t.get(0), (Double)t.get(1), (Double)t.get(2)};
            }
            if (this.from instanceof Double) {
                this.fromA = (float)((Double)this.from).doubleValue();
            }
            if (this.to instanceof Double) {
                this.toA = (float)((Double)this.to).doubleValue();
            }
        }

        private boolean checkValues() {
            boolean sameValues = false;
            switch (this.type) {
                case TRANSLATION: 
                case SCALE: 
                case COLOR: {
                    sameValues = this.fromXYZ[0] == this.toXYZ[0] && this.fromXYZ[1] == this.toXYZ[1] && this.fromXYZ[2] == this.toXYZ[2];
                    break;
                }
                case ROTATION: 
                case ALPHA: 
                case BRIGHTNESS: {
                    sameValues = this.fromA == this.toA;
                    break;
                }
                case CHAINED: 
                case PARALLEL: {
                    if (ArrayUtils.isEmpty((Object[])this.transforms)) {
                        MalisisCore.log.error("No transforms specified for {}. Ignoring transformation.", (Object)this.name);
                        return false;
                    }
                    return true;
                }
            }
            if (sameValues) {
                MalisisCore.log.error("From and To are the same for {}. Ignoring transformation.", (Object)this.name);
            }
            return !sameValues;
        }

        public Transformation<?, Shape> getTransformation(String name, AnimationImporter importer) {
            this.name = name;
            return this.build(importer);
        }

        public Translation buildTranslation() {
            Translation t = new Translation((float)this.fromXYZ[0], (float)this.fromXYZ[1], (float)this.fromXYZ[2], (float)this.toXYZ[0], (float)this.toXYZ[1], (float)this.toXYZ[2]);
            t.forTicks(this.ticks, this.delay);
            t.loop(this.loops);
            return t;
        }

        public Rotation buildRotation() {
            Rotation r = new Rotation(this.fromA, this.toA);
            this.axis = this.axis.toLowerCase();
            r.aroundAxis(this.axis.equals("x") ? 1.0f : 0.0f, this.axis.equals("y") ? 1.0f : 0.0f, this.axis.equals("z") ? 1.0f : 0.0f);
            r.offset((float)this.offset[0], (float)this.offset[1], (float)this.offset[2]);
            r.forTicks(this.ticks, this.delay);
            r.loop(this.loops);
            return r;
        }

        public Scale buildScale() {
            Scale s = new Scale((float)this.fromXYZ[0], (float)this.fromXYZ[1], (float)this.fromXYZ[2], (float)this.toXYZ[0], (float)this.toXYZ[1], (float)this.toXYZ[2]);
            s.offset((float)this.offset[0], (float)this.offset[1], (float)this.offset[2]);
            s.forTicks(this.ticks, this.delay);
            s.loop(this.loops);
            return s;
        }

        public ChainedTransformation buildChained(AnimationImporter importer) {
            ArrayList transfos = Lists.newArrayList();
            for (String name : this.transforms) {
                Transformation<?, Shape> t = importer.getTransform(name);
                if (t != null) {
                    transfos.add(t);
                    continue;
                }
                MalisisCore.log.error("Could not find a tranform with name {} in the JSON. Can't add it to chained transformation.", (Object)name);
            }
            if (transfos.size() == 0) {
                MalisisCore.log.error("No valid transformation found for chained transformation {}. Ignoring transformation.", (Object)this.name);
                return null;
            }
            return new ChainedTransformation(transfos.toArray(new Transformation[0]));
        }

        public ParallelTransformation buildParallel(AnimationImporter importer) {
            ArrayList transfos = Lists.newArrayList();
            for (String name : this.transforms) {
                Transformation<?, Shape> t = importer.getTransform(name);
                if (t != null) {
                    transfos.add(t);
                    continue;
                }
                MalisisCore.log.error("Could not find a tranform with name {} in the JSON. Can't add it to parallel transformation.", (Object)name);
            }
            if (transfos.size() == 0) {
                MalisisCore.log.error("No valid transformation found for parallel transformation {}. Ignoring transformation.", (Object)this.name);
                return null;
            }
            return new ParallelTransformation(transfos.toArray(new Transformation[0]));
        }

        public ColorTransform buildColor() {
            if (this.from == null) {
                this.fromXYZ = new double[]{1.0, 1.0, 1.0};
            }
            if (this.to == null) {
                this.toXYZ = new double[]{1.0, 1.0, 1.0};
            }
            ColorTransform ct = new ColorTransform(this.getColor(this.fromXYZ), this.getColor(this.toXYZ));
            ct.forTicks(this.ticks, this.delay);
            ct.loop(this.loops);
            return ct;
        }

        public AlphaTransform buildAlpha() {
            AlphaTransform at = new AlphaTransform((int)(this.fromA * 255.0f), (int)(this.toA * 255.0f));
            at.forTicks(this.ticks, this.delay);
            at.loop(this.loops);
            return at;
        }

        public BrightnessTransform buildBrightness() {
            BrightnessTransform bt = new BrightnessTransform((int)(this.fromA * 14.0f), (int)(this.toA * 14.0f));
            bt.forTicks(this.ticks, this.delay);
            bt.loop(this.loops);
            return bt;
        }

        private int getColor(double[] xyz) {
            int r = (int)(MathHelper.func_151237_a((double)xyz[0], (double)0.0, (double)1.0) * 255.0);
            int g = (int)(MathHelper.func_151237_a((double)xyz[0], (double)0.0, (double)1.0) * 255.0);
            int b = (int)(MathHelper.func_151237_a((double)xyz[0], (double)0.0, (double)1.0) * 255.0);
            return r << 16 | g << 8 | b;
        }
    }

    private static enum TransformType {
        TRANSLATION,
        ROTATION,
        SCALE,
        CHAINED,
        PARALLEL,
        COLOR,
        ALPHA,
        BRIGHTNESS;

    }
}

