/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item.machine;

import javax.annotation.Nonnull;
import mekanism.client.model.ModelFluidTank;
import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderFluidTankItem {
    private static ModelFluidTank fluidTank = new ModelFluidTank();
    private static FluidRenderMap<MekanismRenderer.DisplayInteger[]> cachedCenterFluids = new FluidRenderMap();
    private static int stages = 1400;

    public static void renderStack(@Nonnull ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        ItemBlockMachine itemMachine = (ItemBlockMachine)stack.func_77973_b();
        float fluidScale = (float)(itemMachine.getFluidStack(stack) != null ? itemMachine.getFluidStack((Object[])new Object[]{stack}).amount : 0) / (float)itemMachine.getCapacity(stack);
        FluidTankTier tier = FluidTankTier.values()[itemMachine.getBaseTier(stack).ordinal()];
        FluidStack fluid = itemMachine.getFluidStack(stack);
        GlStateManager.func_179094_E();
        if (fluid != null && fluidScale > 0.0f) {
            GlStateManager.func_179094_E();
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)2896);
            MekanismRenderer.blendOn();
            MekanismRenderer.bindTexture(MekanismRenderer.getBlocksTexture());
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            MekanismRenderer.glowOn(fluid.getFluid().getLuminosity(fluid));
            MekanismRenderer.colorFluid(fluid);
            MekanismRenderer.DisplayInteger[] displayList = RenderFluidTankItem.getListAndRender(fluid);
            if (tier == FluidTankTier.CREATIVE) {
                fluidScale = 1.0f;
            }
            if (fluid.getFluid().isGaseous(fluid)) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, fluidScale + MekanismRenderer.GAS_RENDER_BASE));
                displayList[stages - 1].render();
            } else {
                displayList[Math.min(stages - 1, (int)(fluidScale * ((float)stages - 1.0f)))].render();
            }
            MekanismRenderer.resetColor();
            MekanismRenderer.glowOff();
            GL11.glPopAttrib();
            MekanismRenderer.blendOff();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)-0.9f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.9f, (float)0.8f, (float)0.9f);
        MekanismRenderer.bindTexture(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "FluidTank.png"));
        fluidTank.render(0.073f, tier);
        GlStateManager.func_179121_F();
    }

    private static MekanismRenderer.DisplayInteger[] getListAndRender(FluidStack fluid) {
        if (cachedCenterFluids.containsKey(fluid)) {
            return (MekanismRenderer.DisplayInteger[])cachedCenterFluids.get(fluid);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[stages];
        cachedCenterFluids.put(fluid, displays);
        for (int i = 0; i < stages; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            if (fluid.getFluid().getStill(fluid) != null) {
                toReturn.minX = 0.135;
                toReturn.minY = 0.0725;
                toReturn.minZ = 0.135;
                toReturn.maxX = 0.865;
                toReturn.maxY = 0.0625 + (double)((float)i / (float)stages) * 0.875 - 0.01;
                toReturn.maxZ = 0.865;
                MekanismRenderer.renderObject(toReturn);
            }
            GL11.glEndList();
        }
        return displays;
    }
}

