/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.classic.item.IFuelableItem;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IFuelMachine;
import ic2.core.Direction;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorFuelMachine;
import ic2.core.block.base.util.comparator.comparators.ComparatorHeat;
import ic2.core.block.base.util.info.FuelMachineInfo;
import ic2.core.block.base.util.info.HeatInfo;
import ic2.core.block.base.util.info.misc.IHeatProvider;
import ic2.core.block.generator.container.ContainerFuelBoiler;
import ic2.core.block.generator.tile.TileEntityBasicSteamTurbine;
import ic2.core.fluid.IC2Fluid;
import ic2.core.fluid.IC2Tank;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.FluidFilter;
import ic2.core.inventory.filters.InvertedFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ITankListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityFuelBoiler
extends TileEntityMachine
implements ITickable,
IFluidHandler,
IFluidTank,
IHasGui,
IFuelMachine,
ITankListener,
IHeatProvider {
    @NetworkField(index=3)
    public IC2Tank steamTank = new IC2Tank(128000);
    @NetworkField(index=4)
    public float water;
    TileEntityBasicSteamTurbine[] turbines = new TileEntityBasicSteamTurbine[4];
    Set<Integer> iterator = new LinkedHashSet<Integer>();
    @NetworkField(index=5)
    public int maxFuel;
    @NetworkField(index=6)
    public int fuel;
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit16)
    public int heat;

    public TileEntityFuelBoiler() {
        super(2);
        this.addGuiFields("maxFuel", "fuel", "heat", "water", "steamTank");
        this.steamTank.addListener(this);
        this.addInfos(new FuelMachineInfo(this), new HeatInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0, 1);
        handler.registerDefaultSlotsForSide(RotationList.ALL, 0, 1);
        handler.registerInputFilter(CommonFilters.fuelableItem, 0);
        handler.registerOutputFilter(new InvertedFilter(CommonFilters.fuelableItem), 0);
        FluidFilter filter = new FluidFilter(FluidRegistry.WATER);
        handler.registerInputFilter(filter, 1);
        handler.registerOutputFilter(new InvertedFilter(filter), 1);
        handler.registerSlotType(SlotType.Fuel, 0);
        handler.registerSlotType(SlotType.FluidFuel, 1);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorHeat(this));
        manager.addComparatorMode(new ComparatorFuelMachine(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.water = nbt.func_74760_g("Water");
        this.steamTank.readFromNBT(nbt.func_74775_l("steam"));
        this.fuel = nbt.func_74762_e("Fuel");
        this.maxFuel = nbt.func_74762_e("MaxFuel");
        this.heat = nbt.func_74762_e("Heat");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("Water", this.water);
        this.steamTank.writeToNBT(this.getTag(nbt, "steam"));
        nbt.func_74768_a("Fuel", this.fuel);
        nbt.func_74768_a("MaxFuel", this.maxFuel);
        nbt.func_74768_a("Heat", this.heat);
        return nbt;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerFuelBoiler(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.boiler;
    }

    @Override
    public float getFuel() {
        return this.fuel;
    }

    @Override
    public float getMaxFuel() {
        return this.maxFuel;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public int getMaxHeat() {
        return 24000;
    }

    @Override
    public void onTankChanged(IFluidTank tank) {
        this.getNetwork().updateTileGuiField(this, "steamTank");
    }

    public void func_73660_a() {
        IFuelableItem item;
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.updateSteam();
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L && this.water <= 15000.0f) {
            if (StackUtil.isStackEqual((ItemStack)this.inventory.get(1), Ic2Items.waterCell)) {
                this.water += 1000.0f;
                ((ItemStack)this.inventory.get(1)).func_190918_g(1);
                this.getNetwork().updateTileGuiField(this, "water");
                return;
            }
            FluidHelper.drainContainers(this, this, 1);
        }
        if (this.fuel <= 0 && (item = this.getFuelItem()) != null) {
            int newFuel = item.getFuel((ItemStack)this.inventory.get(0), 10000, true);
            this.fuel += newFuel;
            this.maxFuel = newFuel;
            this.getNetwork().updateTileGuiField(this, "fuel");
            this.getNetwork().updateTileGuiField(this, "maxFuel");
        }
        if (this.fuel <= 0 && this.heat > 0) {
            --this.heat;
            this.setActive(false);
            this.getNetwork().updateTileGuiField(this, "heat");
        } else if (this.fuel > 0) {
            if (this.heat < 24000) {
                this.fuel -= Math.min(30, this.fuel);
                ++this.heat;
                this.getNetwork().updateTileGuiField(this, "heat");
            } else {
                this.fuel -= Math.min(2, this.fuel);
            }
            this.getNetwork().updateTileGuiField(this, "fuel");
            this.setActive(true);
        } else {
            this.setActive(this.fuel > 0);
        }
        int realHeat = this.heat / 30;
        if (realHeat >= 100) {
            float steam = (float)realHeat * 0.32f;
            float waterNeeded = steam / 160.0f;
            if (this.water < waterNeeded) {
                waterNeeded = this.water;
                steam = waterNeeded * 160.0f;
            }
            if (steam >= 1.0f) {
                this.steamTank.fill(IC2Fluid.getFluidStack("steam", (int)steam), true);
                this.water -= waterNeeded;
                this.getNetwork().updateTileGuiField(this, "water");
            }
        }
        int fluid = this.steamTank.getFluidAmount();
        int count = this.iterator.size();
        if (fluid > 0 && count > 0) {
            int amount = fluid / count;
            for (int side : this.iterator) {
                this.steamTank.drain(this.turbines[side].tank.fill(this.steamTank.drain(amount, false), true), true);
            }
        }
        this.updateComparators();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.updateSteam();
        }
    }

    public void updateSteam() {
        for (EnumFacing facing : RotationList.HORIZONTAL) {
            int index;
            TileEntity tile = Direction.fromEnumFacing(facing).applyToTileEntity(this);
            if (tile instanceof TileEntityBasicSteamTurbine && !tile.func_145837_r()) {
                index = facing.func_176736_b();
                this.turbines[index] = (TileEntityBasicSteamTurbine)tile;
                this.iterator.add(index);
                continue;
            }
            index = facing.func_176736_b();
            this.iterator.remove(index);
            this.turbines[index] = null;
        }
    }

    public IFuelableItem getFuelItem() {
        ItemStack stack = (ItemStack)this.inventory.get(0);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IFuelableItem)) {
            return null;
        }
        IFuelableItem item = (IFuelableItem)stack.func_77973_b();
        if (!item.hasFuel(stack)) {
            return null;
        }
        if (item.getFuel(stack, 1, false) > 0) {
            return item;
        }
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.steamTank.getTankProperties()[0], new FluidTankProperties(new FluidStack(FluidRegistry.WATER, (int)this.water), 16000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.getFluid() == FluidRegistry.WATER) {
            int needed = (int)(16000.0f - this.water);
            if (resource.amount < needed) {
                needed = resource.amount;
            }
            if (doFill) {
                this.water += (float)needed;
                this.getNetwork().updateTileGuiField(this, "water");
            }
            return needed;
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.steamTank.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.steamTank.drain(maxDrain, doDrain);
    }

    @Nullable
    public FluidStack getFluid() {
        return new FluidStack(FluidRegistry.WATER, (int)this.water);
    }

    public int getFluidAmount() {
        return (int)this.water;
    }

    public int getCapacity() {
        return 16000;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo(this.getFluid(), this.getCapacity());
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, facing);
    }
}

