/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.network.packets;

import io.netty.buffer.ByteBuf;
import net.machinemuse.numina.item.IModeChangingItem;
import net.machinemuse.numina.module.IModuleManager;
import net.machinemuse.numina.network.MuseByteBufferUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MusePacketModeChangeRequest
implements IMessage {
    protected EntityPlayer player;
    protected String mode;
    protected int slot;

    public MusePacketModeChangeRequest(EntityPlayer player, String mode, int slot) {
        this.player = player;
        this.mode = mode;
        this.slot = slot;
    }

    public MusePacketModeChangeRequest() {
    }

    public void fromBytes(ByteBuf buf) {
        this.mode = MuseByteBufferUtils.readUTF8String((ByteBuf)buf);
        this.slot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        MuseByteBufferUtils.writeUTF8String((ByteBuf)buf, (String)this.mode);
        buf.writeInt(this.slot);
    }

    public static class Handler
    implements IMessageHandler<MusePacketModeChangeRequest, IMessage> {
        public IMessage onMessage(MusePacketModeChangeRequest message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                player.func_71121_q().func_152344_a(() -> {
                    IModeChangingItem modeChangingItem;
                    IModuleManager moduleManager;
                    ItemStack stack;
                    int slot = message.slot;
                    String mode = message.mode;
                    if (slot > -1 && slot < 9 && !(stack = (ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b() && stack.func_77973_b() instanceof IModeChangingItem && (moduleManager = (modeChangingItem = (IModeChangingItem)stack.func_77973_b()).getModuleManager()).isValidForItem(stack, mode)) {
                        modeChangingItem.setActiveMode(stack, mode);
                    }
                });
            }
            return null;
        }
    }
}

