/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.shapes.IFormula;
import mcjty.rftools.shapes.Shape;
import mcjty.rftools.shapes.ShapeDataManagerServer;
import mcjty.rftools.shapes.ShapeID;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRequestShapeData
implements IMessage {
    private ItemStack card;
    private ShapeID id;

    public void fromBytes(ByteBuf buf) {
        this.card = NetworkTools.readItemStack((ByteBuf)buf);
        this.id = new ShapeID(buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)this.card);
        this.id.toBytes(buf);
    }

    public PacketRequestShapeData() {
    }

    public PacketRequestShapeData(ItemStack card, ShapeID id) {
        this.card = card;
        this.id = id;
    }

    public static class Handler
    implements IMessageHandler<PacketRequestShapeData, IMessage> {
        public IMessage onMessage(PacketRequestShapeData message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketRequestShapeData message, MessageContext ctx) {
            Shape shape = ShapeCardItem.getShape(message.card);
            boolean solid = ShapeCardItem.isSolid(message.card);
            BlockPos dimension = ShapeCardItem.getDimension(message.card);
            BlockPos clamped = new BlockPos(Math.min(dimension.func_177958_n(), 512), Math.min(dimension.func_177956_o(), 256), Math.min(dimension.func_177952_p(), 512));
            int dy = clamped.func_177956_o();
            ItemStack card = message.card.func_77946_l();
            IFormula formula = shape.getFormulaFactory().get();
            formula = formula.correctFormula(solid);
            formula.setup(new BlockPos(0, 0, 0), clamped, new BlockPos(0, 0, 0), message.card.func_77978_p());
            for (int y = 0; y < dy; ++y) {
                ShapeDataManagerServer.pushWork(message.id, card, y, formula, ctx.getServerHandler().field_147369_b);
            }
        }
    }
}

