/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.inventory;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.tile.ITile;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemSorption;
import nc.util.NCInventoryHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public interface ITileInventory
extends ITile,
ISidedInventory {
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacks();

    default public boolean func_145818_k_() {
        return false;
    }

    default public int func_70302_i_() {
        return this.getInventoryStacks().size();
    }

    default public boolean func_191420_l() {
        for (ItemStack itemstack : this.getInventoryStacks()) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.getInventoryStacks().get(slot);
    }

    default public ItemStack func_70298_a(int slot, int count) {
        return ItemStackHelper.func_188382_a(this.getInventoryStacks(), (int)slot, (int)count);
    }

    default public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.getInventoryStacks(), (int)slot);
    }

    default public void func_70299_a(int slot, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = (ItemStack)this.getInventoryStacks().get(slot);
        boolean bl = flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && nc.util.ItemStackHelper.areItemStackTagsEqual(stack, itemstack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.getInventoryStacks().set(slot, (Object)stack);
        if (!flag) {
            this.func_70296_d();
        }
    }

    default public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    default public int func_70297_j_() {
        return 64;
    }

    default public void func_174888_l() {
        this.getInventoryStacks().clear();
    }

    default public boolean func_70300_a(EntityPlayer player) {
        return this.getTileWorld().func_175625_s(this.getTilePos()) != this ? false : player.func_70092_e((double)this.getTilePos().func_177958_n() + 0.5, (double)this.getTilePos().func_177956_o() + 0.5, (double)this.getTilePos().func_177952_p() + 0.5) <= 64.0;
    }

    default public void func_174889_b(EntityPlayer player) {
    }

    default public void func_174886_c(EntityPlayer player) {
    }

    default public int func_174887_a_(int id) {
        return 0;
    }

    default public void func_174885_b(int id, int value) {
    }

    default public int func_174890_g() {
        return 0;
    }

    default public int[] func_180463_a(EnumFacing side) {
        return this.getInventoryConnection(side).getSlotsForFace();
    }

    default public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.getItemSorption(side, slot).canReceive();
    }

    default public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return this.getItemSorption(side, slot).canExtract();
    }

    @Nonnull
    public InventoryConnection[] getInventoryConnections();

    public void setInventoryConnections(@Nonnull InventoryConnection[] var1);

    @Nonnull
    default public InventoryConnection getInventoryConnection(@Nonnull EnumFacing side) {
        return this.getInventoryConnections()[side.func_176745_a()];
    }

    default public void setInventoryConnection(@Nonnull EnumFacing side, @Nonnull InventoryConnection connection) {
        this.getInventoryConnections()[side.func_176745_a()] = connection.copy();
    }

    @Nonnull
    default public ItemSorption getItemSorption(@Nonnull EnumFacing side, int slotNumber) {
        return this.getInventoryConnections()[side.func_176745_a()].getItemSorption(slotNumber);
    }

    default public void setItemSorption(@Nonnull EnumFacing side, int slotNumber, @Nonnull ItemSorption sorption) {
        this.getInventoryConnections()[side.func_176745_a()].setItemSorption(slotNumber, sorption);
    }

    default public void toggleItemSorption(@Nonnull EnumFacing side, int slotNumber) {
        if (!this.hasConfigurableInventoryConnections()) {
            return;
        }
        this.getInventoryConnection(side).toggleItemSorption(slotNumber);
        this.markAndRefresh();
    }

    default public boolean canConnectInventory(@Nonnull EnumFacing side) {
        return this.getInventoryConnection(side).canConnect();
    }

    public static InventoryConnection[] inventoryConnectionAll(@Nonnull List<ItemSorption> sorptionList) {
        InventoryConnection[] array = new InventoryConnection[6];
        for (int i = 0; i < 6; ++i) {
            array[i] = new InventoryConnection(sorptionList);
        }
        return array;
    }

    public static InventoryConnection[] inventoryConnectionAll(ItemSorption sorption) {
        return ITileInventory.inventoryConnectionAll(Lists.newArrayList((Object[])new ItemSorption[]{sorption}));
    }

    default public boolean hasConfigurableInventoryConnections() {
        return false;
    }

    default public void pushStacks() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.pushStacksToSide(side);
        }
    }

    default public void pushStacksToSide(@Nonnull EnumFacing side) {
        IItemHandler adjInv;
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        IItemHandler iItemHandler = adjInv = tile == null ? null : (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjInv == null || adjInv.getSlots() < 1) {
            return;
        }
        for (int i = 0; i < this.getInventoryStacks().size(); ++i) {
            ItemStack initialStack;
            ItemStack inserted;
            if (((ItemStack)this.getInventoryStacks().get(i)).func_190926_b() || (inserted = NCInventoryHelper.addStackToInventory(adjInv, initialStack = ((ItemStack)this.getInventoryStacks().get(i)).func_77946_l())).func_190916_E() >= initialStack.func_190916_E()) continue;
            ((ItemStack)this.getInventoryStacks().get(i)).func_190918_g(initialStack.func_190916_E() - inserted.func_190916_E());
            if (((ItemStack)this.getInventoryStacks().get(i)).func_190916_E() > 0) continue;
            this.getInventoryStacks().set(i, (Object)ItemStack.field_190927_a);
        }
    }

    default public NBTTagCompound writeInventory(NBTTagCompound nbt) {
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.getInventoryStacks());
        return nbt;
    }

    default public void readInventory(NBTTagCompound nbt) {
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.getInventoryStacks());
    }

    default public NBTTagCompound writeInventoryConnections(NBTTagCompound nbt) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.getInventoryConnection(side).writeToNBT(nbt, side);
        }
        return nbt;
    }

    default public void readInventoryConnections(NBTTagCompound nbt) {
        if (!this.hasConfigurableInventoryConnections()) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.getInventoryConnection(side).readFromNBT(nbt, side);
        }
    }

    default public boolean hasInventorySideCapability(@Nullable EnumFacing side) {
        return side == null || this.getInventoryConnection(side).canConnect();
    }
}

