/*
 * Decompiled with CFR 0.152.
 */
package openmods.events.network;

import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventManager;
import openmods.utils.WorldUtils;

public abstract class BlockEventPacket
extends NetworkEvent {
    public int dimension;
    public BlockPos blockPos;

    public BlockEventPacket() {
    }

    public BlockEventPacket(int dimension, BlockPos blockPos) {
        this.dimension = dimension;
        this.blockPos = blockPos;
    }

    public BlockEventPacket(TileEntity tile) {
        this(tile.func_145831_w().field_73011_w.getDimension(), tile.func_174877_v());
    }

    @Override
    protected void readFromStream(PacketBuffer input) {
        this.dimension = input.readInt();
        this.blockPos = input.func_179259_c();
    }

    @Override
    protected void writeToStream(PacketBuffer output) {
        output.writeInt(this.dimension);
        output.func_179255_a(this.blockPos);
    }

    @Override
    protected void appendLogInfo(List<String> info) {
        info.add(String.format("%d -> %s", this.dimension, this.blockPos));
    }

    public void sendToWatchers() {
        NetworkEventManager.dispatcher().senders.block.sendMessage((Object)this, this.getDimCoords());
    }

    public NetworkRegistry.TargetPoint getDimCoords() {
        return new NetworkRegistry.TargetPoint(this.dimension, (double)this.blockPos.func_177958_n(), (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p(), 0.0);
    }

    public World getWorld() {
        return WorldUtils.getWorld(this.side, this.dimension);
    }
}

