/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.UnsignedBytes;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class PacketChunker {
    private byte packetId = 0;
    private final Map<Byte, byte[][]> chunks = Maps.newHashMap();
    public static final int MAX_CHUNK_SIZE = 32667;
    public static final int PACKET_SIZE_S3F = 0x1FFFF0;
    public static final int PACKET_SIZE_C17 = Short.MAX_VALUE;

    public byte[][] splitIntoChunks(byte[] data, int maxChunkSize) {
        int numChunks = (data.length + maxChunkSize - 1) / maxChunkSize;
        Preconditions.checkArgument((numChunks < 256 ? 1 : 0) != 0, (String)"%s chunks? Way too much data, man.", (int)numChunks);
        byte[][] result = new byte[numChunks][];
        int chunkOffset = 0;
        for (int chunkIndex = 0; chunkIndex < numChunks; ++chunkIndex) {
            int chunkSize = Math.min(data.length - chunkOffset, maxChunkSize);
            ByteArrayDataOutput buf = ByteStreams.newDataOutput((int)maxChunkSize);
            buf.writeByte(numChunks);
            if (numChunks > 1) {
                buf.writeByte(chunkIndex);
                buf.writeByte((int)this.packetId);
            }
            buf.write(data, chunkOffset, chunkSize);
            result[chunkIndex] = buf.toByteArray();
            chunkOffset += chunkSize;
        }
        this.packetId = (byte)(this.packetId + 1);
        return result;
    }

    public byte[] consumeChunk(byte[] payload) throws IOException {
        return this.consumeChunk((DataInput)ByteStreams.newDataInput((byte[])payload), payload.length);
    }

    public byte[] consumeChunk(InputStream stream, int payloadLength) throws IOException {
        DataInputStream data = new DataInputStream(stream);
        return this.consumeChunk(data, payloadLength);
    }

    public synchronized byte[] consumeChunk(DataInput input, int payloadLength) throws IOException {
        int numChunks = UnsignedBytes.toInt((byte)input.readByte());
        if (numChunks == 1) {
            byte[] payload = new byte[payloadLength - 1];
            input.readFully(payload);
            return payload;
        }
        int chunkIndex = UnsignedBytes.toInt((byte)input.readByte());
        byte incomingPacketId = input.readByte();
        Object alreadyReceived = this.chunks.get(incomingPacketId);
        if (alreadyReceived == null) {
            alreadyReceived = new byte[numChunks][];
            this.chunks.put(incomingPacketId, (byte[][])alreadyReceived);
        }
        byte[] chunkBytes = new byte[payloadLength - 3];
        input.readFully(chunkBytes);
        alreadyReceived[chunkIndex] = chunkBytes;
        for (byte[] s : alreadyReceived) {
            if (s != null) continue;
            return null;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        for (int i = 0; i < numChunks; i = (int)((short)(i + 1))) {
            byte[] chunkPart = alreadyReceived[i];
            byteArrayDataOutput.write(chunkPart);
        }
        this.chunks.remove(incomingPacketId);
        return byteArrayDataOutput.toByteArray();
    }
}

