/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.items;

import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.item.inv.inventories.CropAnalyzerInventory;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnalyzerComp
extends GuiComponent {
    CropAnalyzerInventory crop;

    public AnalyzerComp(CropAnalyzerInventory cont) {
        super(Ic2GuiComp.nullBox);
        this.crop = cont;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.FrontgroundDraw);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        int level = this.crop.getScannedLevel();
        if (level <= -1) {
            return;
        }
        if (level == 0) {
            gui.drawString(Ic2GuiLang.cropUnknown, 8, 37, 0xFFFFFF);
            return;
        }
        gui.drawString(this.crop.getSeedName(), 8, 37, 0xFFFFFF);
        if (level >= 2) {
            gui.drawString(Ic2GuiLang.cropTier.getLocalizedFormatted(this.crop.getSeedTier()), 8, 50, 0xFFFFFF);
            gui.drawString(Ic2GuiLang.cropOwner, 8, 73, 0xFFFFFF);
            gui.drawString(this.crop.getSeedDiscovered(), 8, 86, 0xFFFFFF);
        }
        if (level >= 3) {
            gui.drawString(this.crop.getSeedDesc(0), 8, 109, 0xFFFFFF);
            gui.drawString(this.crop.getSeedDesc(1), 8, 122, 0xFFFFFF);
        }
        if (level >= 4) {
            gui.drawString(Ic2GuiLang.cropGrowth, 118, 37, 11403055);
            gui.drawString("" + this.crop.getSeedGrowth(), 118, 50, 11403055);
            gui.drawString(Ic2GuiLang.cropGain, 118, 73, 15649024);
            gui.drawString("" + this.crop.getSeedGain(), 118, 86, 15649024);
            gui.drawString(Ic2GuiLang.cropResistance, 118, 109, 52945);
            gui.drawString("" + this.crop.getSeedResistence(), 118, 122, 52945);
        }
    }
}

