/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base.trades.builder;

import ic2.api.classic.trading.ITradeInventory;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.personal.base.misc.IPersonalInventory;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class TradeInventory
implements ITradeInventory {
    IPersonalInventory inv;

    public TradeInventory(IPersonalInventory pers) {
        this.inv = pers;
    }

    @Override
    public int getSlotCount() {
        return 8;
    }

    @Override
    public ItemStack getItemStack(int slot) {
        return this.inv.getStackInSlot(slot);
    }

    @Override
    public int getItemCount(IRecipeInput type) {
        int count = 0;
        for (int i = 0; i < 8; ++i) {
            ItemStack stack = this.inv.getStackInSlot(i);
            if (stack.func_190926_b() || !type.matches(stack)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    @Override
    public void addItem(ItemStack stack) {
        IItemTransporter trans = TransporterManager.manager.getTransporter(this.inv, true);
        if (trans == null) {
            return;
        }
        trans.addItem(stack, null, true);
    }

    @Override
    public List<ItemStack> removeItems(IRecipeInput type, int amount) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int used = 0;
        for (int i = 0; i < 8; ++i) {
            ItemStack stack = this.inv.getStackInSlot(i);
            if (stack == null || !type.matches(stack)) continue;
            ItemStack copy = stack.func_77979_a(amount - used);
            this.combine(list, copy);
            if ((used += copy.func_190916_E()) >= amount) break;
        }
        return list;
    }

    public void combine(List<ItemStack> list, ItemStack toAdd) {
        for (int i = 0; i < list.size(); ++i) {
            int adding;
            ItemStack got = list.get(i);
            if (!StackUtil.isStackEqual(got, toAdd, false, false) || (adding = Math.min(got.func_77976_d() - got.func_190916_E(), toAdd.func_190916_E())) <= 0) continue;
            toAdd.func_190918_g(adding);
            got.func_190917_f(adding);
            if (!toAdd.func_190926_b()) continue;
            return;
        }
        if (!toAdd.func_190926_b()) {
            list.add(toAdd);
        }
    }
}

