/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.inv.inventories;

import ic2.core.inventory.base.IC2ItemInventory;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.item.inv.container.ContainerStackLimiter;
import java.util.Arrays;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class StackLimiterInv
extends IC2ItemInventory {
    public int[] maxStacksize;

    public StackLimiterInv(EntityPlayer player, IHandHeldInventory inv, ItemStack item) {
        super(player, inv, item);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerStackLimiter(this, this.getID(), player.field_71071_by);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !player.field_70128_L;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public int getInventorySize() {
        return 12;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.maxStacksize = new int[12];
        Arrays.fill(this.maxStacksize, 64);
        NBTTagList list = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int index = data.func_74762_e("Index");
            int amount = data.func_74762_e("Amount");
            ItemStack stack = new ItemStack(data);
            if (index < 0 || index >= 12) continue;
            this.inventory.set(index, (Object)stack);
            this.maxStacksize[index] = amount;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 12; ++i) {
            NBTTagCompound data = ((ItemStack)this.inventory.get(i)).func_77955_b(new NBTTagCompound());
            data.func_74768_a("Amount", this.maxStacksize[i]);
            data.func_74768_a("Index", i);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Data", (NBTBase)list);
    }
}

