/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import nc.entity.EntityFeralGhoul;
import nc.init.NCArmor;
import nc.init.NCBlocks;
import nc.init.NCItems;
import nc.init.NCTools;
import nc.render.BlockHighlightHandler;
import nc.render.entity.RenderFeralGhoul;
import nc.render.tile.RenderFusionCore;
import nc.tile.generator.TileFusionCore;
import nc.util.NCUtil;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class RenderHandler {
    public static void init() {
        NCBlocks.registerRenders();
        NCItems.registerRenders();
        NCTools.registerRenders();
        NCArmor.registerRenders();
        ClientRegistry.bindTileEntitySpecialRenderer(TileFusionCore.class, (TileEntitySpecialRenderer)new RenderFusionCore());
        RenderHandler.registerEntityRender(EntityFeralGhoul.class, RenderFeralGhoul.class);
        MinecraftForge.EVENT_BUS.register((Object)new BlockHighlightHandler());
    }

    private static <E extends Entity, R extends Render<E>> void registerEntityRender(Class<E> entityClass, final Class<R> renderClass) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, (IRenderFactory)new IRenderFactory<E>(){

            public R createRenderFor(RenderManager manager) {
                Render render = null;
                try {
                    render = (Render)NCUtil.newInstance(renderClass, manager);
                }
                catch (Exception e) {
                    NCUtil.getLogger().catching((Throwable)e);
                }
                return render;
            }
        });
    }
}

