/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.vanishingoption;

import java.util.HashMap;
import java.util.Map;
import net.malisis.blocks.block.VanishingBlock;
import net.malisis.blocks.network.VanishingDiamondFrameMessage;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VanishingOptions
implements IInventoryProvider.IDirectInventoryProvider {
    private MalisisInventory inventory;
    private ItemStack itemStack;
    private int duration = 8;
    protected Map<EnumFacing, DirectionState> directionStates = new HashMap<EnumFacing, DirectionState>();

    public VanishingOptions() {
        this.inventory = new MalisisInventory((IInventoryProvider)this, 1);
        this.inventory.setInventoryStackLimit(1);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.directionStates.put(dir, new DirectionState(dir));
        }
    }

    public VanishingOptions(ItemStack itemStack) {
        this();
        this.itemStack = itemStack;
        this.inventory.setInventoryStackLimit(64);
    }

    public MalisisInventory getInventory() {
        return this.inventory;
    }

    @SideOnly(value=Side.CLIENT)
    public MalisisGui getGui(MalisisInventoryContainer container) {
        return null;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public MalisisSlot getSlot() {
        return this.inventory.getSlot(0);
    }

    public void set(EnumFacing dir, VanishingDiamondFrameMessage.DataType type, int time, boolean enabled) {
        DirectionState ds = this.getDirectionState(dir);
        switch (type) {
            case PROPAGATION: {
                ds.shouldPropagate = enabled;
                break;
            }
            case DELAY: {
                ds.delay = time;
                break;
            }
            case INVERSED: {
                ds.inversed = enabled;
                break;
            }
            case DURATION: {
                this.setDuration(time);
            }
        }
    }

    public DirectionState getDirectionState(EnumFacing dir) {
        return this.directionStates.get(dir);
    }

    public void setPowerState(World world, BlockPos pos, int timer, boolean powered) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.directionStates.get(dir).resetPropagationState();
            this.directionStates.get(dir).propagateState(world, pos, timer, powered);
        }
    }

    public void propagateState(World world, BlockPos pos, int timer, boolean powered) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.directionStates.get(dir).propagateState(world, pos, timer, powered);
        }
    }

    public void copy(VanishingOptions options) {
        this.duration = options.duration;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.getDirectionState(dir).copy(options.getDirectionState(dir));
        }
    }

    public void save() {
        if (this.itemStack == null) {
            return;
        }
        if (this.itemStack.func_77978_p() == null) {
            this.itemStack.func_77982_d(new NBTTagCompound());
        }
        this.writeToNBT(this.itemStack.func_77978_p());
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.inventory.readFromNBT(nbt);
        this.duration = nbt.func_74764_b("Duration") ? nbt.func_74762_e("Duration") : 8;
        NBTTagList dirList = nbt.func_150295_c("Directions", 10);
        for (int i = 0; i < dirList.func_74745_c(); ++i) {
            NBTTagCompound tag = dirList.func_150305_b(i);
            EnumFacing dir = EnumFacing.func_82600_a((int)tag.func_74762_e("direction"));
            this.directionStates.get(dir).readFromNBT(tag);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.inventory.writeToNBT(nbt);
        nbt.func_74768_a("Duration", this.getDuration());
        NBTTagList dirList = new NBTTagList();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            dirList.func_74742_a((NBTBase)this.directionStates.get(dir).writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("Directions", (NBTBase)dirList);
    }

    public static class DirectionState {
        public EnumFacing direction;
        public boolean shouldPropagate;
        public int delay;
        public boolean inversed;
        public boolean propagated;

        public DirectionState(EnumFacing direction, boolean shouldPropagate, int delay, boolean inversed) {
            this.direction = direction;
            this.update(shouldPropagate, delay, inversed);
        }

        public DirectionState(EnumFacing direction) {
            this(direction, false, 0, false);
        }

        public void update(boolean shouldPropagate, int delay, boolean inversed) {
            this.shouldPropagate = shouldPropagate;
            this.delay = delay;
            this.inversed = inversed;
        }

        public void resetPropagationState() {
            this.propagated = false;
        }

        public boolean propagateState(World world, BlockPos pos, int timer, boolean powered) {
            if (!this.shouldPropagate || this.propagated || timer < this.delay) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos.func_177972_a(this.direction));
            if (state.func_177230_c() instanceof VanishingBlock) {
                ((VanishingBlock)state.func_177230_c()).setPowerState(world, pos.func_177972_a(this.direction), this.inversed ? !powered : powered);
            }
            this.propagated = true;
            return false;
        }

        public void copy(DirectionState state) {
            this.shouldPropagate = state.shouldPropagate;
            this.delay = state.delay;
            this.inversed = state.inversed;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.update(nbt.func_74767_n("shouldPropagate"), nbt.func_74762_e("delay"), nbt.func_74767_n("inversed"));
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("direction", this.direction.ordinal());
            nbt.func_74757_a("shouldPropagate", this.shouldPropagate);
            nbt.func_74768_a("delay", this.delay);
            nbt.func_74757_a("inversed", this.inversed);
            return nbt;
        }
    }
}

