/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializer;
import cubex2.cs4.api.BlockTint;
import cubex2.cs4.api.Content;
import cubex2.cs4.api.ContentRegistry;
import cubex2.cs4.api.EntitySelector;
import cubex2.cs4.api.ItemModuleSupplier;
import cubex2.cs4.api.LoaderPredicate;
import cubex2.cs4.api.TileEntityModuleSupplier;
import cubex2.cs4.data.DeserializationRegistry;
import cubex2.cs4.data.LoaderPredicateRegistry;
import cubex2.cs4.plugins.vanilla.BlockTintRegistry;
import cubex2.cs4.plugins.vanilla.ColorRegistry;
import cubex2.cs4.plugins.vanilla.EntitySelectorRegistry;
import cubex2.cs4.plugins.vanilla.ItemModuleRegistry;
import cubex2.cs4.plugins.vanilla.TileEntityModuleRegistry;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

public class ContentRegistryImpl
implements ContentRegistry,
DeserializationRegistry,
LoaderPredicateRegistry,
TileEntityModuleRegistry,
BlockTintRegistry,
ColorRegistry,
ItemModuleRegistry,
EntitySelectorRegistry {
    private final Map<String, Class<? extends Content>> types = Maps.newHashMap();
    private final Map<String, Side> typeSides = Maps.newHashMap();
    private final Map<String, LoaderPredicate> predicates = Maps.newHashMap();
    private final List<Pair<Type, JsonDeserializer<?>>> deserializers = Lists.newArrayList();
    private final Map<String, Class<? extends TileEntityModuleSupplier>> tileEntityModules = Maps.newHashMap();
    private final Map<String, Class<? extends ItemModuleSupplier>> itemModules = Maps.newHashMap();
    private final Map<String, BlockTint> blockTintFunctions = Maps.newHashMap();
    private final Map<String, Integer> colors = Maps.newHashMap();
    private final Map<String, EntitySelector> entitySelectors = Maps.newHashMap();

    @Override
    public <T extends Content> void registerContentType(String typeName, Class<T> clazz) {
        Preconditions.checkArgument((!this.types.containsKey(typeName) ? 1 : 0) != 0, (String)"Duplicate typeName: %s", (Object)typeName);
        this.types.put(typeName, clazz);
    }

    @Override
    public <T extends Content> void registerContentType(String typeName, Class<T> clazz, Side side) {
        this.registerContentType(typeName, clazz);
        this.typeSides.put(typeName, side);
    }

    @Nullable
    Class<? extends Content> getContentClass(String typeName) {
        if (this.typeSides.containsKey(typeName) && FMLCommonHandler.instance().getSide() != this.typeSides.get(typeName)) {
            return null;
        }
        return this.types.get(typeName);
    }

    @Override
    public <T> void registerDeserializer(Type type, JsonDeserializer<T> deserializer) {
        this.deserializers.add(Pair.of((Object)type, deserializer));
    }

    @Override
    public List<Pair<Type, JsonDeserializer<?>>> getDeserializers() {
        return this.deserializers;
    }

    @Override
    public void registerLoaderPredicate(String name, LoaderPredicate predicate) {
        Preconditions.checkArgument((!this.predicates.containsKey(name) ? 1 : 0) != 0, (String)"Duplicate predicate name: %s", (Object)name);
        this.predicates.put(name, predicate);
    }

    @Override
    @Nullable
    public LoaderPredicate getPredicate(String name) {
        return this.predicates.get(name);
    }

    @Override
    public <T extends TileEntityModuleSupplier> void registerTileEntityModule(String typeName, Class<T> clazz) {
        Preconditions.checkArgument((!this.tileEntityModules.containsKey("name") ? 1 : 0) != 0, (String)"Duplicate tile entity module name: %s", (Object)typeName);
        this.tileEntityModules.put(typeName, clazz);
    }

    @Override
    public Class<? extends TileEntityModuleSupplier> getTileEntityModuleClass(String typeName) {
        return this.tileEntityModules.get(typeName);
    }

    @Override
    public <T extends ItemModuleSupplier> void registerItemModule(String typeName, Class<T> clazz) {
        Preconditions.checkArgument((!this.itemModules.containsKey("name") ? 1 : 0) != 0, (String)"Duplicate item module name: %s", (Object)typeName);
        this.itemModules.put(typeName, clazz);
    }

    @Override
    public Class<? extends ItemModuleSupplier> getItemModuleClass(String typeName) {
        return this.itemModules.get(typeName);
    }

    @Override
    public void registerBlockTint(String name, BlockTint tint) {
        Preconditions.checkArgument((!this.blockTintFunctions.containsKey(name) ? 1 : 0) != 0, (String)"Duplicate block tint name: %s", (Object)name);
        this.blockTintFunctions.put(name, tint);
    }

    @Override
    @Nullable
    public BlockTint getBlockTint(String name) {
        return this.blockTintFunctions.get(name);
    }

    @Override
    public void registerColor(String name, int rgba) {
        Preconditions.checkArgument((!this.colors.containsKey(name) ? 1 : 0) != 0, (String)"Duplicate color name: %s", (Object)name);
        this.colors.put(name, rgba);
    }

    @Override
    public int getColor(String name) {
        return this.colors.getOrDefault(name, -1);
    }

    @Override
    public void registerEntitySelector(String name, EntitySelector selector) {
        Preconditions.checkArgument((!this.entitySelectors.containsKey(name) ? 1 : 0) != 0, (String)"Duplicate selector name: %s", (Object)name);
        this.entitySelectors.put(name, selector);
    }

    @Override
    @Nullable
    public EntitySelector<?> getEntitySelector(String name) {
        return this.entitySelectors.get(name);
    }
}

