/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.screenmodules;

import java.util.List;
import mcjty.lib.api.MachineInformation;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.MachineInformationScreenModule;
import mcjty.rftools.blocks.screens.modulesclient.MachineInformationClientScreenModule;
import mcjty.rftools.items.GenericRFToolsItem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MachineInformationModuleItem
extends GenericRFToolsItem
implements IModuleProvider {
    private static final IModuleGuiBuilder.Choice[] EMPTY_CHOICES = new IModuleGuiBuilder.Choice[0];

    public MachineInformationModuleItem() {
        super("machineinformation_module");
        this.func_77625_d(1);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public Class<MachineInformationScreenModule> getServerScreenModule() {
        return MachineInformationScreenModule.class;
    }

    public Class<MachineInformationClientScreenModule> getClientScreenModule() {
        return MachineInformationClientScreenModule.class;
    }

    @Override
    public String getName() {
        return "Info";
    }

    @Override
    public void createGui(IModuleGuiBuilder guiBuilder) {
        TileEntity tileEntity;
        World world = guiBuilder.getWorld();
        NBTTagCompound currentData = guiBuilder.getCurrentData();
        IModuleGuiBuilder.Choice[] choices = EMPTY_CHOICES;
        if ((currentData.func_74764_b("monitordim") ? currentData.func_74762_e("monitordim") : currentData.func_74762_e("dim")) == world.field_73011_w.getDimension() && (tileEntity = world.func_175625_s(new BlockPos(currentData.func_74762_e("monitorx"), currentData.func_74762_e("monitory"), currentData.func_74762_e("monitorz")))) instanceof MachineInformation) {
            MachineInformation information = (MachineInformation)tileEntity;
            int count = information.getTagCount();
            choices = new IModuleGuiBuilder.Choice[count];
            for (int i = 0; i < count; ++i) {
                choices[i] = new IModuleGuiBuilder.Choice(information.getTagName(i), information.getTagDescription(i));
            }
        }
        guiBuilder.label("L:").color("color", "Color for the label").label("Txt:").color("txtcolor", "Color for the text").nl().choices("monitorTag", choices).nl().block("monitor").nl();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        list.add(TextFormatting.GREEN + "Uses " + ScreenConfiguration.MACHINEINFO_RFPERTICK + " RF/tick");
        boolean hasTarget = false;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.YELLOW + "Label: " + tagCompound.func_74779_i("text"));
            if (tagCompound.func_74764_b("monitorx")) {
                int monitorx = tagCompound.func_74762_e("monitorx");
                int monitory = tagCompound.func_74762_e("monitory");
                int monitorz = tagCompound.func_74762_e("monitorz");
                String monitorname = tagCompound.func_74779_i("monitorname");
                list.add(TextFormatting.YELLOW + "Monitoring: " + monitorname + " (at " + monitorx + "," + monitory + "," + monitorz + ")");
                hasTarget = true;
            }
        }
        if (!hasTarget) {
            list.add(TextFormatting.YELLOW + "Sneak right-click on a supported machine");
            list.add(TextFormatting.YELLOW + "to set the target for this module");
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (te instanceof MachineInformation) {
            tagCompound.func_74768_a("monitordim", world.field_73011_w.getDimension());
            tagCompound.func_74768_a("monitorx", pos.func_177958_n());
            tagCompound.func_74768_a("monitory", pos.func_177956_o());
            tagCompound.func_74768_a("monitorz", pos.func_177952_p());
            IBlockState state = player.func_130014_f_().func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (block != null && !block.isAir(state, (IBlockAccess)world, pos)) {
                name = BlockTools.getReadableName((World)world, (BlockPos)pos);
            }
            tagCompound.func_74778_a("monitorname", name);
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)("Machine Information module is set to block '" + name + "'"));
            }
        } else {
            tagCompound.func_82580_o("monitordim");
            tagCompound.func_82580_o("monitorx");
            tagCompound.func_82580_o("monitory");
            tagCompound.func_82580_o("monitorz");
            tagCompound.func_82580_o("monitorname");
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)"Machine Information module is cleared");
            }
        }
        stack.func_77982_d(tagCompound);
        return EnumActionResult.SUCCESS;
    }
}

