/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common;

import erogenousbeef.bigreactors.api.data.ReactorInteriorData;
import erogenousbeef.bigreactors.api.registry.ReactorInterior;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class DebugCommand
extends CommandBase {
    public String func_71517_b() {
        return "erdebug";
    }

    public String func_71518_a(ICommandSender sender) {
        return "erdebug you know what to do ...";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!this.areArgumentsPresent(sender, args, 2)) {
            return;
        }
        switch (args[0].toLowerCase()) {
            case "custom": {
                this.executeCustom(server, sender, args);
                break;
            }
            case "reactor": {
                this.executeReactor(server, sender, args);
            }
        }
    }

    private void executeCustom(MinecraftServer server, ICommandSender sender, String[] args) {
    }

    private void executeReactor(MinecraftServer server, ICommandSender sender, String[] args) {
        switch (args[1].toLowerCase()) {
            case "dumpmoderator": {
                if (!this.areArgumentsPresent(sender, args, 4)) {
                    return;
                }
                boolean fluid = 0 == "fluid".compareTo(args[2]);
                String name = args[3];
                ReactorInteriorData data = this.getReactorInteriorData(fluid, name);
                this.printReactorInteriorData(sender, fluid, name, data);
                break;
            }
            case "changemoderator": {
                if (!this.areArgumentsPresent(sender, args, 4)) {
                    return;
                }
                boolean fluid = 0 == "fluid".compareTo(args[2]);
                String name = args[3];
                ReactorInteriorData data = this.getReactorInteriorData(fluid, name);
                data.absorption = Float.parseFloat(args[4]);
                data.heatEfficiency = Float.parseFloat(args[5]);
                data.moderation = Float.parseFloat(args[6]);
                data.heatConductivity = Float.parseFloat(args[7]);
                this.printReactorInteriorData(sender, fluid, name, data);
                break;
            }
        }
    }

    private boolean areArgumentsPresent(ICommandSender sender, String[] args, int minimum) {
        boolean valid;
        boolean bl = valid = args.length >= minimum;
        if (!valid) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid arguments"));
        }
        return valid;
    }

    private ReactorInteriorData getReactorInteriorData(boolean fluid, String name) {
        return fluid ? ReactorInterior.getFluidData(name) : ReactorInterior.getBlockData(name);
    }

    private void printReactorInteriorData(ICommandSender sender, boolean fluid, String name, ReactorInteriorData data) {
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Reactor moderator data: %1$s (%2$s)", name, fluid ? "fluid" : "block")));
        if (null == data) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Moderator not found!"));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(" - absorption %1$f", Float.valueOf(data.absorption))));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(" - heatEfficiency %1$f", Float.valueOf(data.heatEfficiency))));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(" - moderation %1$f", Float.valueOf(data.moderation))));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(" - heatConductivity %1$f", Float.valueOf(data.heatConductivity))));
        }
    }
}

