/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.rwtema.extrautils2.power.energy.PublicEnergyWrapper;
import com.rwtema.extrautils2.power.energy.XUEnergyStorage;
import com.rwtema.extrautils2.tile.XUTile;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.datastructures.ISimpleBitSet;
import com.rwtema.extrautils2.utils.datastructures.LazySideMask;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class TileCell
extends XUTile
implements ITickable {
    public XUEnergyStorage storage = this.registerNBT("energy", this.createEnergyStorage());
    public NBTSerializable.Int extractLimit = new NBTSerializable.Int(this.getMaxLimits());
    public NBTSerializable.Int receiveLimit = new NBTSerializable.Int(this.getMaxLimits());
    public ISimpleBitSet inputFlag = this.registerNBT("sideFlag", new NBTSerializable.BitsSmall(63));
    public ISimpleBitSet outputFlag = this.registerNBT("sideFlag", new NBTSerializable.BitsSmall(63));
    int recievedThisTick = 0;
    int extractedThisTick = 0;
    LazySideMask.HasCap.Energy sideMask = new LazySideMask.HasCap.Energy();

    @Override
    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        super.onNeighborBlockChange(worldIn, pos, state, neighborBlock);
        this.sideMask.invalidateAll();
    }

    protected abstract int getMaxLimits();

    public void resetTick() {
        this.recievedThisTick = 0;
        this.extractedThisTick = 0;
    }

    public void func_73660_a() {
        if (!this.outputFlag.isEmpty() && this.storage.getEnergyStored() > 0 && this.extractedThisTick < this.extractLimit.value) {
            ArrayList<IEnergyStorage> storages = new ArrayList<IEnergyStorage>();
            for (EnumFacing facing : EnumFacing.values()) {
                IEnergyStorage energyStorage;
                TileEntity tileEntity;
                if (!this.outputFlag.get(facing.ordinal()) || (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || (energyStorage = CapGetter.energyReceiver.getInterface((ICapabilityProvider)tileEntity, facing.func_176734_d())) == null || !energyStorage.canReceive()) continue;
                storages.add(energyStorage);
            }
            if (!storages.isEmpty()) {
                int size = storages.size();
                if (size > 1) {
                    int divEnergy = Math.min(this.storage.getEnergyStored(), this.extractLimit.value - this.extractedThisTick) / size;
                    if (divEnergy > 0) {
                        for (IEnergyStorage energyStorage : storages) {
                            this.sendEnergy(energyStorage, Math.min(divEnergy, this.storage.getEnergyStored()));
                        }
                    }
                    Collections.shuffle(storages);
                }
                for (IEnergyStorage energyStorage : storages) {
                    int toSend = Math.min(this.storage.getEnergyStored(), this.extractLimit.value - this.extractedThisTick) / size;
                    if (toSend <= 0) break;
                    this.sendEnergy(energyStorage, toSend);
                }
            }
        }
        this.resetTick();
    }

    protected void sendEnergy(IEnergyStorage energyStorage, int toSend) {
        int received = energyStorage.receiveEnergy(toSend, false);
        this.extractedThisTick += this.storage.extractEnergy(received, false);
    }

    @Nonnull
    protected abstract XUEnergyStorage createEnergyStorage();

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        if (this.inputFlag.get(facing.ordinal())) {
            if (this.outputFlag.get(facing.ordinal())) {
                return this.storage;
            }
            return new PublicEnergyWrapper.Receive((IEnergyStorage)this.storage);
        }
        if (this.outputFlag.get(facing.ordinal())) {
            return new PublicEnergyWrapper.Extract((IEnergyStorage)this.storage);
        }
        return new PublicEnergyWrapper.View((IEnergyStorage)this.storage);
    }

    private class StorageInteraction
    implements IEnergyStorage {
        boolean canExtract;
        boolean canReceive;

        private StorageInteraction() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive) {
                return 0;
            }
            int maxPossible = TileCell.this.receiveLimit.value - TileCell.this.recievedThisTick;
            if (maxPossible <= 0) {
                return 0;
            }
            return TileCell.this.storage.receiveEnergy(Math.min(maxReceive, maxPossible), simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.canReceive) {
                return 0;
            }
            int maxPossible = TileCell.this.extractLimit.value - TileCell.this.extractedThisTick;
            if (maxPossible <= 0) {
                return 0;
            }
            return TileCell.this.storage.extractEnergy(Math.min(maxPossible, maxExtract), simulate);
        }

        public int getEnergyStored() {
            return TileCell.this.storage.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return TileCell.this.storage.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return this.canExtract;
        }

        public boolean canReceive() {
            return this.canReceive;
        }
    }

    public static class SurvivalCell
    extends TileCell {
        @Override
        protected int getMaxLimits() {
            return 1000;
        }

        @Override
        @Nonnull
        protected XUEnergyStorage createEnergyStorage() {
            return new XUEnergyStorage(100000);
        }
    }
}

