/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.configurator.network;

import gcewing.sg.BaseDataChannel;
import gcewing.sg.SGCraft;
import gcewing.sg.features.configurator.client.gui.ConfiguratorScreen;
import gcewing.sg.network.SGChannel;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.tileentity.data.GateAccessData;
import gcewing.sg.tileentity.data.PlayerAccessData;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ConfiguratorNetworkHandler
extends SGChannel {
    protected static BaseDataChannel configuratorChannel;

    public ConfiguratorNetworkHandler(String name) {
        super(name);
        configuratorChannel = this;
    }

    public static void sendConfiguratorInputToServer(SGBaseTE te, int secondsToStayOpen, double ringRotationSpeed, double maxEnergyBuffer, double energyPerFuelItem, int gateOpeningsPerFuelItem, double distanceFactorMultiplier, double interDimensionalMultiplier, boolean oneWayTravel, boolean hasIrisUpgrade, boolean hasChevronUpgrade, int gateType, boolean reverseWormholeKills, boolean closeFromEitherEnd, boolean preserveInventory, boolean requiresNoPower, boolean chevronsLockOnDial, boolean returnToPreviousIrisState, boolean transientDamage, boolean transparency, int orientation, boolean useDHDFuelSource, boolean allowRedstoneOutput, boolean allowRedstoneInput) {
        BaseDataChannel.ChannelOutput data = configuratorChannel.openServer("ConfiguratorInput");
        ConfiguratorNetworkHandler.writeCoords(data, te);
        data.writeInt(secondsToStayOpen);
        data.writeDouble(ringRotationSpeed);
        data.writeDouble(maxEnergyBuffer);
        data.writeDouble(energyPerFuelItem);
        data.writeInt(gateOpeningsPerFuelItem);
        data.writeDouble(distanceFactorMultiplier);
        data.writeDouble(interDimensionalMultiplier);
        data.writeBoolean(oneWayTravel);
        data.writeBoolean(hasIrisUpgrade);
        data.writeBoolean(hasChevronUpgrade);
        data.writeInt(gateType);
        data.writeBoolean(reverseWormholeKills);
        data.writeBoolean(closeFromEitherEnd);
        data.writeBoolean(preserveInventory);
        data.writeBoolean(requiresNoPower);
        data.writeBoolean(chevronsLockOnDial);
        data.writeBoolean(returnToPreviousIrisState);
        data.writeBoolean(transientDamage);
        data.writeBoolean(transparency);
        data.writeInt(orientation);
        data.writeBoolean(useDHDFuelSource);
        data.writeBoolean(allowRedstoneOutput);
        data.writeBoolean(allowRedstoneInput);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="ConfiguratorInput")
    public void handleConfiguratorInputFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        boolean isPermissionsAdmin;
        BlockPos pos = this.readCoords(data);
        SGBaseTE te = SGBaseTE.at((IBlockAccess)player.field_70170_p, pos);
        String playerName = player.func_70005_c_();
        int secondsToStayOpen = data.readInt();
        double ringRotationSpeed = data.readDouble();
        double maxEnergyBuffer = data.readDouble();
        double energyPerFuelItem = data.readDouble();
        int gateOpeningsPerFuelItem = data.readInt();
        double distanceFromMultiplier = data.readDouble();
        double interDimensionalMultiplier = data.readDouble();
        boolean oneWayTravel = data.readBoolean();
        boolean hasIrisUpgrade = data.readBoolean();
        boolean hasChevronUpgrade = data.readBoolean();
        int gateType = data.readInt();
        boolean reverseWormholeKills = data.readBoolean();
        boolean closeFromEitherEnd = data.readBoolean();
        boolean preserveInventory = data.readBoolean();
        boolean requiresNoPower = data.readBoolean();
        boolean chevronsLockOnDial = data.readBoolean();
        boolean returnToPreviousIrisState = data.readBoolean();
        boolean transientDamage = data.readBoolean();
        boolean transparency = data.readBoolean();
        int orientation = data.readInt();
        boolean useDHDFuelSource = data.readBoolean();
        boolean allowRedstoneOutput = data.readBoolean();
        boolean allowRedstoneInput = data.readBoolean();
        boolean bl = isPermissionsAdmin = SGCraft.hasPermissionSystem() && SGCraft.hasPermission(player, "sgcraft.admin");
        if (SGCraft.hasPermission(player, "sgcraft.gui.configurator") && te.allowAdminAccess(playerName) || isPermissionsAdmin) {
            if (SGCraft.hasPermission(player, "sgcraft.configurator.secondsToStayOpen") || isPermissionsAdmin) {
                te.secondsToStayOpen = secondsToStayOpen;
                te.ticksToStayOpen = te.secondsToStayOpen * 20;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.ringRotationSpeed") || isPermissionsAdmin) {
                te.ringRotationSpeed = ringRotationSpeed;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.maxEnergyBuffer") || isPermissionsAdmin) {
                te.maxEnergyBuffer = maxEnergyBuffer;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.energyPerFuelItem") || isPermissionsAdmin) {
                te.energyPerFuelItem = energyPerFuelItem;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.gateOpeningsPerFuelItem") || isPermissionsAdmin) {
                te.gateOpeningsPerFuelItem = gateOpeningsPerFuelItem;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.distanceFactorMultiplier") || isPermissionsAdmin) {
                te.distanceFactorMultiplier = distanceFromMultiplier;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.interDimensionalMultiplier") || isPermissionsAdmin) {
                te.interDimensionMultiplier = interDimensionalMultiplier;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.oneWayTravel") || isPermissionsAdmin) {
                te.oneWayTravel = oneWayTravel;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.hasIrisUpgrade") || isPermissionsAdmin) {
                te.hasIrisUpgrade = hasIrisUpgrade;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.hasChevronUpgrade") || isPermissionsAdmin) {
                te.hasChevronUpgrade = hasChevronUpgrade;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.gateType") || isPermissionsAdmin) {
                te.gateType = gateType;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.reverseWormholeKills") || isPermissionsAdmin) {
                te.reverseWormholeKills = reverseWormholeKills;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.closeFromEitherEnd") || isPermissionsAdmin) {
                te.closeFromEitherEnd = closeFromEitherEnd;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.preserveInventory") || isPermissionsAdmin) {
                te.preserveInventory = preserveInventory;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.noPowerRequired") || isPermissionsAdmin) {
                te.requiresNoPower = requiresNoPower;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.chevronsLockOnDial") || isPermissionsAdmin) {
                te.chevronsLockOnDial = chevronsLockOnDial;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.returnToPreviousIrisState") || isPermissionsAdmin) {
                te.returnToPreviousIrisState = returnToPreviousIrisState;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.transientDamage") || isPermissionsAdmin) {
                te.transientDamage = transientDamage;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.transparency") || isPermissionsAdmin) {
                te.transparency = transparency;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.orientation") || isPermissionsAdmin) {
                te.gateOrientation = orientation;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.useDHDFuelSource") || isPermissionsAdmin) {
                te.useDHDFuelSource = useDHDFuelSource;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.allowRedstoneOutput") || isPermissionsAdmin) {
                te.allowRedstoneOutput = allowRedstoneOutput;
            }
            if (SGCraft.hasPermission(player, "sgcraft.configurator.allowRedstoneInput") || isPermissionsAdmin) {
                te.allowRedstoneInput = allowRedstoneInput;
            }
            SGBaseTE.sendBasicMsg(player, "changesSaved", new Object[0]);
            te.updateIrisEntity();
            te.markForUpdate();
        }
    }

    public static void sendGateAddressAccessInputToServer(SGBaseTE te, String address, boolean defaultAllowIncoming, boolean defaultAllowOutgoing, boolean allowIncoming, boolean allowOutgoing) {
        BaseDataChannel.ChannelOutput data = configuratorChannel.openServer("GateAddressAccessInput");
        ConfiguratorNetworkHandler.writeCoords(data, te);
        data.writeUTF(address);
        data.writeBoolean(defaultAllowIncoming);
        data.writeBoolean(defaultAllowOutgoing);
        data.writeBoolean(allowIncoming);
        data.writeBoolean(allowOutgoing);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="GateAddressAccessInput")
    public void handleGateAddressAccessInputFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        boolean isPermissionsAdmin;
        BlockPos pos = this.readCoords(data);
        SGBaseTE te = SGBaseTE.at((IBlockAccess)player.field_70170_p, pos);
        String address = data.readUTF();
        String playerName = player.func_70005_c_();
        boolean defaultAllowIncoming = data.readBoolean();
        boolean defaultAllowOutgoing = data.readBoolean();
        boolean allowIncoming = data.readBoolean();
        boolean allowOutgoing = data.readBoolean();
        if (te == null) {
            System.err.println("SGCraft - HandleGAA Exception - SGBaseTE disappeared");
            return;
        }
        boolean bl = isPermissionsAdmin = SGCraft.hasPermissionSystem() && SGCraft.hasPermission(player, "sgcraft.admin");
        if (SGCraft.hasPermission(player, "sgcraft.gui.configurator") && te.allowAdminAccess(playerName) || isPermissionsAdmin) {
            if (address.isEmpty()) {
                te.defaultAllowIncoming = defaultAllowIncoming;
                te.defaultAllowOutgoing = defaultAllowOutgoing;
            }
            if (!address.isEmpty()) {
                te.setAllowIncomingAddress(address, allowIncoming);
                te.setAllowOutgoingAddress(address, allowOutgoing);
            }
        }
        te.markForUpdate();
    }

    public static void sendPlayerAccessInputToServer(SGBaseTE te, String playerName, boolean defaultAllowAccess, boolean defaultAllowIris, boolean defaultAllowAdmin, boolean allowAccess, boolean allowIris, boolean allowAdmin) {
        BaseDataChannel.ChannelOutput data = configuratorChannel.openServer("PlayerAccessInput");
        ConfiguratorNetworkHandler.writeCoords(data, te);
        data.writeUTF(playerName);
        data.writeBoolean(defaultAllowAccess);
        data.writeBoolean(defaultAllowIris);
        data.writeBoolean(defaultAllowAdmin);
        data.writeBoolean(allowAccess);
        data.writeBoolean(allowIris);
        data.writeBoolean(allowAdmin);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="PlayerAccessInput")
    public void handlePlayerAccessInputFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        boolean isPermissionsAdmin;
        BlockPos pos = this.readCoords(data);
        SGBaseTE te = SGBaseTE.at((IBlockAccess)player.field_70170_p, pos);
        String playerName = data.readUTF();
        boolean defaultAllowAccess = data.readBoolean();
        boolean defaultAllowIris = data.readBoolean();
        boolean defaultAllowAdmin = data.readBoolean();
        boolean allowAccess = data.readBoolean();
        boolean allowIris = data.readBoolean();
        boolean allowAdmin = data.readBoolean();
        if (te == null) {
            System.err.println("SGCraft - HandleGAA Exception - SGBaseTE disappeared");
            return;
        }
        boolean bl = isPermissionsAdmin = SGCraft.hasPermissionSystem() && SGCraft.hasPermission(player, "sgcraft.admin");
        if (SGCraft.hasPermission(player, "sgcraft.gui.configurator") && te.allowAdminAccess(playerName) || isPermissionsAdmin) {
            if (playerName.isEmpty()) {
                te.defaultAllowGateAccess = defaultAllowAccess;
                te.defaultAllowIrisAccess = defaultAllowIris;
                te.defaultAllowAdminAccess = defaultAllowAdmin;
            }
            te.setAllowGateAccessAccess(playerName, allowAccess);
            te.setAllowAccessToIrisController(playerName, allowIris);
            te.setAllowAccessAdmin(playerName, allowAdmin);
            te.markChanged();
        }
    }

    public static void sendGAAEntryUpdateToServer(SGBaseTE te, String oldAddress, String newAddress, int function) {
        BaseDataChannel.ChannelOutput data = configuratorChannel.openServer("GAAInputEntry");
        ConfiguratorNetworkHandler.writeCoords(data, te);
        data.writeUTF(oldAddress);
        data.writeUTF(newAddress);
        data.writeInt(function);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="GAAInputEntry")
    public void handleGAAEntryUpdateFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        boolean isPermissionsAdmin;
        BlockPos pos = this.readCoords(data);
        SGBaseTE localGate = SGBaseTE.at((IBlockAccess)player.field_70170_p, pos);
        String playerName = player.func_70005_c_();
        String oldAddress = data.readUTF();
        String newAddress = data.readUTF();
        int function = data.readInt();
        if (localGate == null) {
            System.err.println("SGCraft - HandleGAA Exception - SGBaseTE disappeared");
            return;
        }
        boolean bl = isPermissionsAdmin = SGCraft.hasPermissionSystem() && SGCraft.hasPermission(player, "sgcraft.admin");
        if (SGCraft.hasPermission(player, "sgcraft.gui.configurator") && localGate.allowAdminAccess(playerName) || isPermissionsAdmin) {
            if (localGate.getGateAccessData() != null) {
                Optional<GateAccessData> gateAccessEntry;
                if (oldAddress.isEmpty() && function == 1) {
                    localGate.getGateAccessData().add(new GateAccessData(newAddress, true, true));
                }
                if (localGate.getGateAccessData() != null && (gateAccessEntry = localGate.getGateAccessData().stream().filter(g -> g.getAddress().equalsIgnoreCase(oldAddress)).findFirst()).isPresent()) {
                    if (!oldAddress.isEmpty() && !newAddress.isEmpty() && function == 2) {
                        gateAccessEntry.get().setAddress(newAddress);
                    }
                    if (!oldAddress.isEmpty() && function == 3) {
                        localGate.getGateAccessData().remove(gateAccessEntry.get());
                    }
                }
                localGate.markChanged();
            } else {
                System.out.println("Exception in handleGAAEntryUpdateFromClient Handler");
            }
        }
    }

    public static void sendPAEntryUpdateToServer(SGBaseTE te, String oldName, String newName, int function) {
        BaseDataChannel.ChannelOutput data = configuratorChannel.openServer("PAInputEntry");
        ConfiguratorNetworkHandler.writeCoords(data, te);
        data.writeUTF(oldName);
        data.writeUTF(newName);
        data.writeInt(function);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="PAInputEntry")
    public void handlePAEntryUpdateFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        boolean isPermissionsAdmin;
        BlockPos pos = this.readCoords(data);
        SGBaseTE localGate = SGBaseTE.at((IBlockAccess)player.field_70170_p, pos);
        String playerName = player.func_70005_c_();
        String oldName = data.readUTF();
        String newName = data.readUTF();
        int function = data.readInt();
        if (localGate == null) {
            System.err.println("SGCraft - HandleGAA Exception - SGBaseTE disappeared");
            return;
        }
        boolean bl = isPermissionsAdmin = SGCraft.hasPermissionSystem() && SGCraft.hasPermission(player, "sgcraft.admin");
        if ((SGCraft.hasPermission(player, "sgcraft.gui.configurator") && localGate.allowAdminAccess(playerName) || isPermissionsAdmin) && localGate.getPlayerAccessData() != null) {
            Optional<PlayerAccessData> playerAccessEntry;
            if (oldName.isEmpty() && function == 1) {
                localGate.getPlayerAccessData().add(new PlayerAccessData(newName, true, true, player.func_70005_c_().equalsIgnoreCase(newName)));
            }
            if (localGate.getPlayerAccessData() != null && (playerAccessEntry = localGate.getPlayerAccessData().stream().filter(g -> g.getPlayerName().equalsIgnoreCase(oldName)).findFirst()).isPresent()) {
                if (!oldName.isEmpty() && !newName.isEmpty() && function == 2) {
                    playerAccessEntry.get().setPlayerName(newName);
                }
                if (!oldName.isEmpty() && function == 3) {
                    localGate.getPlayerAccessData().remove(playerAccessEntry.get());
                }
            }
            localGate.markChanged();
        }
    }

    public static void openGuiAtClient(SGBaseTE te, EntityPlayer player, int guiType, boolean isAdmin, boolean secondsToStayOpenPerm, boolean gateRotationSpeedPerm, boolean energyBufferSizePerm, boolean energyPerNaquadahPerm, boolean openingsPerNaquadahPerm, boolean distanceFactorMultiplierPerm, boolean interDimensionalMultiplierPerm, boolean oneWayTravelOnlyPerm, boolean irisUpgradePerm, boolean chevronUpgradePerm, boolean pegasusGateTypePerm, boolean reverseWormholeKillsPerm, boolean closeFromEitherEndPerm, boolean preserveInventoryOnIrisDeathPerm, boolean noInputPowerRequiredPerm, boolean chevronsLockOnDialPerm, boolean returnToPreviousIrisStatePerm, boolean transientDamagePerm, boolean transparencyPerm, boolean dhdAsFuelSourcePerm, boolean allowRedstoneOutputPerm, boolean allowRedstoneInputPerm, boolean gateAccessPerm, boolean playerAccessPerm) {
        BaseDataChannel.ChannelOutput data = configuratorChannel.openPlayer(player, "OpenConfiguratorGUI");
        ConfiguratorNetworkHandler.writeCoords(data, te);
        data.writeInt(guiType);
        data.writeBoolean(isAdmin);
        data.writeBoolean(secondsToStayOpenPerm);
        data.writeBoolean(gateRotationSpeedPerm);
        data.writeBoolean(energyBufferSizePerm);
        data.writeBoolean(energyPerNaquadahPerm);
        data.writeBoolean(openingsPerNaquadahPerm);
        data.writeBoolean(distanceFactorMultiplierPerm);
        data.writeBoolean(interDimensionalMultiplierPerm);
        data.writeBoolean(oneWayTravelOnlyPerm);
        data.writeBoolean(irisUpgradePerm);
        data.writeBoolean(chevronUpgradePerm);
        data.writeBoolean(pegasusGateTypePerm);
        data.writeBoolean(reverseWormholeKillsPerm);
        data.writeBoolean(closeFromEitherEndPerm);
        data.writeBoolean(preserveInventoryOnIrisDeathPerm);
        data.writeBoolean(noInputPowerRequiredPerm);
        data.writeBoolean(chevronsLockOnDialPerm);
        data.writeBoolean(returnToPreviousIrisStatePerm);
        data.writeBoolean(transientDamagePerm);
        data.writeBoolean(transparencyPerm);
        data.writeBoolean(dhdAsFuelSourcePerm);
        data.writeBoolean(allowRedstoneOutputPerm);
        data.writeBoolean(allowRedstoneInputPerm);
        data.writeBoolean(gateAccessPerm);
        data.writeBoolean(playerAccessPerm);
        data.close();
    }

    @BaseDataChannel.ClientMessageHandler(value="OpenConfiguratorGUI")
    public void handleGuiOpenRequest(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        BlockPos pos = this.readCoords(data);
        int guiType = data.readInt();
        boolean isAdmin = data.readBoolean();
        boolean secondsToStayOpenPerm = data.readBoolean();
        boolean gateRotationSpeedPerm = data.readBoolean();
        boolean energyBufferSizePerm = data.readBoolean();
        boolean energyPerNaquadahPerm = data.readBoolean();
        boolean openingsPerNaquadahPerm = data.readBoolean();
        boolean distanceFactoryMultiplierPerm = data.readBoolean();
        boolean interDimensionalMultiplierPerm = data.readBoolean();
        boolean oneWayTravelOnlyPerm = data.readBoolean();
        boolean irisUpgradePerm = data.readBoolean();
        boolean chevronUpgradePerm = data.readBoolean();
        boolean pegasusGateTypePerm = data.readBoolean();
        boolean reverseWormholeKillsPerm = data.readBoolean();
        boolean closeFromEitherEndPerm = data.readBoolean();
        boolean preserveInventoryOnIrisDeathPerm = data.readBoolean();
        boolean noInputPowerRequiredPerm = data.readBoolean();
        boolean chevronsLockOnDialPerm = data.readBoolean();
        boolean returnToPreviousIrisStatePerm = data.readBoolean();
        boolean transientDamagePerm = data.readBoolean();
        boolean transparencyPerm = data.readBoolean();
        boolean dhdAsFuelSourcePerm = data.readBoolean();
        boolean allowRedstoneOutputPerm = data.readBoolean();
        boolean allowRedstoneInputPerm = data.readBoolean();
        boolean gateAccessPerm = data.readBoolean();
        boolean playerAccessPerm = data.readBoolean();
        if (guiType == 1) {
            new ConfiguratorScreen(player, player.field_70170_p, isAdmin, secondsToStayOpenPerm, gateRotationSpeedPerm, energyBufferSizePerm, energyPerNaquadahPerm, openingsPerNaquadahPerm, distanceFactoryMultiplierPerm, interDimensionalMultiplierPerm, oneWayTravelOnlyPerm, irisUpgradePerm, chevronUpgradePerm, pegasusGateTypePerm, reverseWormholeKillsPerm, closeFromEitherEndPerm, preserveInventoryOnIrisDeathPerm, noInputPowerRequiredPerm, chevronsLockOnDialPerm, returnToPreviousIrisStatePerm, transientDamagePerm, transparencyPerm, dhdAsFuelSourcePerm, allowRedstoneOutputPerm, allowRedstoneInputPerm, gateAccessPerm, playerAccessPerm).display();
        }
    }
}

