/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemFoodBase;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class ItemCoffee
extends ItemFoodBase {
    public ItemCoffee(String name) {
        super(8, 5.0f, false, name);
        this.func_77656_e(3);
        this.func_77848_i();
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public static void initIngredients() {
        Item item;
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new MilkIngredient(Ingredient.func_193367_a((Item)Items.field_151117_aB)));
        if (Loader.isModLoaded((String)"harvestcraft") && (item = ItemUtil.getItemFromName("harvestcraft:soymilkitem")) != null) {
            ActuallyAdditionsAPI.addCoffeeMachineIngredient(new MilkIngredient(Ingredient.func_193367_a((Item)item)));
        }
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(Ingredient.func_193368_a((Item[])new Item[]{Items.field_151102_aT}), 4, new PotionEffect(MobEffects.field_76424_c, 30, 0)));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(Ingredient.func_193368_a((Item[])new Item[]{Items.field_151064_bs}), 2, new PotionEffect(MobEffects.field_76426_n, 20, 0)));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151115_aP, 1, 3)}), 2, new PotionEffect(MobEffects.field_76427_o, 10, 0)));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(Ingredient.func_193368_a((Item[])new Item[]{Items.field_151150_bK}), 2, new PotionEffect(MobEffects.field_76439_r, 30, 0)));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(Ingredient.func_193368_a((Item[])new Item[]{Items.field_151073_bk}), 3, new PotionEffect(MobEffects.field_76428_l, 5, 0)));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(Ingredient.func_193368_a((Item[])new Item[]{Items.field_151065_br}), 4, new PotionEffect(MobEffects.field_76420_g, 15, 0)));
        ActuallyAdditionsAPI.addCoffeeMachineIngredient(new CoffeeIngredient(Ingredient.func_193368_a((Item[])new Item[]{Items.field_151071_bq}), 2, new PotionEffect(MobEffects.field_76441_p, 25, 0)));
    }

    @Nullable
    public static CoffeeIngredient getIngredientFromStack(ItemStack stack) {
        for (CoffeeIngredient ingredient : ActuallyAdditionsAPI.COFFEE_MACHINE_INGREDIENTS) {
            if (!ingredient.getInput().apply(stack)) continue;
            return ingredient;
        }
        return null;
    }

    public static void applyPotionEffectsFromStack(ItemStack stack, EntityLivingBase player) {
        PotionEffect[] effects = ActuallyAdditionsAPI.methodHandler.getEffectsFromStack(stack);
        if (effects != null && effects.length > 0) {
            for (PotionEffect effect : effects) {
                player.func_70690_d(new PotionEffect(effect.func_188419_a(), effect.func_76459_b() * 20, effect.func_76458_c()));
            }
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase player) {
        ItemStack theStack = stack.func_77946_l();
        super.func_77654_b(stack, world, player);
        ItemCoffee.applyPotionEffectsFromStack(stack, player);
        theStack.func_77964_b(theStack.func_77952_i() + 1);
        if (theStack.func_77958_k() - theStack.func_77952_i() < 0) {
            return new ItemStack(InitItems.itemMisc, 1, TheMiscItems.CUP.ordinal());
        }
        return theStack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        PotionEffect[] effects = ActuallyAdditionsAPI.methodHandler.getEffectsFromStack(stack);
        if (effects != null) {
            for (PotionEffect effect : effects) {
                tooltip.add(StringUtil.localize(effect.func_76453_d()) + " " + (effect.func_76458_c() + 1) + ", " + StringUtils.func_76337_a((int)(effect.func_76459_b() * 20)));
            }
        } else {
            tooltip.add(StringUtil.localize("tooltip.actuallyadditions.coffeeCup.noEffect"));
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public static class MilkIngredient
    extends CoffeeIngredient {
        public MilkIngredient(Ingredient ingredient) {
            super(ingredient, 0, new PotionEffect[0]);
        }

        @Override
        public boolean effect(ItemStack stack) {
            PotionEffect[] effects = ActuallyAdditionsAPI.methodHandler.getEffectsFromStack(stack);
            ArrayList<PotionEffect> effectsNew = new ArrayList<PotionEffect>();
            if (effects != null && effects.length > 0) {
                for (PotionEffect effect : effects) {
                    if (effect.func_76458_c() <= 0) continue;
                    effectsNew.add(new PotionEffect(effect.func_188419_a(), effect.func_76459_b() + 120, effect.func_76458_c() - 1));
                }
                stack.func_77982_d(new NBTTagCompound());
                if (effectsNew.size() > 0) {
                    this.effects = effectsNew.toArray(new PotionEffect[effectsNew.size()]);
                    ActuallyAdditionsAPI.methodHandler.addEffectToStack(stack, this);
                }
            }
            this.effects = null;
            return true;
        }

        @Override
        public String getExtraText() {
            return StringUtil.localize("container.nei.actuallyadditions.coffee.extra.milk");
        }
    }
}

