/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils;

import asmodeuscore.core.utils.ACDamageSource$JsonUtils;
import asmodeuscore.core.utils.ACDamageSource$Utils$FluidType;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;

public class Utils {
    public static TextureAtlasSprite missingIcon;
    private static TextureMap texMap;
    private static volatile transient Object[] \u3f33;

    public static void initFluidTextures(TextureMap map) {
        missingIcon = map.func_174944_f();
        texMap = map;
    }

    public static TextureAtlasSprite getBlockTexture(Block block) {
        return Utils.getBlockTexture(block, "");
    }

    public static TextureAtlasSprite getBlockTexture(Block block, String addpath) {
        if (block == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = block.getRegistryName();
        TextureAtlasSprite sprite = texMap.func_110572_b((String)Utils.\uadb5("\u4e2e", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)new StringBuilder(), (String)spriteLocation.func_110624_b()), (String)ACDamageSource$Utils$FluidType.\u6934("\ud4d1\ua5df\uf90c\u10da\u8c86\uafe1\u6cbb\u4372")), (String)spriteLocation.func_110623_a()), (String)addpath)));
        return sprite != null ? sprite : missingIcon;
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid, FluidType type) {
        if (fluid == null || type == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getStill() : fluid.getFlowing();
        TextureAtlasSprite sprite = texMap.getTextureExtry(spriteLocation.toString());
        return sprite != null ? sprite : missingIcon;
    }

    public static void drawFluid(int xPos, int yPos, int scale, FluidStack fluid) {
        int renderRemaining;
        if (fluid == null) {
            return;
        }
        int guiWidth = 0;
        int guiHeight = 0;
        int start = 0;
        do {
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Utils.drawTexturedModalRect(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, Utils.getFluidTexture(fluid.getFluid(), FluidType.STILL), 16, 16 - (16 - renderRemaining));
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        double zLevel = 0.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static int getIntColor(int r, int g, int b, int a) {
        int A = a * 256 * 256 * 256;
        int R = r * 256 * 256;
        int G = g * 256;
        int B = b;
        int color = A + R + G + B;
        return color - 0x1000000;
    }

    public static float calculateCelestialAngle(long worldtime, float ticks, float daylenght) {
        int j = (int)((float)worldtime % daylenght);
        float f1 = ((float)j + ticks) / daylenght - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Utils.\u1e9f("\u0b85", (double)((double)f1 * Math.PI)) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    public static List<Integer> getPossibleDimensionsForSpaceshipTier(int tier, EntityPlayerMP playerBase) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        if (!ConfigManagerCore.disableRocketsToOverworld) {
            temp.add((Integer)Utils.\u6aed("\u7658", (int)ConfigManagerCore.idDimensionOverworld));
        }
        for (Integer element : WorldUtil.registeredPlanets) {
            WorldProvider provider;
            if (Utils.\u7b46("\u895e", (Integer)element) == ConfigManagerCore.idDimensionOverworld || (provider = WorldUtil.getProviderForDimensionServer((int)Utils.\u7b46("\u895e", (Integer)element))) == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        Iterator iterator = Utils.\ub25b("\ud1e5", (HashMap)WorldUtil.registeredSpaceStations).iterator();
        while (iterator.hasNext()) {
            WorldProvider homeWorld;
            Integer element;
            element = (Integer)iterator.next();
            SpaceStationWorldData data = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)Utils.\u7b46("\u895e", (Integer)element), null);
            if (ConfigManagerCore.spaceStationsRequirePermission && !data.getAllowedAll() && Utils.\u597f("\ua7a3", (ArrayList)data.getAllowedPlayers(), (Object)PlayerUtil.getName((EntityPlayer)playerBase)) == false && !ArrayUtils.contains((Object[])playerBase.field_71133_b.func_184103_al().func_152606_n(), (Object)playerBase.func_70005_c_())) continue;
            if (playerBase != null) {
                SpaceStationWorldData dataCurrent;
                int currentWorld = playerBase.field_71093_bK;
                if (currentWorld == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
                if (playerBase.field_70170_p.field_73011_w instanceof IOrbitDimension && (dataCurrent = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)playerBase.field_71093_bK, null)).getHomePlanet() == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
            }
            if ((homeWorld = WorldUtil.getProviderForDimensionServer((int)data.getHomePlanet())) == null) continue;
            if (homeWorld instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)homeWorld).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        return temp;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(int tier, EntityPlayerMP playerBase) {
        List<Integer> ids = Utils.getPossibleDimensionsForSpaceshipTier(tier, playerBase);
        HashMap<String, Integer> map = new HashMap<String, Integer>(ids.size(), 1.0f);
        for (Integer id : ids) {
            CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForDimensionID((int)Utils.\u7b46("\u895e", (Integer)id));
            if (Utils.\u7b46("\u895e", (Integer)id) > 0 && celestialBody == null) {
                celestialBody = GalacticraftCore.satelliteSpaceStation;
                if (playerBase == null) continue;
                SpaceStationWorldData data = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)Utils.\u7b46("\u895e", (Integer)id), null);
                Utils.\uc016("\u5274", map, (Object)Utils.\uadb5("\u4e2e", (StringBuilder)Utils.\ubeaf("\uc434", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)Utils.\uc381("\u8cab", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)new StringBuilder(), (String)celestialBody.getName()), (String)ACDamageSource$JsonUtils.\ua286("\u7ceb")), (String)data.getOwner()), (String)ACDamageSource$JsonUtils.\ua286("\u7ceb")), (String)data.getSpaceStationName()), (String)ACDamageSource$JsonUtils.\ua286("\u7ceb")), (Object)id), (String)ACDamageSource$JsonUtils.\ua286("\u7ceb")), (int)data.getHomePlanet())), (Object)id);
                continue;
            }
            if (celestialBody == GalacticraftCore.planetOverworld) {
                Utils.\uc016("\u5274", map, (Object)celestialBody.getName(), (Object)id);
                continue;
            }
            WorldProvider provider = WorldUtil.getProviderForDimensionServer((int)Utils.\u7b46("\u895e", (Integer)id));
            if (celestialBody == null || provider == null || (!(provider instanceof IGalacticraftWorldProvider) || provider instanceof IOrbitDimension) && GCCoreUtil.getDimensionID((WorldProvider)provider) != 0) continue;
            Utils.\uc016("\u5274", map, (Object)celestialBody.getName(), (Object)Utils.\u6aed("\u7658", (int)GCCoreUtil.getDimensionID((WorldProvider)provider)));
        }
        ArrayList cBodyList = new ArrayList();
        Utils.\u141b("\u15c1", cBodyList, GalaxyRegistry.getRegisteredPlanets().values());
        Utils.\u141b("\u15c1", cBodyList, GalaxyRegistry.getRegisteredMoons().values());
        Object object = Utils.\u7a0b("\ub640", cBodyList);
        while (object.hasNext()) {
            CelestialBody body = (CelestialBody)object.next();
            if (body.getReachable()) continue;
            Utils.\uc016("\u5274", map, (Object)Utils.\uadb5("\u4e2e", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)Utils.\u7d7e("\uc08c", (StringBuilder)new StringBuilder(), (String)body.getLocalizedName()), (String)ACDamageSource$JsonUtils.\ua286("\u7ce5"))), (Object)Utils.\u6aed("\u7658", (int)body.getDimensionID()));
        }
        WorldUtil.celestialMapCache.put(playerBase, map);
        return map;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensionsAgain(int tier, EntityPlayerMP playerBase) {
        HashMap map = (HashMap)WorldUtil.celestialMapCache.get(playerBase);
        if (map != null) {
            return map;
        }
        return Utils.getArrayOfPossibleDimensions(tier, playerBase);
    }

    static {
        texMap = null;
    }

    private static Object \u141b(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[6] == null) {
            Utils.\u3f33[6] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ACDamageSource$Utils$FluidType.\u6934("\ud481\ua5dc\uf916\u10d4\u8ccb\uafff\u6cbc\u4334\u473c\ud940\u1057\u5238\uf4df\u4a7b\u8113\u7325\uab91\u8ba7\uf967")), ACDamageSource$Utils$FluidType.\u6934("\ud48a\ua5d9\uf904\u10f4\u8c89\uafe6"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u3f33[6];
    }

    private static Object \ubeaf(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[0] == null) {
            Utils.\u3f33[0] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ACDamageSource$JsonUtils.\ua286("\u7ca5\u6b06\ufaca\u05c8\uad0a\u1152\ub2fc\udb72\ua8f6\udb62\u0adf\u0929\ua44c\uecbc\u3913\ubaaf\ucfaf\ud05f\u3c5d\ued11\ud583\ue4b3\ud0ec")), ACDamageSource$JsonUtils.\ua286("\u7cae\u6b17\ufacc\u05cc\uad4a\u115a"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u3f33[0];
    }

    private static Object \u6aed(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[11] == null) {
            Utils.\u3f33[11] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(ACDamageSource$JsonUtils.\ua286("\u7ca5\u6b06\ufaca\u05c8\uad0a\u1152\ub2fc\udb72\ua8f6\udb62\u0ac5\u0933\ua44a\uecb0\u391a\ubaad\ucf9f")), ACDamageSource$JsonUtils.\ua286("\u7cb9\u6b06\ufad0\u05dc\uad41\u1171\ub2fb"), methodType).asType(methodType));
        }
        return \u3f33[11];
    }

    private static Object \uadb5(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[1] == null) {
            Utils.\u3f33[1] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ACDamageSource$Utils$FluidType.\u6934("\ud481\ua5dc\uf916\u10d4\u8ccb\uafe6\u6ca9\u4333\u4737\ud940\u1045\u523e\uf4df\u4a73\u8104\u730e\uabba\u8ba1\uf97a\u5ed2\ua7b5\u9db8\uce44")), ACDamageSource$Utils$FluidType.\u6934("\ud49f\ua5d2\uf933\u10c1\u8c97\uafe3\u6ca6\u433a"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u3f33[1];
    }

    private static Object \ub25b(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[8] == null) {
            Utils.\u3f33[8] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ACDamageSource$Utils$FluidType.\u6934("\ud481\ua5dc\uf916\u10d4\u8ccb\uafff\u6cbc\u4334\u473c\ud940\u105e\u522b\uf4de\u4a72\u8127\u7308\uab88")), ACDamageSource$Utils$FluidType.\u6934("\ud480\ua5d8\uf919\u10e6\u8c80\uaffe"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u3f33[8];
    }

    private static Object \u7b46(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[4] == null) {
            Utils.\u3f33[4] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ACDamageSource$JsonUtils.\ua286("\u7ca5\u6b06\ufaca\u05c8\uad0a\u1152\ub2fc\udb72\ua8f6\udb62\u0ac5\u0933\ua44a\uecb0\u391a\ubaad\ucf9f")), ACDamageSource$JsonUtils.\ua286("\u7ca6\u6b09\ufac8\u05ff\uad45\u1152\ub2e8\udb79"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u3f33[4];
    }

    private static Object \u597f(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[2] == null) {
            Utils.\u3f33[2] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ACDamageSource$JsonUtils.\ua286("\u7ca5\u6b06\ufaca\u05c8\uad0a\u114b\ub2e9\udb75\ua8fd\udb62\u0acd\u092f\ua44c\uecb4\u3904\uba84\ucf84\ud059\u3c40")), ACDamageSource$JsonUtils.\ua286("\u7cac\u6b08\ufad2\u05dd\uad45\u1157\ub2f3\udb6f"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u3f33[2];
    }

    private static Object \u7a0b(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[10] == null) {
            Utils.\u3f33[10] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ACDamageSource$Utils$FluidType.\u6934("\ud481\ua5dc\uf916\u10d4\u8ccb\uafff\u6cbc\u4334\u473c\ud940\u1057\u5238\uf4df\u4a7b\u8113\u7325\uab91\u8ba7\uf967")), ACDamageSource$Utils$FluidType.\u6934("\ud482\ua5c9\uf905\u10c7\u8c84\uaffe\u6ca7\u432f"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u3f33[10];
    }

    private static Object \u1e9f(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[3] == null) {
            Utils.\u3f33[3] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(ACDamageSource$Utils$FluidType.\u6934("\ud481\ua5dc\uf916\u10d4\u8ccb\uafe6\u6ca9\u4333\u4737\ud940\u105b\u522b\uf4d9\u4a72")), ACDamageSource$Utils$FluidType.\u6934("\ud488\ua5d2\uf913"), methodType).asType(methodType));
        }
        return \u3f33[3];
    }

    private static Object \u7d7e(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[7] == null) {
            Utils.\u3f33[7] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ACDamageSource$JsonUtils.\ua286("\u7ca5\u6b06\ufaca\u05c8\uad0a\u1152\ub2fc\udb72\ua8f6\udb62\u0adf\u0929\ua44c\uecbc\u3913\ubaaf\ucfaf\ud05f\u3c5d\ued11\ud583\ue4b3\ud0ec")), ACDamageSource$JsonUtils.\ua286("\u7cae\u6b17\ufacc\u05cc\uad4a\u115a"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u3f33[7];
    }

    private static Object \uc016(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[5] == null) {
            Utils.\u3f33[5] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ACDamageSource$JsonUtils.\ua286("\u7ca5\u6b06\ufaca\u05c8\uad0a\u114b\ub2e9\udb75\ua8fd\udb62\u0ac4\u093c\ua44d\uecbd\u3930\ubaa9\ucf9d")), ACDamageSource$JsonUtils.\ua286("\u7cbf\u6b12\ufac8"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u3f33[5];
    }

    private static Object \uc381(Object object, String string, MethodType methodType) {
        if (\u3f33 == null) {
            \u3f33 = new Object[12];
        }
        if (\u3f33[9] == null) {
            Utils.\u3f33[9] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(ACDamageSource$Utils$FluidType.\u6934("\ud481\ua5dc\uf916\u10d4\u8ccb\uafe6\u6ca9\u4333\u4737\ud940\u1045\u523e\uf4df\u4a73\u8104\u730e\uabba\u8ba1\uf97a\u5ed2\ua7b5\u9db8\uce44")), ACDamageSource$Utils$FluidType.\u6934("\ud48a\ua5cd\uf910\u10d0\u8c8b\uafee"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \u3f33[9];
    }

    public static enum FluidType {
        STILL,
        FLOWING;

        private static volatile transient Object[] \u83cb;

        private static Object \u929c(Object object, String string, MethodType methodType) {
            if (\u83cb == null) {
                \u83cb = new Object[1];
            }
            if (\u83cb[0] == null) {
                FluidType.\u83cb[0] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(ACDamageSource$JsonUtils.\ua286("\u7ca5\u6b06\ufaca\u05c8\uad0a\u1152\ub2fc\udb72\ua8f6\udb62\u0ac9\u0933\ua44b\uecb8")), ACDamageSource$JsonUtils.\ua286("\u7cb9\u6b06\ufad0\u05dc\uad41\u1171\ub2fb"), methodType).asType(methodType));
            }
            return \u83cb[0];
        }
    }
}

