/*
 * Decompiled with CFR 0.152.
 */
package net.slayer5934.chococraft.common.commands;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.slayer5934.chococraft.common.entities.EntityChocobo;
import net.slayer5934.chococraft.common.entities.properties.ChocoboAttributes;
import org.apache.logging.log4j.util.BiConsumer;

public class CommandChocobo
extends CommandBase {
    private static final String MODID = "chococraft";
    private static final Map<String, BiConsumer<EntityChocobo, String>> setMap = new HashMap<String, BiConsumer<EntityChocobo, String>>();

    public String func_71517_b() {
        return "chocobo";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/chocobo list\n/chocobo set <trait> <value>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            return;
        }
        if (!(sender instanceof EntityPlayer)) {
            return;
        }
        Entity mount = ((EntityPlayer)sender).func_184187_bx();
        if (!(mount instanceof EntityChocobo)) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("cmd.chococraft.chocobo.not_riding_chocobo", new Object[0]));
            return;
        }
        EntityChocobo chocobo = (EntityChocobo)mount;
        switch (args[0].toLowerCase()) {
            case "list": {
                sender.func_145747_a((ITextComponent)CommandChocobo.getText("get_health", chocobo, SharedMonsterAttributes.field_111267_a));
                sender.func_145747_a((ITextComponent)CommandChocobo.getText("get_resistance", chocobo, SharedMonsterAttributes.field_188791_g));
                sender.func_145747_a((ITextComponent)CommandChocobo.getText("get_speed", chocobo, SharedMonsterAttributes.field_111263_d));
                sender.func_145747_a((ITextComponent)CommandChocobo.getText("get_stamina", chocobo, ChocoboAttributes.MAX_STAMINA));
                sender.func_145747_a((ITextComponent)CommandChocobo.getText("sprint", chocobo.canSprint()));
                sender.func_145747_a((ITextComponent)CommandChocobo.getText("dive", chocobo.canDive()));
                sender.func_145747_a((ITextComponent)CommandChocobo.getText("glide", chocobo.canGlide()));
                sender.func_145747_a((ITextComponent)CommandChocobo.getText("fly", chocobo.canFly()));
                break;
            }
            case "set": {
                if (args.length != 3) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("cmd.chococraft.chocobo.invalid_set_parameters", new Object[0]));
                    return;
                }
                if (setMap.containsKey(args[1])) {
                    setMap.get(args[1]).accept((Object)chocobo, (Object)args[2]);
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("cmd.chococraft.chocobo.successfuly_set_parameters", new Object[]{args[1], args[2]}));
            }
        }
    }

    private static TextComponentTranslation getText(String key, EntityChocobo chocobo, IAttribute attribute) {
        return new TextComponentTranslation("cmd.chococraft.chocobo." + key, new Object[]{chocobo.func_110148_a(attribute).func_111125_b()});
    }

    private static TextComponentTranslation getText(String key, boolean state) {
        return new TextComponentTranslation("cmd.chococraft.chocobo.can" + (state ? "_" : "_not_") + key, new Object[0]);
    }

    static {
        setMap.put("level", (BiConsumer<EntityChocobo, String>)((BiConsumer)(entity, arg) -> entity.setLevel(Integer.parseInt(arg))));
        setMap.put("health", (BiConsumer<EntityChocobo, String>)((BiConsumer)(entity, arg) -> entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Float.parseFloat(arg))));
        setMap.put("resistance", (BiConsumer<EntityChocobo, String>)((BiConsumer)(entity, arg) -> entity.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)Float.parseFloat(arg))));
        setMap.put("speed", (BiConsumer<EntityChocobo, String>)((BiConsumer)(entity, arg) -> entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)Float.parseFloat(arg))));
        setMap.put("stamina", (BiConsumer<EntityChocobo, String>)((BiConsumer)(entity, arg) -> entity.func_110148_a(ChocoboAttributes.MAX_STAMINA).func_111128_a((double)Float.parseFloat(arg))));
        setMap.put("sprint", (BiConsumer<EntityChocobo, String>)((BiConsumer)(entity, arg) -> entity.setCanSprint(Boolean.parseBoolean(arg))));
        setMap.put("dive", (BiConsumer<EntityChocobo, String>)((BiConsumer)(entity, arg) -> entity.setCanDive(Boolean.parseBoolean(arg))));
        setMap.put("glide", (BiConsumer<EntityChocobo, String>)((BiConsumer)(entity, arg) -> entity.setCanGlide(Boolean.parseBoolean(arg))));
        setMap.put("fly", (BiConsumer<EntityChocobo, String>)((BiConsumer)(entity, arg) -> entity.setCanFly(Boolean.parseBoolean(arg))));
    }
}

