/*
 * Decompiled with CFR 0.152.
 */
package net.slayer5934.chococraft.common.tileentities;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.slayer5934.chococraft.common.ChocoConfig;
import net.slayer5934.chococraft.common.blocks.BlockChocoboEgg;
import net.slayer5934.chococraft.common.blocks.BlockStrawNest;
import net.slayer5934.chococraft.common.entities.EntityChocobo;
import net.slayer5934.chococraft.common.entities.breeding.BreedingHelper;
import net.slayer5934.chococraft.common.entities.breeding.ChocoboBreedInfo;
import net.slayer5934.chococraft.common.init.ModBlocks;

public class TileEntityChocoboNest
extends TileEntity
implements ITickable {
    private static final CheckOffset[] SHELTER_CHECK_OFFSETS = new CheckOffset[]{new CheckOffset(new Vec3i(0, 1, 0), true), new CheckOffset(new Vec3i(0, 2, 0), true), new CheckOffset(new Vec3i(-1, 3, -1), false), new CheckOffset(new Vec3i(-1, 3, 0), false), new CheckOffset(new Vec3i(-1, 3, 1), false), new CheckOffset(new Vec3i(0, 3, -1), false), new CheckOffset(new Vec3i(0, 3, 0), false), new CheckOffset(new Vec3i(0, 3, 1), false), new CheckOffset(new Vec3i(1, 3, -1), false), new CheckOffset(new Vec3i(1, 3, 0), false), new CheckOffset(new Vec3i(1, 3, 1), false)};
    public static final String NBTKEY_IS_SHELTERED = "IsSheltered";
    public static final String NBTKEY_TICKS = "Ticks";
    public static final String NBTKEY_OWNER_CHOCOBO = "Chocobo";
    public static final String NBTKEY_NEST_INVENTORY = "Inventory";
    private ItemStackHandler inventory = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            TileEntityChocoboNest.this.onInventoryChanged();
        }
    };
    private UUID ownerChocobo;
    private boolean isSheltered;
    private int ticks = 0;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.ticks;
        if (this.ticks > 1000000) {
            this.ticks = 0;
        }
        boolean changed = false;
        if (this.ticks % 5 == 0 && !this.getEggItemStack().func_190926_b()) {
            changed = this.updateEgg();
        }
        if (this.ticks % 200 == 100) {
            changed |= this.updateSheltered();
            changed |= this.updateOwner();
        }
        if (changed) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
        }
    }

    private boolean updateEgg() {
        ItemStack egg = this.getEggItemStack();
        if (!egg.func_77942_o()) {
            return false;
        }
        NBTTagCompound nbt = egg.func_190925_c("HatchingState");
        int time = nbt.func_74762_e("Time");
        ++time;
        if (this.isSheltered) {
            ++time;
        }
        nbt.func_74768_a("Time", ++time);
        if (time < ChocoConfig.breeding.eggHatchTimeTicks) {
            return false;
        }
        ChocoboBreedInfo breedInfo = ChocoboBreedInfo.getFromNbtOrDefault(egg.func_179543_a("BreedInfo"));
        EntityChocobo baby = BreedingHelper.createChild(breedInfo, this.field_145850_b);
        baby.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.2, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)baby);
        Random random = baby.func_70681_au();
        for (int i = 0; i < 7; ++i) {
            double d0 = random.nextGaussian() * 0.02;
            double d1 = random.nextGaussian() * 0.02;
            double d2 = random.nextGaussian() * 0.02;
            double d3 = random.nextDouble() * (double)baby.field_70130_N * 2.0 - (double)baby.field_70130_N;
            double d4 = 0.5 + random.nextDouble() * (double)baby.field_70131_O;
            double d5 = random.nextDouble() * (double)baby.field_70130_N * 2.0 - (double)baby.field_70130_N;
            this.field_145850_b.func_175688_a(EnumParticleTypes.HEART, baby.field_70165_t + d3, baby.field_70163_u + d4, baby.field_70161_v + d5, d0, d1, d2, new int[0]);
        }
        this.setEggItemStack(ItemStack.field_190927_a);
        return true;
    }

    private boolean updateOwner() {
        if (this.ownerChocobo != null) {
            return false;
        }
        List chocobos = this.field_145850_b.func_72872_a(EntityChocobo.class, new AxisAlignedBB(this.field_174879_c).func_72321_a(16.0, 8.0, 16.0));
        double dist = Double.MAX_VALUE;
        EntityChocobo closestChocobo = null;
        for (EntityChocobo chocobo : chocobos) {
            double d = chocobo.func_180425_c().func_177951_i((Vec3i)this.field_174879_c);
            if (!(d < dist)) continue;
            dist = d;
            closestChocobo = chocobo;
        }
        if (closestChocobo != null) {
            this.ownerChocobo = closestChocobo.func_110124_au();
            closestChocobo.setNestPosition(this.field_174879_c);
        }
        return this.ownerChocobo != null;
    }

    private boolean updateSheltered() {
        boolean changed = false;
        for (CheckOffset checkOffset : SHELTER_CHECK_OFFSETS) {
            if (this.field_145850_b.func_175623_d(this.func_174877_v().func_177971_a(checkOffset.offset)) == checkOffset.shouldBeAir) continue;
            if (this.isSheltered) {
                changed = true;
            }
            this.isSheltered = false;
            return changed;
        }
        if (!this.isSheltered) {
            changed = true;
        }
        this.isSheltered = true;
        return changed;
    }

    public ItemStack getEggItemStack() {
        return this.inventory.getStackInSlot(0);
    }

    public void setEggItemStack(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        } else if (BlockChocoboEgg.isChocoboEgg(itemStack)) {
            this.inventory.setStackInSlot(0, itemStack);
        }
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isSheltered = nbt.func_74767_n(NBTKEY_IS_SHELTERED);
        this.ticks = nbt.func_74762_e(NBTKEY_TICKS);
        if (nbt.func_74764_b(NBTKEY_OWNER_CHOCOBO)) {
            this.ownerChocobo = NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l(NBTKEY_OWNER_CHOCOBO));
        }
        this.inventory.deserializeNBT(nbt.func_74775_l(NBTKEY_NEST_INVENTORY));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a(NBTKEY_IS_SHELTERED, this.isSheltered);
        nbt.func_74768_a(NBTKEY_TICKS, this.ticks);
        if (this.ownerChocobo != null) {
            nbt.func_74782_a(NBTKEY_OWNER_CHOCOBO, (NBTBase)NBTUtil.func_186862_a((UUID)this.ownerChocobo));
        }
        nbt.func_74782_a(NBTKEY_NEST_INVENTORY, (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a(NBTKEY_NEST_INVENTORY, (NBTBase)this.inventory.serializeNBT());
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.inventory.deserializeNBT(pkt.func_148857_g().func_74775_l(NBTKEY_NEST_INVENTORY));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74782_a(NBTKEY_NEST_INVENTORY, (NBTBase)this.inventory.serializeNBT());
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.inventory.deserializeNBT(nbt.func_74775_l(NBTKEY_NEST_INVENTORY));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("chococraft.container.nest", new Object[0]);
    }

    public void onInventoryChanged() {
        this.func_70296_d();
        IBlockState newState = ModBlocks.strawNest.func_176223_P().func_177226_a((IProperty)BlockStrawNest.HAS_EGG, (Comparable)Boolean.valueOf(!this.getEggItemStack().func_190926_b()));
        this.func_145831_w().func_175656_a(this.func_174877_v(), newState);
    }

    private static class CheckOffset {
        Vec3i offset;
        boolean shouldBeAir;

        CheckOffset(Vec3i offset, boolean shouldBeAir) {
            this.offset = offset;
            this.shouldBeAir = shouldBeAir;
        }
    }
}

