/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.sync;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import sonar.core.sync.ISyncHandler;

public class SyncHandlerList<V>
implements ISyncHandler<List<V>> {
    public ISyncHandler<V> subHandler;

    public SyncHandlerList(ISyncHandler<V> subHandler) {
        Preconditions.checkState((subHandler != null ? 1 : 0) != 0);
        this.subHandler = subHandler;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound tag, String key, List<V> value) {
        NBTTagList tagList = new NBTTagList();
        for (V v : value) {
            NBTTagCompound subTag = new NBTTagCompound();
            this.subHandler.save(subTag, "v", v);
            tagList.func_74742_a((NBTBase)subTag);
        }
        if (!tagList.func_82582_d()) {
            tag.func_74782_a(key, (NBTBase)tagList);
        }
        return tag;
    }

    @Override
    public List<V> load(NBTTagCompound tag, String key) {
        ArrayList<V> list = new ArrayList<V>();
        NBTTagList tagList = tag.func_150295_c(key, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound subTag = tagList.func_150305_b(i);
            list.add(this.subHandler.load(subTag, "v"));
        }
        return list;
    }

    @Override
    public ByteBuf save(ByteBuf buf, List<V> value) {
        buf.writeInt(value.size());
        for (V v : value) {
            if (v != null) {
                buf.writeBoolean(true);
                this.subHandler.save(buf, v);
                continue;
            }
            buf.writeBoolean(false);
        }
        return buf;
    }

    @Override
    public List<V> load(ByteBuf buf) {
        ArrayList<V> list = new ArrayList<V>();
        int listSize = buf.readInt();
        for (int i = 0; i < listSize; ++i) {
            if (buf.readBoolean()) {
                list.add(this.subHandler.load(buf));
                continue;
            }
            list.add(null);
        }
        return list;
    }
}

