/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.crafting;

import com.google.common.collect.Lists;
import cubex2.cs4.api.ContentHelper;
import cubex2.cs4.api.InitPhase;
import cubex2.cs4.api.WrappedFluidStack;
import cubex2.cs4.plugins.vanilla.crafting.MachineRecipeOutput;
import cubex2.cs4.plugins.vanilla.crafting.MachineResult;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class MachineRecipeOutputImpl
implements MachineRecipeOutput {
    private static final Random random = new Random();
    private final List<MachineResult> items;
    private final List<WrappedFluidStack> fluids;
    private final NonNullList<ItemStack> outputItems = NonNullList.func_191196_a();
    private final List<FluidStack> outputFluids = Lists.newArrayList();
    private final int weight;

    public MachineRecipeOutputImpl(List<MachineResult> items, List<WrappedFluidStack> fluids, int weight) {
        this.items = items;
        this.fluids = fluids;
        this.weight = weight;
    }

    @Override
    public NonNullList<ItemStack> getOutputItems() {
        return this.outputItems;
    }

    @Override
    public NonNullList<ItemStack> getResultItems() {
        NonNullList result = NonNullList.func_191196_a();
        for (int i = 0; i < this.outputItems.size(); ++i) {
            if (random.nextFloat() < this.items.get((int)i).chance) {
                result.add((Object)((ItemStack)this.outputItems.get(i)).func_77946_l());
                continue;
            }
            result.add((Object)ItemStack.field_190927_a);
        }
        return result;
    }

    @Override
    public List<FluidStack> getOutputFluids() {
        return this.outputFluids;
    }

    @Override
    public List<FluidStack> getResultFluids() {
        return this.outputFluids.stream().map(FluidStack::copy).collect(Collectors.toList());
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public void doInit(InitPhase phase, ContentHelper helper) {
        this.items.forEach(item -> this.outputItems.add((Object)item.item.getItemStack()));
        this.fluids.forEach(fluid -> this.outputFluids.add(fluid.getFluidStack()));
    }

    public boolean isReady() {
        boolean itemsValid = this.items.stream().allMatch(result -> result.item.isItemLoaded());
        boolean fluidsValid = this.fluids.stream().allMatch(fluid -> fluid.getFluidStack() != null);
        return itemsValid && fluidsValid;
    }
}

