/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.render;

import ic2.core.energy.render.RenderPath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;

public class PathComponent {
    BlockPos position;
    PathComponent prev;
    List<PathComponent> next = new ArrayList<PathComponent>();
    double loss;
    int lvl;

    public PathComponent(BlockPos pos) {
        this.position = pos;
        this.lvl = RenderPath.counter;
    }

    public void addNext(PathComponent comp) {
        this.next.add(comp);
    }

    public void setPrev(PathComponent comp) {
        this.prev = comp;
    }

    public void setLoss(double newLoss) {
        this.loss = newLoss;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public List<PathComponent> getNext() {
        return this.next;
    }

    public PathComponent getPrev() {
        return this.prev;
    }

    public boolean isStart() {
        return this.prev == null;
    }

    public boolean isEnd() {
        return this.next.isEmpty();
    }

    public void clear() {
        if (this.prev == null && this.next.isEmpty()) {
            return;
        }
        this.next = new ArrayList<PathComponent>();
        this.prev = null;
    }

    public String toString() {
        return "Components: x: " + this.position.func_177958_n() + ", y: " + this.position.func_177956_o() + ", z: " + this.position.func_177952_p();
    }

    public int getLevel() {
        return this.lvl;
    }

    public double getLoss() {
        return this.loss;
    }
}

