/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.network.messages;

import io.netty.buffer.ByteBuf;
import lumien.randomthings.container.ContainerAnalogEmitter;
import lumien.randomthings.network.IRTMessage;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.tileentity.TileEntityAnalogEmitter;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageAnalogEmitter
implements IRTMessage {
    BlockPos pos;
    int level;

    public MessageAnalogEmitter(BlockPos pos, int level) {
        this.pos = pos;
        this.level = level;
    }

    public MessageAnalogEmitter() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = MessageUtil.readBlockPos(buf);
        this.level = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        MessageUtil.writeBlockPos(this.pos, buf);
        buf.writeInt(this.level);
    }

    @Override
    public void onMessage(final MessageContext context) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(new Runnable(){

            @Override
            public void run() {
                if (MessageAnalogEmitter.this.level > 0 && MessageAnalogEmitter.this.level < 16 && context.netHandler instanceof NetHandlerPlayServer) {
                    TileEntity te;
                    NetHandlerPlayServer handler = (NetHandlerPlayServer)context.netHandler;
                    EntityPlayerMP player = handler.field_147369_b;
                    if (player != null && player.field_71070_bA != null && player.field_71070_bA instanceof ContainerAnalogEmitter && (te = player.field_70170_p.func_175625_s(MessageAnalogEmitter.this.pos)) != null && te instanceof TileEntityAnalogEmitter) {
                        TileEntityAnalogEmitter analogEmitter = (TileEntityAnalogEmitter)te;
                        analogEmitter.setLevel(MessageAnalogEmitter.this.level);
                    }
                }
            }
        });
    }

    @Override
    public Side getHandlingSide() {
        return Side.SERVER;
    }
}

